/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.ColumnType;
import io.questdb.cutlass.http.processors.LineHttpProcessorConfiguration;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;

public class DefaultColumnTypes {
    final int[] DEFAULT_COLUMN_TYPES = new int[15];
    final int[] MAPPED_COLUMN_TYPES = new int[23];

    public DefaultColumnTypes(LineTcpReceiverConfiguration configuration) {
        this(configuration.getDefaultColumnTypeForFloat(), configuration.getDefaultColumnTypeForInteger(), configuration.isUseLegacyStringDefault());
    }

    public DefaultColumnTypes(LineHttpProcessorConfiguration configuration) {
        this(configuration.getDefaultColumnTypeForFloat(), configuration.getDefaultColumnTypeForInteger(), configuration.isUseLegacyStringDefault());
    }

    private DefaultColumnTypes(short defaultColumnTypeForFloat, short defaultColumnTypeForInteger, boolean useLegacyStringDefault) {
        this.DEFAULT_COLUMN_TYPES[1] = 12;
        this.DEFAULT_COLUMN_TYPES[2] = defaultColumnTypeForFloat;
        this.DEFAULT_COLUMN_TYPES[3] = defaultColumnTypeForInteger;
        this.DEFAULT_COLUMN_TYPES[4] = useLegacyStringDefault ? 11 : 26;
        this.DEFAULT_COLUMN_TYPES[5] = 12;
        this.DEFAULT_COLUMN_TYPES[6] = 1;
        this.DEFAULT_COLUMN_TYPES[7] = 13;
        this.DEFAULT_COLUMN_TYPES[9] = ColumnType.getGeoHashTypeWithBits(8);
        this.DEFAULT_COLUMN_TYPES[10] = ColumnType.getGeoHashTypeWithBits(16);
        this.DEFAULT_COLUMN_TYPES[11] = ColumnType.getGeoHashTypeWithBits(32);
        this.DEFAULT_COLUMN_TYPES[12] = ColumnType.getGeoHashTypeWithBits(60);
        this.DEFAULT_COLUMN_TYPES[13] = 8;
        this.DEFAULT_COLUMN_TYPES[14] = 27;
        this.MAPPED_COLUMN_TYPES[1] = 12;
        this.MAPPED_COLUMN_TYPES[2] = 9;
        this.MAPPED_COLUMN_TYPES[16] = 10;
        this.MAPPED_COLUMN_TYPES[18] = 2;
        this.MAPPED_COLUMN_TYPES[17] = 3;
        this.MAPPED_COLUMN_TYPES[3] = 5;
        this.MAPPED_COLUMN_TYPES[15] = 6;
        this.MAPPED_COLUMN_TYPES[19] = 7;
        this.MAPPED_COLUMN_TYPES[20] = 4;
        this.MAPPED_COLUMN_TYPES[4] = useLegacyStringDefault ? 11 : 26;
        this.MAPPED_COLUMN_TYPES[6] = 1;
        this.MAPPED_COLUMN_TYPES[7] = 13;
        this.MAPPED_COLUMN_TYPES[9] = ColumnType.getGeoHashTypeWithBits(8);
        this.MAPPED_COLUMN_TYPES[10] = ColumnType.getGeoHashTypeWithBits(16);
        this.MAPPED_COLUMN_TYPES[11] = ColumnType.getGeoHashTypeWithBits(32);
        this.MAPPED_COLUMN_TYPES[12] = ColumnType.getGeoHashTypeWithBits(60);
        this.MAPPED_COLUMN_TYPES[13] = 8;
        this.MAPPED_COLUMN_TYPES[14] = 27;
        this.MAPPED_COLUMN_TYPES[21] = 19;
        this.MAPPED_COLUMN_TYPES[22] = 26;
    }
}

