/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.network.Net;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;

public class LineSenderException
extends RuntimeException {
    private final StringSink message = new StringSink();
    private int errno = Integer.MIN_VALUE;

    public LineSenderException(CharSequence message) {
        this.message.put(message);
    }

    public LineSenderException(Throwable t) {
        super(t);
    }

    public LineSenderException(String message, Throwable cause) {
        super(cause);
        this.message.put(message);
    }

    public LineSenderException appendIPv4(int ip) {
        Net.appendIP4(this.message, ip);
        return this;
    }

    public LineSenderException errno(int errno) {
        this.errno = errno;
        return this;
    }

    @Override
    public String getMessage() {
        if (this.errno == Integer.MIN_VALUE) {
            return this.message.toString();
        }
        String errNoRender = "[" + this.errno + "]";
        if (this.message.length() == 0) {
            return errNoRender;
        }
        return errNoRender + " " + String.valueOf(this.message);
    }

    public LineSenderException put(char ch) {
        this.message.put(ch);
        return this;
    }

    public LineSenderException put(long value) {
        this.message.put(value);
        return this;
    }

    public LineSenderException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public LineSenderException put(Utf8Sequence cs) {
        this.message.put(cs);
        return this;
    }

    public LineSenderException putAsPrintable(CharSequence nonPrintable) {
        this.message.putAsPrintable(nonPrintable);
        return this;
    }
}

