/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.TableWriterSegmentCopyInfo;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.wal.SymbolMapDiff;
import io.questdb.cairo.wal.SymbolMapDiffCursor;
import io.questdb.cairo.wal.SymbolMapDiffEntry;
import io.questdb.cairo.wal.TableWriterPressureControl;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.cairo.wal.WalEventReader;
import io.questdb.cairo.wal.WalTxnType;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.std.DirectIntList;
import io.questdb.std.DirectLongList;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.QuietCloseable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectString;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.Nullable;

public class WalTxnDetails
implements QuietCloseable {
    public static final long FORCE_FULL_COMMIT = Long.MAX_VALUE;
    public static final long LAST_ROW_COMMIT = 0x7FFFFFFFFFFFFFFEL;
    private static final ThreadLocal<DirectString> DIRECT_STRING = new ThreadLocal<DirectString>(DirectString::new);
    private static final int FLAG_IS_LAST_SEGMENT_USAGE = 2;
    private static final int FLAG_IS_OOO = 1;
    private static final int SEQ_TXN_OFFSET = 0;
    private static final int COMMIT_TO_TIMESTAMP_OFFSET = 1;
    private static final int WAL_TXN_ID_WAL_SEG_ID_OFFSET = 2;
    private static final int WAL_TXN_MIN_TIMESTAMP_OFFSET = 3;
    private static final int WAL_TXN_MAX_TIMESTAMP_OFFSET = 4;
    private static final int WAL_TXN_ROW_LO_OFFSET = 5;
    private static final int WAL_TXN_ROW_HI_OFFSET = 6;
    private static final int WAL_TXN_ROW_IN_ORDER_DATA_TYPE = 7;
    private static final int WAL_TXN_SYMBOL_DIFF_OFFSET = 8;
    private static final int WAL_TXN_MAT_VIEW_REFRESH_TXN = 9;
    private static final int WAL_TXN_MAT_VIEW_REFRESH_TS = 10;
    private static final int WAL_TXN_REPLACE_RANGE_TS_LOW = 11;
    private static final int WAL_TXN_REPLACE_RANGE_TS_HI = 12;
    private static final int WAL_TXN_MAT_VIEW_PERIOD_HI = 13;
    public static final int TXN_METADATA_LONGS_SIZE = 14;
    private static final int SYMBOL_MAP_COLUMN_RECORD_HEADER_INTS = 6;
    private static final int SYMBOL_MAP_RECORD_HEADER_INTS = 4;
    private final CairoConfiguration config;
    private final long maxLookaheadRows;
    private final SymbolMapDiffCursorImpl symbolMapDiffCursor = new SymbolMapDiffCursorImpl();
    private final LongList transactionMeta = new LongList();
    private final WalEventReader walEventReader;
    WalTxnDetailsSlice txnSlice = new WalTxnDetailsSlice();
    private long currentSymbolIndexesStartOffset = 0L;
    private long currentSymbolStringMemStartOffset = 0L;
    private long startSeqTxn = 0L;
    private DirectIntList symbolIndexes = new DirectIntList(4L, 56);
    private MemoryCARW symbolStringsMem = null;
    private long totalRowsLoadedToApply = 0L;
    private DirectLongList txnOrder = new DirectLongList(40L, 56);

    public WalTxnDetails(FilesFacade ff, CairoConfiguration configuration, long maxLookaheadRows) {
        this.walEventReader = new WalEventReader(ff);
        this.config = configuration;
        this.maxLookaheadRows = maxLookaheadRows;
    }

    public static WalEventCursor openWalEFile(Path tempPath, WalEventReader eventReader, int segmentTxn, long seqTxn) {
        WalEventCursor walEventCursor;
        try {
            walEventCursor = eventReader.of(tempPath, segmentTxn);
        }
        catch (CairoException ex) {
            throw CairoException.critical(ex.getErrno()).put("cannot read WAL event file for seqTxn=").put(seqTxn).put(", ").put(ex.getFlyweightMessage()).put(']');
        }
        return walEventCursor;
    }

    public boolean buildTxnSymbolMap(TableWriterSegmentCopyInfo transactions, int columnIndex, MapWriter mapWriter, MemoryCARW outMem) {
        long startTxn;
        long txnCount = transactions.getTxnCount();
        int headerInts = 2;
        outMem.jumpTo(txnCount * (long)headerInts * 4L);
        DirectString directSymbolString = DIRECT_STRING.get();
        long n = startTxn + txnCount;
        for (long seqTxn = startTxn = transactions.getStartTxn(); seqTxn < n; ++seqTxn) {
            long txnSymbolOffset = this.getWalSymbolDiffCursorOffset(seqTxn) - this.currentSymbolIndexesStartOffset;
            boolean identical = true;
            long mapAppendOffset = outMem.getAppendOffset();
            int cleanSymbolCount = 0;
            if (txnSymbolOffset > -1L) {
                int mapCount = this.symbolIndexes.get(txnSymbolOffset + 1L);
                txnSymbolOffset += 4L;
                boolean notFound = true;
                while (mapCount-- > 0 && (notFound = this.symbolIndexes.get(txnSymbolOffset + 1L) != columnIndex)) {
                    txnSymbolOffset += 6L;
                }
                if (!notFound) {
                    int recordCount = this.symbolIndexes.get(txnSymbolOffset);
                    int hasNulls = this.symbolIndexes.get(txnSymbolOffset + 2L);
                    cleanSymbolCount = this.symbolIndexes.get(txnSymbolOffset + 3L);
                    int symbolStringsOffsetLo = this.symbolIndexes.get(txnSymbolOffset + 4L);
                    int symbolStringsOffsetHi = this.symbolIndexes.get(txnSymbolOffset + 5L);
                    long symbolStringsOffset = Numbers.encodeLowHighInts(symbolStringsOffsetLo, symbolStringsOffsetHi) - this.currentSymbolStringMemStartOffset;
                    if (hasNulls != 0) {
                        mapWriter.updateNullFlag(true);
                    }
                    for (int i = 0; i < recordCount; ++i) {
                        int symbolLen = this.symbolStringsMem.getInt(symbolStringsOffset);
                        assert (symbolLen >= 0 && (long)symbolLen * 2L + symbolStringsOffset < this.symbolStringsMem.getAppendOffset());
                        long addressLo = this.symbolStringsMem.addressOf(symbolStringsOffset + 4L);
                        directSymbolString.of(addressLo, addressLo + (long)symbolLen * 2L);
                        int newKey = mapWriter.put(directSymbolString);
                        identical &= newKey == i + cleanSymbolCount;
                        outMem.putInt(mapAppendOffset + ((long)i << 2), newKey);
                        symbolStringsOffset += Vm.getStorageLength(symbolLen);
                    }
                    outMem.jumpTo(mapAppendOffset + ((long)recordCount << 2));
                }
            }
            long txnIndex = transactions.getMappingOrder(seqTxn);
            assert (txnIndex > -1L && txnIndex < txnCount);
            int newAppendOffset = (int)outMem.getAppendOffset();
            if (identical) {
                outMem.putInt(txnIndex * 4L * (long)headerInts, Integer.MAX_VALUE);
                outMem.putInt(txnIndex * 4L * (long)headerInts + 4L, (int)(mapAppendOffset >> 2));
                outMem.jumpTo(mapAppendOffset);
                continue;
            }
            outMem.putInt(txnIndex * 4L * (long)headerInts, cleanSymbolCount);
            outMem.putInt(txnIndex * 4L * (long)headerInts + 4L, (int)(mapAppendOffset >> 2));
            outMem.jumpTo(newAppendOffset);
        }
        return outMem.getAppendOffset() > txnCount << 3;
    }

    public int calculateInsertTransactionBlock(long seqTxn, TableWriterPressureControl pressureControl, long maxBlockRecordCount) {
        int blockSize = 1;
        long lastSeqTxn = this.getLastSeqTxn();
        long totalRowCount = this.getSegmentRowHi(seqTxn) - this.getSegmentRowLo(seqTxn);
        maxBlockRecordCount = Math.min(maxBlockRecordCount, pressureControl.getMaxBlockRowCount() - 1L);
        long lastWalSegment = this.getWalSegment(seqTxn);
        boolean allInOrder = this.getTxnInOrder(seqTxn);
        long minTs = Long.MAX_VALUE;
        long maxTs = Long.MIN_VALUE;
        if (this.getCommitToTimestamp(seqTxn) != Long.MAX_VALUE && this.getDedupMode(seqTxn) != 3) {
            for (long nextTxn = seqTxn + 1L; nextTxn <= lastSeqTxn; ++nextTxn) {
                long currentWalSegment = this.getWalSegment(nextTxn);
                if (allInOrder) {
                    if (currentWalSegment != lastWalSegment) {
                        if (totalRowCount >= maxBlockRecordCount / 10L) break;
                        allInOrder = false;
                    } else {
                        allInOrder = this.getTxnInOrder(nextTxn) && maxTs <= this.getMinTimestamp(nextTxn);
                        minTs = Math.min(minTs, this.getMinTimestamp(nextTxn));
                        maxTs = Math.max(maxTs, this.getMaxTimestamp(nextTxn));
                    }
                }
                lastWalSegment = currentWalSegment;
                if (this.getCommitToTimestamp(nextTxn) == Long.MAX_VALUE || (totalRowCount += this.getSegmentRowHi(nextTxn) - this.getSegmentRowLo(nextTxn)) > maxBlockRecordCount || this.getDedupMode(nextTxn) == 3) break;
                ++blockSize;
            }
        }
        long lastTxn = seqTxn + (long)blockSize - 1L;
        if (blockSize > 1 && this.getCommitToTimestamp(lastTxn) != Long.MAX_VALUE) {
            while (blockSize > 1 && this.getCommitToTimestamp(lastTxn) < this.getMaxTimestamp(lastTxn) && totalRowCount > maxBlockRecordCount / 2L) {
                --blockSize;
                totalRowCount -= this.getSegmentRowHi(--lastTxn) - this.getSegmentRowLo(lastTxn);
            }
        }
        pressureControl.updateInflightTxnBlockLength(blockSize, totalRowCount);
        return blockSize;
    }

    @Override
    public void close() {
        this.symbolIndexes = Misc.free(this.symbolIndexes);
        this.symbolStringsMem = Misc.free(this.symbolStringsMem);
        this.txnOrder = Misc.free(this.txnOrder);
    }

    public long getCommitToTimestamp(long seqTxn) {
        long value = this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 1);
        return value == 0x7FFFFFFFFFFFFFFEL ? Long.MAX_VALUE : value;
    }

    public byte getDedupMode(long seqTxn) {
        int flags = Numbers.decodeLowInt(this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 7L)));
        return (byte)(flags >> 24);
    }

    public long getFullyCommittedTxn(long fromSeqTxn, long toSeqTxn, long maxCommittedTimestamp) {
        for (long seqTxn = fromSeqTxn + 1L; seqTxn <= toSeqTxn; ++seqTxn) {
            long maxTimestamp = this.getCommitMaxTimestamp(seqTxn);
            if (maxTimestamp <= maxCommittedTimestamp) continue;
            return seqTxn - 1L;
        }
        return toSeqTxn;
    }

    public long getLastSeqTxn() {
        return this.startSeqTxn + (long)(this.transactionMeta.size() / 14) - 1L;
    }

    public long getMatViewPeriodHi(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 13);
    }

    public long getMatViewRefreshTimestamp(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 10);
    }

    public long getMatViewRefreshTxn(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 9);
    }

    public long getMaxTimestamp(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 4);
    }

    public long getMinTimestamp(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 3);
    }

    public long getReplaceRangeTsHi(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 12);
    }

    public long getReplaceRangeTsLow(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 11);
    }

    public int getSegmentId(long seqTxn) {
        return Numbers.decodeLowInt(this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 2L)));
    }

    public long getSegmentRowHi(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 6);
    }

    public long getSegmentRowLo(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L) + 5);
    }

    public boolean getTxnInOrder(long seqTxn) {
        int isOutOfOrder = Numbers.decodeLowInt(this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 7L)));
        return (isOutOfOrder & 1) == 0;
    }

    public int getWalId(long seqTxn) {
        return Numbers.decodeHighInt(this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 2L)));
    }

    public long getWalSegment(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 2L));
    }

    @Nullable
    public SymbolMapDiffCursor getWalSymbolDiffCursor(long seqTxn) {
        long offset = this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 8L));
        if (offset < 0L) {
            return null;
        }
        this.symbolMapDiffCursor.of((int)(offset - this.currentSymbolIndexesStartOffset));
        return this.symbolMapDiffCursor;
    }

    public byte getWalTxnType(long seqTxn) {
        return (byte)Numbers.decodeHighInt(this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 7L)));
    }

    public boolean isLastSegmentUsage(long seqTxn) {
        int isOutOfOrder = Numbers.decodeLowInt(this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 7L)));
        return (isOutOfOrder & 2) != 0;
    }

    public void prepareCopySegments(long startSeqTxn, int blockTransactionCount, TableWriterSegmentCopyInfo copyTasks, boolean hasSymbols) {
        copyTasks.initBlock(startSeqTxn, blockTransactionCount, hasSymbols);
        WalTxnDetailsSlice sortedBySegmentTxnSlice = this.sortSliceByWalAndSegment(startSeqTxn, blockTransactionCount);
        int lastSegmentId = -1;
        int lastWalId = -1;
        long segmentLo = -1L;
        int copyTaskCount = 0;
        boolean isLastSegmentUse = false;
        long roHi = 0L;
        long prevRoHi = -1L;
        boolean allInOrder = true;
        for (int i = 0; i < blockTransactionCount; ++i) {
            int relativeSeqTxn = (int)(sortedBySegmentTxnSlice.getSeqTxn(i) - startSeqTxn);
            int segmentId = sortedBySegmentTxnSlice.getSegmentId(i);
            int walId = sortedBySegmentTxnSlice.getWalId(i);
            long roLo = sortedBySegmentTxnSlice.getRoLo(i);
            if (i > 0) {
                if (lastWalId != walId || lastSegmentId != segmentId) {
                    copyTasks.addSegment(lastWalId, lastSegmentId, segmentLo, roHi, isLastSegmentUse);
                    ++copyTaskCount;
                    segmentLo = roLo;
                    lastWalId = walId;
                    lastSegmentId = segmentId;
                    prevRoHi = -1L;
                }
            } else {
                segmentLo = roLo;
                lastWalId = walId;
                lastSegmentId = segmentId;
            }
            long minTimestamp = sortedBySegmentTxnSlice.getMinTimestamp(i);
            long maxTimestamp = sortedBySegmentTxnSlice.getMaxTimestamp(i);
            isLastSegmentUse |= sortedBySegmentTxnSlice.isLastSegmentUse(i);
            roHi = sortedBySegmentTxnSlice.getRoHi(i);
            long committedRowsCount = roHi - roLo;
            copyTasks.addTxn(roLo, relativeSeqTxn, committedRowsCount, copyTaskCount, minTimestamp, maxTimestamp);
            boolean bl = allInOrder = allInOrder && minTimestamp >= copyTasks.getMaxTimestamp() && sortedBySegmentTxnSlice.isTxnDataInOrder(i);
            if (prevRoHi != -1L && prevRoHi != roLo) {
                copyTasks.setSegmentGap(true);
            }
            prevRoHi = roHi;
        }
        int lastIndex = blockTransactionCount - 1;
        int segmentId = sortedBySegmentTxnSlice.getSegmentId(lastIndex);
        int walId = sortedBySegmentTxnSlice.getWalId(lastIndex);
        copyTasks.addSegment(walId, segmentId, segmentLo, roHi, isLastSegmentUse);
        copyTasks.setAllTxnDataInOrder(allInOrder);
    }

    public void readObservableTxnMeta(Path tempPath, TransactionLogCursor transactionLogCursor, int rootLen, long appliedSeqTxn, long maxCommittedTimestamp) {
        int i;
        long rowsToLoad;
        int maxLookaheadTxn;
        long loadFromSeqTxn;
        long lastLoadedSeqTxn = this.getLastSeqTxn();
        if (lastLoadedSeqTxn >= (loadFromSeqTxn = appliedSeqTxn + 1L) && this.startSeqTxn <= loadFromSeqTxn) {
            int shift = (int)(loadFromSeqTxn - this.startSeqTxn);
            long newSymbolsOffset = this.getMinSymbolIndexOffsetFromTxn(loadFromSeqTxn);
            assert (newSymbolsOffset >= this.currentSymbolIndexesStartOffset);
            if (newSymbolsOffset > this.currentSymbolIndexesStartOffset) {
                if (this.symbolStringsMem != null && this.symbolStringsMem.getAppendOffset() > 0L) {
                    long newSymbolStringMemStartOffset = this.findFirstSymbolStringMemOffset(newSymbolsOffset);
                    this.shiftSymbolStringsDataLeft(newSymbolStringMemStartOffset - this.currentSymbolStringMemStartOffset);
                    this.currentSymbolStringMemStartOffset = newSymbolStringMemStartOffset;
                }
                this.symbolIndexes.removeIndexBlock(0L, newSymbolsOffset - this.currentSymbolIndexesStartOffset);
                this.currentSymbolIndexesStartOffset = newSymbolsOffset;
            }
            this.transactionMeta.removeIndexBlock(0, shift * 14);
            this.startSeqTxn = loadFromSeqTxn;
            loadFromSeqTxn = lastLoadedSeqTxn + 1L;
        } else {
            this.transactionMeta.clear();
            this.symbolIndexes.clear();
            if (this.symbolStringsMem != null) {
                this.symbolStringsMem.truncate();
            }
            this.currentSymbolStringMemStartOffset = 0L;
            this.currentSymbolIndexesStartOffset = 0L;
            this.startSeqTxn = loadFromSeqTxn;
            this.totalRowsLoadedToApply = 0L;
        }
        int txnLoadCount = maxLookaheadTxn = this.config.getWalApplyLookAheadTransactionCount();
        int initialSize = this.transactionMeta.size();
        do {
            long rowsLoaded = this.loadTransactionDetails(tempPath, transactionLogCursor, loadFromSeqTxn, rootLen, txnLoadCount);
            this.totalRowsLoadedToApply += rowsLoaded;
            loadFromSeqTxn = this.getLastSeqTxn() + 1L;
            rowsToLoad = this.maxLookaheadRows - this.totalRowsLoadedToApply;
            if (this.totalRowsLoadedToApply <= 0L || rowsToLoad <= 0L) continue;
            long loadedTxn = this.transactionMeta.size() / 14;
            txnLoadCount = (int)Math.max(rowsToLoad * loadedTxn / this.totalRowsLoadedToApply, (long)maxLookaheadTxn);
        } while (rowsToLoad > 0L && this.getLastSeqTxn() < transactionLogCursor.getMaxTxn());
        if (this.transactionMeta.size() == initialSize) {
            return;
        }
        long runningMinTimestamp = 0x7FFFFFFFFFFFFFFEL;
        for (i = this.transactionMeta.size() - 14; i > -1; i -= 14) {
            long commitToTimestamp = runningMinTimestamp;
            long currentMinTimestamp = this.transactionMeta.getQuick(i + 3);
            runningMinTimestamp = Math.min(runningMinTimestamp, currentMinTimestamp);
            if (this.transactionMeta.get(i + 1) != Long.MAX_VALUE) {
                this.transactionMeta.set(i + 1, commitToTimestamp);
                continue;
            }
            if (i < initialSize) continue;
            runningMinTimestamp = Long.MAX_VALUE;
        }
        int n = this.transactionMeta.size();
        for (i = 0; i < n; i += 14) {
            long commitToTimestamp = this.transactionMeta.get(i + 1);
            if (commitToTimestamp >= maxCommittedTimestamp) continue;
            this.transactionMeta.set(i + 1, Long.MIN_VALUE);
        }
    }

    public void setIncrementRowsCommitted(long rowsCommitted) {
        this.totalRowsLoadedToApply -= rowsCommitted;
        assert (this.totalRowsLoadedToApply >= 0L);
    }

    private long findFirstSymbolStringMemOffset(long symbolsOffset) {
        int i = (int)(symbolsOffset - this.currentSymbolIndexesStartOffset);
        int n = (int)this.symbolIndexes.size();
        if (i < n) {
            assert (i + 4 + 6 <= n);
            int symbolColCount = this.symbolIndexes.get(i + 1);
            assert (symbolColCount > 0);
            int lo = this.symbolIndexes.get(i + 8);
            int hi = this.symbolIndexes.get(i + 9);
            return Numbers.encodeLowHighInts(lo, hi);
        }
        return this.currentSymbolStringMemStartOffset + this.symbolStringsMem.getAppendOffset();
    }

    private long getCommitMaxTimestamp(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 4L));
    }

    private long getMinSymbolIndexOffsetFromTxn(long seqTxn) {
        long n = this.getLastSeqTxn() + 1L;
        long minOffset = this.symbolIndexes.size() + this.currentSymbolIndexesStartOffset;
        for (long txn = seqTxn; txn < n; ++txn) {
            long offset = this.getWalSymbolDiffCursorOffset(txn);
            if (offset <= -1L) continue;
            minOffset = Math.min(minOffset, offset);
        }
        return minOffset;
    }

    private MemoryCARW getSymbolMem() {
        if (this.symbolStringsMem == null) {
            this.symbolStringsMem = Vm.getCARWInstance(4096L, Integer.MAX_VALUE, 56);
        }
        return this.symbolStringsMem;
    }

    private long getWalSymbolDiffCursorOffset(long seqTxn) {
        return this.transactionMeta.get((int)((seqTxn - this.startSeqTxn) * 14L + 8L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadTransactionDetails(Path tempPath, TransactionLogCursor transactionLogCursor, long loadFromSeqTxn, int rootLen, int maxLoadTxnCount) {
        transactionLogCursor.setPosition(loadFromSeqTxn - 1L);
        long totalRowsLoaded = 0L;
        try (WalEventReader eventReader = this.walEventReader;){
            WalEventCursor walEventCursor = null;
            this.txnOrder.clear();
            int txnCount = (int)Math.min((long)maxLoadTxnCount, transactionLogCursor.getMaxTxn() - loadFromSeqTxn + 1L);
            if (txnCount > 0) {
                txnCount = WalTxnDetails.loadTxns(transactionLogCursor, txnCount, this.txnOrder);
                int lastWalId = -1;
                int lastSegmentId = -1;
                int lastSegmentTxn = -2;
                int incrementalLoadStartIndex = this.transactionMeta.size();
                this.transactionMeta.setPos(incrementalLoadStartIndex + txnCount * 14);
                for (int i = 0; i < txnCount; ++i) {
                    byte walTxnType;
                    long long1 = this.txnOrder.get(2L * (long)i);
                    long long2 = this.txnOrder.get(2L * (long)i + 1L);
                    long seqTxn = (long)Numbers.decodeHighInt(long2) + loadFromSeqTxn;
                    int walId = Numbers.decodeHighInt(long1) + -2;
                    int segmentId = Numbers.decodeLowInt(long1);
                    int segmentTxn = Numbers.decodeLowInt(long2);
                    int txnMetaOffset = (int)((seqTxn - this.startSeqTxn) * 14L);
                    if (walId > 0) {
                        if (lastWalId == walId && segmentId == lastSegmentId) {
                            assert (segmentTxn > lastSegmentTxn);
                            while (lastSegmentTxn < segmentTxn && walEventCursor.hasNext()) {
                                ++lastSegmentTxn;
                            }
                            if (lastSegmentTxn != segmentTxn) {
                                walEventCursor = WalTxnDetails.openWalEFile(tempPath, eventReader, segmentTxn, seqTxn);
                                lastSegmentTxn = segmentTxn;
                            }
                        } else {
                            tempPath.trimTo(rootLen).concat("wal").put(walId).slash().put(segmentId);
                            walEventCursor = WalTxnDetails.openWalEFile(tempPath, eventReader, segmentTxn, seqTxn);
                            lastWalId = walId;
                            lastSegmentId = segmentId;
                            lastSegmentTxn = segmentTxn;
                        }
                        if (WalTxnType.isDataType(walTxnType = (byte)walEventCursor.getType())) {
                            int flags;
                            WalEventCursor.DataInfo commitInfo = walEventCursor.getDataInfo();
                            this.transactionMeta.set(txnMetaOffset + 0, seqTxn);
                            this.transactionMeta.set(txnMetaOffset + 1, -1L);
                            this.transactionMeta.set(txnMetaOffset + 2, Numbers.encodeLowHighInts(segmentId, walId));
                            this.transactionMeta.set(txnMetaOffset + 3, commitInfo.getMinTimestamp());
                            this.transactionMeta.set(txnMetaOffset + 4, commitInfo.getMaxTimestamp());
                            this.transactionMeta.set(txnMetaOffset + 5, commitInfo.getStartRowID());
                            this.transactionMeta.set(txnMetaOffset + 6, commitInfo.getEndRowID());
                            totalRowsLoaded += commitInfo.getEndRowID() - commitInfo.getStartRowID();
                            int n = flags = commitInfo.isOutOfOrder() ? 1 : 0;
                            if (i + 1 < txnCount) {
                                int nextWalId = Numbers.decodeHighInt(this.txnOrder.get(2L * (long)(i + 1))) + -2;
                                int nextSegmentId = Numbers.decodeLowInt(this.txnOrder.get(2L * (long)(i + 1)));
                                if (nextSegmentId != segmentId || nextWalId != walId) {
                                    flags |= 2;
                                }
                            } else {
                                flags |= 2;
                            }
                            this.transactionMeta.set(txnMetaOffset + 7, Numbers.encodeLowHighInts(flags |= commitInfo.getDedupMode() << 24, walTxnType));
                            this.transactionMeta.set(txnMetaOffset + 8, this.saveSymbols(commitInfo, seqTxn));
                            if (walTxnType == 3) {
                                WalEventCursor.MatViewDataInfo matViewDataInfo = walEventCursor.getMatViewDataInfo();
                                this.transactionMeta.set(txnMetaOffset + 9, matViewDataInfo.getLastRefreshBaseTableTxn());
                                this.transactionMeta.set(txnMetaOffset + 10, matViewDataInfo.getLastRefreshTimestamp());
                                this.transactionMeta.set(txnMetaOffset + 13, matViewDataInfo.getLastPeriodHi());
                            } else {
                                this.transactionMeta.set(txnMetaOffset + 9, -1L);
                                this.transactionMeta.set(txnMetaOffset + 10, -1L);
                                this.transactionMeta.set(txnMetaOffset + 13, -1L);
                            }
                            this.transactionMeta.set(txnMetaOffset + 11, commitInfo.getReplaceRangeTsLow());
                            this.transactionMeta.set(txnMetaOffset + 12, commitInfo.getReplaceRangeTsHi());
                            if (commitInfo.getDedupMode() == 0) continue;
                            this.transactionMeta.set(txnMetaOffset + 1, Long.MAX_VALUE);
                            continue;
                        }
                    } else {
                        walTxnType = -1;
                    }
                    this.transactionMeta.set(txnMetaOffset + 0, seqTxn);
                    this.transactionMeta.set(txnMetaOffset + 1, Long.MAX_VALUE);
                    this.transactionMeta.set(txnMetaOffset + 2, Numbers.encodeLowHighInts(segmentId, walId));
                    this.transactionMeta.set(txnMetaOffset + 3, -1L);
                    this.transactionMeta.set(txnMetaOffset + 4, -1L);
                    this.transactionMeta.set(txnMetaOffset + 5, -1L);
                    this.transactionMeta.set(txnMetaOffset + 6, -1L);
                    this.transactionMeta.set(txnMetaOffset + 7, Numbers.encodeLowHighInts(0, walTxnType));
                    this.transactionMeta.set(txnMetaOffset + 8, -1L);
                    this.transactionMeta.set(txnMetaOffset + 9, -1L);
                    this.transactionMeta.set(txnMetaOffset + 10, -1L);
                    this.transactionMeta.set(txnMetaOffset + 11, -1L);
                    this.transactionMeta.set(txnMetaOffset + 12, -1L);
                    this.transactionMeta.set(txnMetaOffset + 13, -1L);
                }
            }
        }
        finally {
            tempPath.trimTo(rootLen);
            this.txnOrder.resetCapacity();
        }
        return totalRowsLoaded;
    }

    public static int loadTxns(TransactionLogCursor transactionLogCursor, int txnCount, DirectLongList txnList) {
        int txn;
        txnList.setCapacity((long)txnCount * 4L);
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (txn = 0; txn < txnCount && transactionLogCursor.hasNext(); ++txn) {
            long long1 = Numbers.encodeLowHighInts(transactionLogCursor.getSegmentId(), transactionLogCursor.getWalId() - -2);
            max = Math.max(max, long1);
            min = Math.min(min, long1);
            txnList.add(long1);
            txnList.add(Numbers.encodeLowHighInts(transactionLogCursor.getSegmentTxn(), txn));
        }
        Vect.radixSortLongIndexAscChecked(txnList.getAddress(), txn, txnList.getAddress() + (long)txn * 2L * 8L, min, max);
        return txn;
    }

    private long saveSymbols(SymbolMapDiffCursor commitInfo, long seqTxn) {
        SymbolMapDiff symbolMapDiff;
        MemoryCARW symbolMem = this.getSymbolMem();
        int symbolCount = 0;
        int startOffset = (int)this.symbolIndexes.size();
        this.symbolIndexes.add(-1);
        this.symbolIndexes.add(-1);
        this.symbolIndexes.add(Numbers.decodeLowInt(seqTxn));
        this.symbolIndexes.add(Numbers.decodeHighInt(seqTxn));
        int totalSymbolsSaved = 0;
        boolean hasNull = false;
        while ((symbolMapDiff = commitInfo.nextSymbolMapDiff()) != null) {
            SymbolMapDiffEntry entry;
            int cleanSymbolCount = symbolMapDiff.getCleanSymbolCount();
            int entryBegins = (int)this.symbolIndexes.size();
            this.symbolIndexes.add(-1);
            this.symbolIndexes.add(symbolMapDiff.getColumnIndex());
            this.symbolIndexes.add(symbolMapDiff.hasNullValue() ? 1 : 0);
            hasNull = hasNull || symbolMapDiff.hasNullValue();
            this.symbolIndexes.add(cleanSymbolCount);
            int symbolIndex = 0;
            long symbolValueOffset = symbolMem.getAppendOffset() + this.currentSymbolStringMemStartOffset;
            while ((entry = symbolMapDiff.nextEntry()) != null) {
                int key = entry.getKey() - cleanSymbolCount;
                assert (key == symbolIndex);
                ++symbolIndex;
                entry.appendSymbolTo(symbolMem);
            }
            this.symbolIndexes.add(Numbers.decodeLowInt(symbolValueOffset));
            this.symbolIndexes.add(Numbers.decodeHighInt(symbolValueOffset));
            int count = symbolIndex;
            this.symbolIndexes.set(entryBegins, count);
            ++symbolCount;
            totalSymbolsSaved += count;
        }
        if (!(symbolCount != 0 && totalSymbolsSaved != 0 || hasNull)) {
            this.symbolIndexes.setPos(startOffset);
            return -1L - (this.currentSymbolIndexesStartOffset + (long)startOffset);
        }
        this.symbolIndexes.set(startOffset, (int)this.symbolIndexes.size() - startOffset);
        this.symbolIndexes.set(startOffset + 1, symbolCount);
        return this.currentSymbolIndexesStartOffset + (long)startOffset;
    }

    private void shiftSymbolStringsDataLeft(long shiftBytes) {
        long size = this.symbolStringsMem.getAppendOffset();
        assert (size >= shiftBytes);
        if (size > shiftBytes) {
            long address = this.symbolStringsMem.getPageAddress(0);
            Vect.memcpy(address, address + shiftBytes, size - shiftBytes);
            this.symbolStringsMem.jumpTo(size - shiftBytes);
        } else {
            this.symbolStringsMem.truncate();
        }
    }

    private WalTxnDetailsSlice sortSliceByWalAndSegment(long startSeqTxn, int blockTransactionCount) {
        assert (blockTransactionCount > 1);
        return this.txnSlice.of(startSeqTxn, blockTransactionCount);
    }

    private class SymbolMapDiffCursorImpl
    implements SymbolMapDiffCursor {
        private final SymbolMapDiffColumnRecord symbolMapDiff = new SymbolMapDiffColumnRecord();
        private int offsetIndex;
        private long recordIndexHi;
        private int symbolIndex;
        private int symbolsCount;

        private SymbolMapDiffCursorImpl() {
        }

        @Override
        public SymbolMapDiff nextSymbolMapDiff() {
            if (this.symbolIndex++ < this.symbolsCount) {
                assert ((long)this.offsetIndex <= this.recordIndexHi);
                this.symbolMapDiff.switchToColumnRecord(this.offsetIndex);
                this.offsetIndex += 6;
                return this.symbolMapDiff;
            }
            return null;
        }

        public void of(int startOffset) {
            if (startOffset > -1) {
                this.offsetIndex = startOffset;
                int recordLength = WalTxnDetails.this.symbolIndexes.get(startOffset);
                assert (recordLength >= 4);
                this.recordIndexHi = this.offsetIndex + recordLength;
                this.symbolsCount = WalTxnDetails.this.symbolIndexes.get(startOffset + 1);
                assert (this.symbolsCount > -1);
                this.offsetIndex += 4;
                this.symbolIndex = 0;
            } else {
                this.symbolsCount = 0;
            }
        }

        private class SymbolMapDiffColumnRecord
        implements SymbolMapDiff,
        SymbolMapDiffEntry {
            private int cleanSymbolCount;
            private int columnIndex;
            private boolean containsNull;
            private long currentSymbolMemOffset;
            private int savedSymbolRecordCount;
            private int symbolIndex = 0;

            private SymbolMapDiffColumnRecord() {
            }

            @Override
            public void appendSymbolTo(MemoryARW symbolMem) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void drain() {
            }

            @Override
            public int getCleanSymbolCount() {
                return this.cleanSymbolCount;
            }

            @Override
            public int getColumnIndex() {
                return this.columnIndex;
            }

            @Override
            public int getKey() {
                return this.symbolIndex + this.cleanSymbolCount - 1;
            }

            @Override
            public int getRecordCount() {
                return this.savedSymbolRecordCount;
            }

            @Override
            public CharSequence getSymbol() {
                return WalTxnDetails.this.symbolStringsMem.getStrA(this.currentSymbolMemOffset);
            }

            @Override
            public boolean hasNullValue() {
                return this.containsNull;
            }

            @Override
            public SymbolMapDiffEntry nextEntry() {
                if (this.symbolIndex < this.savedSymbolRecordCount) {
                    if (this.symbolIndex > 0) {
                        this.currentSymbolMemOffset += Vm.getStorageLength(WalTxnDetails.this.symbolStringsMem.getInt(this.currentSymbolMemOffset));
                    }
                    ++this.symbolIndex;
                    return this;
                }
                return null;
            }

            public void switchToColumnRecord(int lo) {
                this.savedSymbolRecordCount = WalTxnDetails.this.symbolIndexes.get(lo++);
                this.columnIndex = WalTxnDetails.this.symbolIndexes.get(lo++);
                this.containsNull = WalTxnDetails.this.symbolIndexes.get(lo++) > 0;
                this.cleanSymbolCount = WalTxnDetails.this.symbolIndexes.get(lo++);
                int nextSymbolMemOffsetIndexLo = WalTxnDetails.this.symbolIndexes.get(lo++);
                int nextSymbolMemOffsetIndexHi = WalTxnDetails.this.symbolIndexes.get(lo);
                this.currentSymbolMemOffset = Numbers.encodeLowHighInts(nextSymbolMemOffsetIndexLo, nextSymbolMemOffsetIndexHi) - WalTxnDetails.this.currentSymbolStringMemStartOffset;
                this.symbolIndex = 0;
            }
        }
    }

    public class WalTxnDetailsSlice {
        public long getMaxTimestamp(int txn) {
            return WalTxnDetails.this.getMaxTimestamp(this.getSeqTxn(txn));
        }

        public long getMinTimestamp(int txn) {
            return WalTxnDetails.this.getMinTimestamp(this.getSeqTxn(txn));
        }

        public long getRoHi(int txn) {
            return WalTxnDetails.this.getSegmentRowHi(this.getSeqTxn(txn));
        }

        public long getRoLo(int txn) {
            return WalTxnDetails.this.getSegmentRowLo(this.getSeqTxn(txn));
        }

        public int getSegmentId(int txn) {
            return Numbers.decodeLowInt(WalTxnDetails.this.txnOrder.get(2L * (long)txn));
        }

        public long getSeqTxn(int txn) {
            return WalTxnDetails.this.txnOrder.get(2L * (long)txn + 1L);
        }

        public int getWalId(int txn) {
            return Numbers.decodeHighInt(WalTxnDetails.this.txnOrder.get(2L * (long)txn));
        }

        public boolean isLastSegmentUse(int txn) {
            return WalTxnDetails.this.isLastSegmentUsage(this.getSeqTxn(txn));
        }

        public boolean isTxnDataInOrder(int txn) {
            return WalTxnDetails.this.getTxnInOrder(this.getSeqTxn(txn));
        }

        public WalTxnDetailsSlice of(long lo, int count) {
            WalTxnDetails.this.txnOrder.clear();
            WalTxnDetails.this.txnOrder.setCapacity((long)count * 4L);
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            long n = lo + (long)count;
            for (long i = lo; i < n; ++i) {
                long segWalId = WalTxnDetails.this.transactionMeta.get((int)((i - WalTxnDetails.this.startSeqTxn) * 14L + 2L));
                min = Math.min(min, segWalId);
                max = Math.max(max, segWalId);
                WalTxnDetails.this.txnOrder.add(segWalId);
                WalTxnDetails.this.txnOrder.add(i);
            }
            Vect.radixSortLongIndexAscChecked(WalTxnDetails.this.txnOrder.getAddress(), count, WalTxnDetails.this.txnOrder.getAddress() + (long)count * 2L * 8L, min, max);
            return this;
        }
    }
}

