/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.Unordered2Map;
import io.questdb.cairo.map.Unordered2MapRecord;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.std.DirectLongLongSortedList;

public final class Unordered2MapCursor
implements MapRecordCursor {
    private final long entrySize;
    private final Unordered2Map map;
    private final Unordered2MapRecord recordA;
    private final Unordered2MapRecord recordB;
    private long address;
    private int count;
    private boolean hasZero;
    private long memLimit;
    private long memStart;
    private int remaining;

    Unordered2MapCursor(Unordered2MapRecord record, Unordered2Map map) {
        this.recordA = record;
        this.recordB = record.clone();
        this.map = map;
        this.entrySize = map.entrySize();
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        if (this.remaining > 0) {
            counter.add(this.remaining);
            this.remaining = 0;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public MapRecord getRecord() {
        return this.recordA;
    }

    @Override
    public MapRecord getRecordB() {
        return this.recordB;
    }

    @Override
    public boolean hasNext() {
        if (this.remaining > 0) {
            this.recordA.of(this.address);
            this.skipToNonZeroKey();
            --this.remaining;
            return true;
        }
        return false;
    }

    @Override
    public void longTopK(DirectLongLongSortedList list, Function recordFunction) {
        if (this.hasZero) {
            this.recordA.of(this.memStart);
            long v = recordFunction.getLong(this.recordA);
            list.add(this.memStart, v);
        }
        for (long addr = this.memStart + this.entrySize; addr < this.memLimit; addr += this.entrySize) {
            if (this.map.isZeroKey(addr)) continue;
            this.recordA.of(addr);
            long v = recordFunction.getLong(this.recordA);
            list.add(addr, v);
        }
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((Unordered2MapRecord)record).of(atRowId);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public void toTop() {
        this.address = this.memStart;
        this.remaining = this.count;
        if (!this.hasZero) {
            this.skipToNonZeroKey();
        }
    }

    private void skipToNonZeroKey() {
        do {
            this.address += this.entrySize;
        } while (this.address < this.memLimit && this.map.isZeroKey(this.address));
    }

    Unordered2MapCursor init(long memStart, long memLimit, boolean hasZero, int count) {
        this.memStart = memStart;
        this.memLimit = memLimit;
        this.count = count;
        this.hasZero = hasZero;
        this.toTop();
        this.recordA.setLimit(memLimit);
        this.recordB.setLimit(memLimit);
        return this;
    }
}

