/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoKeywords;
import io.questdb.cairo.MetadataCacheWriter;
import io.questdb.cairo.TableFlagResolver;
import io.questdb.cairo.TableNameRegistry;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.TxWriter;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;

public class TableConverter {
    private static final Log LOG = LogFactory.getLog(TableConverter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjList<TableToken> convertTables(CairoEngine engine, TableSequencerAPI tableSequencerAPI, TableFlagResolver tableFlagResolver, TableNameRegistry tableNameRegistry) {
        CairoConfiguration configuration = engine.getConfiguration();
        ObjList<TableToken> convertedTables = new ObjList<TableToken>();
        if (!configuration.isTableTypeConversionEnabled()) {
            LOG.info().$("table type conversion is disabled").$();
            return null;
        }
        if (configuration.isReadOnlyInstance()) {
            LOG.info().$("read only instance is not allowed to perform table type conversion").$();
            return null;
        }
        Path path = Path.getThreadLocal(configuration.getDbRoot());
        int rootLen = path.size();
        Utf8StringSink dirNameSink = Misc.getThreadLocalUtf8Sink();
        FilesFacade ff = configuration.getFilesFacade();
        long findPtr = ff.findFirst(path.$());
        TxWriter txWriter = null;
        try {
            do {
                if (!ff.isDirOrSoftLinkDirNoDots(path, rootLen, ff.findName(findPtr), ff.findType(findPtr), dirNameSink) || !ff.exists(path.concat("_convert").$())) continue;
                try {
                    boolean walEnabled = TableConverter.readWalEnabled(path.$(), ff);
                    LOG.info().$("converting table [dirName=").$(dirNameSink).$(", walEnabled=").$(walEnabled).I$();
                    path.trimTo(rootLen).concat(dirNameSink);
                    try (MemoryCMARW metaMem = Vm.getCMARWInstance();){
                        TableUtils.openSmallFile(ff, path, rootLen, metaMem, "_meta", 8);
                        String dirName = dirNameSink.toString();
                        TableToken existingToken = tableNameRegistry.getTableTokenByDirName(dirName);
                        if (metaMem.getBool(40L) == walEnabled && existingToken != null && existingToken.isWal() == walEnabled) {
                            LOG.info().$("skipping conversion, table already has the expected type [dirName=").$(dirNameSink).$(", walEnabled=").$(walEnabled).I$();
                        } else {
                            String tableName;
                            try (MemoryCMR mem = Vm.getCMRInstance();){
                                String name = TableUtils.readTableName(path.of(configuration.getDbRoot()).concat(dirNameSink), rootLen, mem, ff);
                                tableName = name != null ? name : dirName;
                            }
                            int tableId = metaMem.getInt(16L);
                            boolean isProtected = tableFlagResolver.isProtected(tableName);
                            boolean isSystem = tableFlagResolver.isSystem(tableName);
                            boolean isPublic = tableFlagResolver.isPublic(tableName);
                            boolean isMatView = TableUtils.isMatViewDefinitionFileExists(configuration, path, dirName);
                            TableToken token = new TableToken(tableName, dirName, tableId, isMatView, walEnabled, isSystem, isProtected, isPublic);
                            if (txWriter == null) {
                                txWriter = new TxWriter(ff, configuration);
                            }
                            txWriter.ofRW(path.trimTo(rootLen).concat(dirNameSink).concat("_txn").$(), 0);
                            txWriter.resetLagValuesUnsafe();
                            if (walEnabled) {
                                try (TableWriterMetadata metadata = new TableWriterMetadata(token);){
                                    metadata.reload(metaMem);
                                    tableSequencerAPI.registerTable(tableId, metadata, token);
                                }
                                metaMem.putLong(32L, 0L);
                                path.trimTo(rootLen).concat(dirNameSink);
                                txWriter.resetStructureVersionUnsafe();
                            } else {
                                if (tableNameRegistry.isWalTableDropped(dirName) || !tableSequencerAPI.prepareToConvertToNonWal(token)) {
                                    LOG.info().$("WAL table will not be converted to non-WAL, table is dropped [dirName=").$(dirNameSink).I$();
                                    continue;
                                }
                                TableConverter.removeWalPersistence(path, rootLen, ff, dirNameSink);
                            }
                            metaMem.putBool(40L, walEnabled);
                            convertedTables.add(token);
                            try (MetadataCacheWriter metadataRW = engine.getMetadataCache().writeLock();){
                                metadataRW.hydrateTable(token);
                            }
                        }
                        path.trimTo(rootLen).concat(dirNameSink).concat("_convert");
                        if (!ff.removeQuiet(path.$())) {
                            LOG.critical().$("could not remove _convert file [path=").$(path).I$();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error().$("table conversion failed [path=").$(path).$(", e=").$(e).I$();
                }
                finally {
                    if (txWriter != null) {
                        txWriter.close();
                    }
                }
            } while (ff.findNext(findPtr) > 0);
        }
        finally {
            ff.findClose(findPtr);
        }
        return convertedTables;
    }

    private static boolean readWalEnabled(LPSZ path, FilesFacade ff) {
        long fd = -1L;
        try {
            fd = ff.openRO(path);
            if (fd < 1L) {
                throw CairoException.critical(ff.errno()).put("could not open file [path=").put(path).put(']');
            }
            byte walType = ff.readNonNegativeByte(fd, 0L);
            switch (walType) {
                case 1: 
                case 2: {
                    boolean bl = true;
                    return bl;
                }
                case 0: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw CairoException.critical(ff.errno()).put("could not read walType from file [path=").put(path).put(']');
        }
        finally {
            ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeWalPersistence(Path path, int rootLen, FilesFacade ff, Utf8Sequence dirName) {
        path.trimTo(rootLen).concat(dirName).concat("txn_seq").$();
        if (!ff.rmdir(path)) {
            LOG.error().$("could not remove sequencer dir [errno=").$(ff.errno()).$(", path=").$(path).I$();
        }
        path.trimTo(rootLen).concat(dirName);
        int plen = path.size();
        long pFind = ff.findFirst(path.$());
        if (pFind > 0L) {
            try {
                do {
                    long name = ff.findName(pFind);
                    int type = ff.findType(pFind);
                    if (!CairoKeywords.isWal(name)) continue;
                    path.trimTo(plen).concat(name);
                    if (type == 8 && CairoKeywords.isLock(name)) {
                        if (ff.removeQuiet(path.$())) continue;
                        LOG.error().$("could not remove wal lock file [errno=").$(ff.errno()).$(", path=").$(path).I$();
                        continue;
                    }
                    if (ff.rmdir(path)) continue;
                    LOG.error().$("could not remove wal dir [errno=").$(ff.errno()).$(", path=").$(path).I$();
                } while (ff.findNext(pFind) > 0);
            }
            finally {
                ff.findClose(pFind);
            }
        }
    }
}

