/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Os;
import org.jetbrains.annotations.NotNull;

public enum ErrorTag {
    NONE(""),
    UNSUPPORTED_FILE_SYSTEM("UNSUPPORTED FILE SYSTEM"),
    DISK_FULL("DISK FULL"),
    TOO_MANY_OPEN_FILES("TOO MANY OPEN FILES"),
    OUT_OF_MMAP_AREAS("OUT OF MMAP AREAS"),
    OUT_OF_MEMORY("OUT OF MEMORY");

    private static final CharSequenceObjHashMap<ErrorTag> resolveMap;
    private final String text;

    private ErrorTag(String text) {
        this.text = text;
    }

    public static ErrorTag resolveTag(@NotNull CharSequence text) {
        ErrorTag errorTag = resolveMap.get(text);
        if (errorTag == null) {
            throw CairoException.nonCritical().put("Invalid WAL error tag [").put(text).put("]");
        }
        return errorTag;
    }

    public static ErrorTag resolveTag(int code) {
        return Os.isWindows() ? ErrorTag.windows(code) : ErrorTag.linux(code);
    }

    public String text() {
        return this.text;
    }

    static ErrorTag linux(int code) {
        switch (code) {
            case 28: {
                return DISK_FULL;
            }
            case 24: {
                return TOO_MANY_OPEN_FILES;
            }
            case 12: {
                return OUT_OF_MMAP_AREAS;
            }
        }
        return NONE;
    }

    static ErrorTag windows(int code) {
        switch (code) {
            case 39: 
            case 112: {
                return DISK_FULL;
            }
            case 4: {
                return TOO_MANY_OPEN_FILES;
            }
            case 8: {
                return OUT_OF_MMAP_AREAS;
            }
        }
        return NONE;
    }

    static {
        resolveMap = new CharSequenceObjHashMap();
        ErrorTag[] values = ErrorTag.values();
        for (int i = 0; i < values.length; ++i) {
            ErrorTag tag = values[i];
            resolveMap.put(tag.text, tag);
        }
    }
}

