/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoKeywords;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.DatabaseCheckpointStatus;
import io.questdb.cairo.GrowOnlyTableNameRegistryStore;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SymbolMapUtil;
import io.questdb.cairo.TableNameRegistryStore;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxWriter;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.mv.MatViewGraph;
import io.questdb.cairo.mv.MatViewState;
import io.questdb.cairo.mv.MatViewStateReader;
import io.questdb.cairo.pool.ex.EntryLockedException;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.wal.WalWriterMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SimpleWaitingLock;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.QuietCloseable;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class DatabaseCheckpointAgent
implements DatabaseCheckpointStatus,
QuietCloseable {
    private static final Log LOG = LogFactory.getLog(DatabaseCheckpointAgent.class);
    private final CairoConfiguration configuration;
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final boolean lightweightCheckpointSupported;
    private final ReentrantLock lock = new ReentrantLock();
    private final MessageBus messageBus;
    private final WalWriterMetadata metadata;
    private final MicrosecondClock microClock;
    private final StringSink nameSink = new StringSink();
    private final Path path = new Path();
    private final LongList scoreboardTxns = new LongList();
    private final ObjList<TxnScoreboard> scoreboards = new ObjList();
    private final AtomicLong startedAtTimestamp = new AtomicLong(Long.MIN_VALUE);
    private final SymbolMapUtil symbolMapUtil = new SymbolMapUtil();
    private final GrowOnlyTableNameRegistryStore tableNameRegistryStore;
    private final Utf8StringSink utf8Sink = new Utf8StringSink();
    private ColumnVersionReader columnVersionReader = null;
    private Path partitionCleanPath;
    private DateFormat partitionDirFmt;
    private int pathTableLen;
    private TableReaderMetadata tableMetadata = null;
    private TxWriter txWriter = null;
    private final FindVisitor removePartitionDirsNotAttached = this::removePartitionDirsNotAttached;
    private SimpleWaitingLock walPurgeJobRunLock = null;

    DatabaseCheckpointAgent(CairoEngine engine) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.messageBus = engine.getMessageBus();
        this.microClock = this.configuration.getMicrosecondClock();
        this.ff = this.configuration.getFilesFacade();
        this.metadata = new WalWriterMetadata(this.ff);
        this.tableNameRegistryStore = new GrowOnlyTableNameRegistryStore(this.ff);
        this.lightweightCheckpointSupported = this.configuration.getScoreboardFormat() > 1;
    }

    public void clear() {
        this.lock.lock();
        try {
            this.metadata.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            Misc.free(this.path);
            Misc.free(this.metadata);
            Misc.free(this.tableNameRegistryStore);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean partitionsLocked() {
        return !this.lightweightCheckpointSupported && this.isInProgress();
    }

    public void setWalPurgeJobRunLock(@Nullable SimpleWaitingLock walPurgeJobRunLock) {
        this.walPurgeJobRunLock = walPurgeJobRunLock;
    }

    @Override
    public long startedAtTimestamp() {
        return this.startedAtTimestamp.get();
    }

    private static void copyOrError(Path srcPath, Path dstPath, FilesFacade ff, AtomicInteger counter, String fileName) {
        srcPath.concat(fileName);
        dstPath.concat(fileName);
        if (ff.copy(srcPath.$(), dstPath.$()) < 0) {
            throw CairoException.critical(ff.errno()).put("Checkpoint recovery failed. Aborting QuestDB startup. Cause: Error could not copy ").put(fileName).put(" file [src=").put(srcPath).put(", dst=").put(dstPath).put(']');
        }
        counter.incrementAndGet();
        LOG.info().$("recovered ").$(fileName).$(" file [src=").$(srcPath).$(", dst=").$(dstPath).I$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkpointCreate(SqlExecutionContext executionContext, CharSequence checkpointRoot) throws SqlException {
        try {
            long startedAt = this.microClock.getTicks();
            if (!this.startedAtTimestamp.compareAndSet(Long.MIN_VALUE, startedAt)) {
                throw SqlException.position(0).put("Waiting for CHECKPOINT RELEASE to be called");
            }
            try {
                this.path.of(checkpointRoot).concat(this.configuration.getDbDirectory());
                int checkpointDbLen = this.path.size();
                if (this.ff.exists(this.path.slash$())) {
                    this.path.trimTo(checkpointDbLen).$();
                    if (!this.ff.rmdir(this.path)) {
                        throw CairoException.critical(this.ff.errno()).put("Could not remove checkpoint dir [dir=").put(this.path).put(']');
                    }
                }
                this.path.trimTo(checkpointDbLen).slash$();
                if (this.ff.mkdirs(this.path, this.configuration.getMkDirMode()) != 0) {
                    throw CairoException.critical(this.ff.errno()).put("Could not create [dir=").put(this.path).put(']');
                }
                if (this.walPurgeJobRunLock != null) {
                    long timeout = this.configuration.getCircuitBreakerConfiguration().getQueryTimeout();
                    while (!this.walPurgeJobRunLock.tryLock(timeout, TimeUnit.MICROSECONDS)) {
                        executionContext.getCircuitBreaker().statefulThrowExceptionIfTrippedNoThrottle();
                    }
                }
                try {
                    this.path.trimTo(checkpointDbLen).$();
                    this.tableNameRegistryStore.of(this.path, 0);
                    this.path.trimTo(checkpointDbLen).$();
                    ObjHashSet<TableToken> tables = new ObjHashSet<TableToken>();
                    ObjList<TableToken> ordered = new ObjList<TableToken>();
                    this.engine.getTableTokens(tables, false);
                    this.engine.getMatViewGraph().orderByDependentViews(tables, ordered);
                    try (MemoryCMARW mem = Vm.getCMARWInstance();
                         BlockFileReader matViewFileReader = new BlockFileReader(this.configuration);
                         BlockFileWriter matViewFileWriter = new BlockFileWriter(this.ff, this.configuration.getCommitMode());){
                        MatViewStateReader matViewStateReader = null;
                        int n = ordered.size();
                        block36: for (int t = 0; t < n; ++t) {
                            TableReader reader;
                            TableToken tableToken = ordered.get(t);
                            if (this.engine.isTableDropped(tableToken)) {
                                LOG.info().$("skipping, table is dropped [table=").$(tableToken).I$();
                                continue;
                            }
                            boolean isWalTable = this.engine.isWalTable(tableToken);
                            this.path.of(checkpointRoot).concat(this.configuration.getDbDirectory());
                            LOG.info().$("creating table checkpoint [table=").$(tableToken).I$();
                            this.path.trimTo(checkpointDbLen).concat(tableToken);
                            int rootLen = this.path.size();
                            if (isWalTable) {
                                this.path.concat("txn_seq");
                            }
                            if (this.ff.mkdirs(this.path.slash(), this.configuration.getMkDirMode()) != 0) {
                                throw CairoException.critical(this.ff.errno()).put("could not create [dir=").put(this.path).put(']');
                            }
                            while (true) {
                                if (this.engine.isTableDropped(tableToken)) {
                                    LOG.info().$("skipping, table is concurrently dropped [table=").$(tableToken).I$();
                                    continue block36;
                                }
                                if (tableToken.isMatView()) {
                                    MatViewGraph matViewGraph = this.engine.getMatViewGraph();
                                    MatViewDefinition matViewDefinition = matViewGraph.getViewDefinition(tableToken);
                                    if (matViewDefinition != null) {
                                        matViewFileWriter.of(this.path.trimTo(rootLen).concat("_mv").$());
                                        MatViewDefinition.append(matViewDefinition, matViewFileWriter);
                                        LOG.info().$("materialized view definition included in the checkpoint [view=").$(tableToken).I$();
                                        boolean isMatViewStateExists = TableUtils.isMatViewStateFileExists(this.configuration, this.path, tableToken.getDirName());
                                        if (isMatViewStateExists) {
                                            matViewFileReader.of(this.path.of(this.configuration.getDbRoot()).concat(tableToken.getDirName()).concat("_mv.s").$());
                                            if (matViewStateReader == null) {
                                                matViewStateReader = new MatViewStateReader();
                                            }
                                            matViewStateReader.of(matViewFileReader, tableToken);
                                            this.path.of(checkpointRoot).concat(this.configuration.getDbDirectory()).concat(tableToken);
                                            matViewFileWriter.of(this.path.concat("_mv.s").$());
                                            MatViewState.append(matViewStateReader, matViewFileWriter);
                                            LOG.info().$("materialized view state included in the checkpoint [view=").$(tableToken).I$();
                                        } else {
                                            LOG.info().$("materialized view state not found [view=").$(tableToken).I$();
                                        }
                                    } else {
                                        LOG.info().$("skipping, materialized view is concurrently dropped [view=").$(tableToken).I$();
                                        continue block36;
                                    }
                                }
                                reader = null;
                                try {
                                    reader = this.engine.getReaderWithRepair(tableToken);
                                }
                                catch (EntryLockedException e) {
                                    LOG.info().$("waiting for locked table [table=").$(tableToken).I$();
                                    executionContext.getCircuitBreaker().statefulThrowExceptionIfTrippedNoThrottle();
                                    Misc.free(reader);
                                    continue;
                                }
                                catch (CairoException e) {
                                    if (!this.engine.isTableDropped(tableToken)) throw e;
                                    LOG.info().$("skipping, table is concurrently dropped [table=").$(tableToken).I$();
                                    continue block36;
                                }
                                catch (TableReferenceOutOfDateException e) {
                                    LOG.info().$("retrying, table reference is out of date [table=").$(tableToken).I$();
                                    executionContext.getCircuitBreaker().statefulThrowExceptionIfTrippedNoThrottle();
                                    continue;
                                }
                                break;
                            }
                            {
                                this.path.of(checkpointRoot).concat(this.configuration.getDbDirectory()).concat(tableToken);
                                this.path.trimTo(rootLen).concat("_meta");
                                mem.smallFile(this.ff, this.path.$(), 0);
                                reader.getMetadata().dumpTo(mem);
                                mem.close(false);
                                this.path.trimTo(rootLen).concat("_txn");
                                mem.smallFile(this.ff, this.path.$(), 0);
                                reader.getTxFile().dumpTo(mem);
                                mem.close(false);
                                this.path.trimTo(rootLen).concat("_cv");
                                mem.smallFile(this.ff, this.path.$(), 0);
                                reader.getColumnVersionReader().dumpTo(mem);
                                mem.close(false);
                                if (this.lightweightCheckpointSupported) {
                                    long txn = reader.getTxn();
                                    TxnScoreboard scoreboard = this.engine.getTxnScoreboard(tableToken);
                                    if (!scoreboard.incrementTxn(-1, txn)) {
                                        throw CairoException.nonCritical().put("cannot lock table for checkpoint [table=").put(tableToken).put(']');
                                    }
                                    this.scoreboardTxns.add(txn);
                                    this.scoreboardTxns.add(reader.getMetadata().getPartitionBy());
                                    this.scoreboards.add(scoreboard);
                                }
                                if (isWalTable) {
                                    this.tableNameRegistryStore.logAddTable(tableToken);
                                    this.metadata.clear();
                                    long lastTxn = this.engine.getTableSequencerAPI().getTableMetadata(tableToken, this.metadata);
                                    this.path.trimTo(rootLen).concat("txn_seq");
                                    this.metadata.switchTo(this.path, this.path.size(), true);
                                    this.metadata.close(true, (byte)1);
                                    mem.smallFile(this.ff, this.path.concat("_txn").$(), 0);
                                    mem.putLong(lastTxn);
                                    mem.close(true, (byte)1);
                                }
                                LOG.info().$("table included in the checkpoint [table=").$(tableToken).I$();
                            }
                            Misc.free(reader);
                        }
                        this.path.of(checkpointRoot).concat(this.configuration.getDbDirectory()).concat("_checkpoint_meta.d");
                        mem.smallFile(this.ff, this.path.$(), 0);
                        mem.putStr(this.configuration.getSnapshotInstanceId());
                        mem.close();
                        if (this.ff.sync() != 0) {
                            throw CairoException.critical(this.ff.errno()).put("Could not sync");
                        }
                        executionContext.getCircuitBreaker().statefulThrowExceptionIfTrippedNoThrottle();
                        LOG.info().$("checkpoint created").$();
                        return;
                    }
                }
                catch (Throwable e) {
                    if (this.walPurgeJobRunLock != null) {
                        this.walPurgeJobRunLock.unlock();
                    }
                    LOG.error().$("checkpoint error [e=").$(e).I$();
                    throw e;
                }
                finally {
                    this.tableNameRegistryStore.close();
                }
            }
            catch (Throwable e) {
                this.startedAtTimestamp.set(Long.MIN_VALUE);
                this.releaseScoreboardTxns(false);
                throw e;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void rebuildSymbolFiles(Path tablePath, AtomicInteger recoveredSymbolFiles, int pathTableLen) {
        tablePath.trimTo(pathTableLen);
        for (int i = 0; i < this.tableMetadata.getColumnCount(); ++i) {
            int columnType = this.tableMetadata.getColumnType(i);
            if (!ColumnType.isSymbol(columnType)) continue;
            int cleanSymbolCount = this.txWriter.getSymbolValueCount(this.tableMetadata.getDenseSymbolIndex(i));
            CharSequence columnName = this.tableMetadata.getColumnName(i);
            LOG.info().$("rebuilding symbol files [table=").$(tablePath).$(", column=").$safe(columnName).$(", count=").$(cleanSymbolCount).I$();
            int writerIndex = this.tableMetadata.getWriterIndex(i);
            this.symbolMapUtil.rebuildSymbolFiles(this.configuration, tablePath, columnName, this.columnVersionReader.getDefaultColumnNameTxn(writerIndex), cleanSymbolCount, -1);
            recoveredSymbolFiles.incrementAndGet();
        }
    }

    private void rebuildTableFiles(Path tablePath, AtomicInteger recoveredSymbolFiles) {
        this.pathTableLen = tablePath.size();
        try {
            if (this.tableMetadata == null) {
                this.tableMetadata = new TableReaderMetadata(this.configuration);
            }
            this.tableMetadata.load(tablePath.concat("_meta").$());
            if (this.txWriter == null) {
                this.txWriter = new TxWriter(this.configuration.getFilesFacade(), this.configuration);
            }
            this.txWriter.ofRW(tablePath.trimTo(this.pathTableLen).concat("_txn").$(), this.tableMetadata.getPartitionBy());
            this.txWriter.unsafeLoadAll();
            if (this.columnVersionReader == null) {
                this.columnVersionReader = new ColumnVersionReader();
            }
            tablePath.trimTo(this.pathTableLen).concat("_cv");
            this.columnVersionReader.ofRO(this.configuration.getFilesFacade(), tablePath.$());
            this.columnVersionReader.readUnsafe();
            this.rebuildSymbolFiles(tablePath, recoveredSymbolFiles, this.pathTableLen);
            if (this.tableMetadata.isWalEnabled() && this.txWriter.getLagRowCount() > 0) {
                LOG.info().$("resetting WAL lag [table=").$(tablePath).$(", walLagRowCount=").$(this.txWriter.getLagRowCount()).I$();
                this.txWriter.resetLagAppliedRows();
            }
            if (PartitionBy.isPartitioned(this.tableMetadata.getPartitionBy())) {
                LOG.debug().$("purging non attached partitions [path=").$(tablePath.$()).I$();
                this.partitionCleanPath = tablePath;
                this.partitionDirFmt = PartitionBy.getPartitionDirFormatMethod(this.tableMetadata.getPartitionBy());
                this.ff.iterateDir(tablePath.$(), this.removePartitionDirsNotAttached);
            }
        }
        finally {
            tablePath.trimTo(this.pathTableLen);
        }
    }

    private void releaseScoreboardTxns(boolean schedulePartitionPurge) {
        int n = this.scoreboards.size();
        for (int i = 0; i < n; ++i) {
            long txn = this.scoreboardTxns.get(2 * i);
            TxnScoreboard scoreboard = this.scoreboards.getQuick(i);
            scoreboard.releaseTxn(-1, txn);
            if (!schedulePartitionPurge || !scoreboard.isOutdated(txn)) continue;
            int partitionBy = (int)this.scoreboardTxns.getQuick(2 * i + 1);
            TableUtils.schedulePurgeO3Partitions(this.messageBus, scoreboard.getTableToken(), partitionBy);
        }
        this.scoreboardTxns.clear();
        Misc.freeObjList(this.scoreboards);
        this.scoreboards.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePartitionDirsNotAttached(long pUtf8NameZ, int type) {
        int checkedType = this.ff.typeDirOrSoftLinkDirNoDots(this.partitionCleanPath, this.pathTableLen, pUtf8NameZ, type, this.utf8Sink);
        if (!(checkedType == 0 || CairoKeywords.isDetachedDirMarker(pUtf8NameZ) || CairoKeywords.isWal(pUtf8NameZ) || CairoKeywords.isTxnSeq(pUtf8NameZ) || CairoKeywords.isSeq(pUtf8NameZ) || Utf8s.endsWithAscii((Utf8Sequence)this.utf8Sink, this.configuration.getAttachPartitionSuffix()))) {
            try {
                long txn;
                int txnSep = Utf8s.indexOfAscii(this.utf8Sink, '.');
                if (txnSep < 0) {
                    txnSep = this.utf8Sink.size();
                    txn = -1L;
                } else {
                    txn = Numbers.parseLong(this.utf8Sink, txnSep + 1, this.utf8Sink.size());
                }
                long dirTimestamp = this.partitionDirFmt.parse(this.utf8Sink.asAsciiCharSequence(), 0, txnSep, DateFormatUtils.EN_LOCALE);
                if (this.txWriter.getPartitionNameTxnByPartitionTimestamp(dirTimestamp) == txn) {
                    return;
                }
                if (!this.ff.unlinkOrRemove(this.partitionCleanPath, LOG)) {
                    LOG.info().$("failed to purge unused partition version [path=").$(this.partitionCleanPath).$(", errno=").$(this.ff.errno()).I$();
                } else {
                    LOG.info().$("purged unused partition version [path=").$(this.partitionCleanPath).I$();
                }
                this.partitionCleanPath.trimTo(this.pathTableLen).$();
            }
            catch (NumericException ignore) {
                this.partitionCleanPath.trimTo(this.pathTableLen);
                this.partitionCleanPath.concat(pUtf8NameZ).$();
                LOG.error().$("invalid partition directory inside table folder: ").$(this.partitionCleanPath).$();
            }
            finally {
                this.partitionCleanPath.trimTo(this.pathTableLen);
            }
        }
    }

    void checkpointCreate(SqlExecutionContext executionContext, boolean isLegacy) throws SqlException {
        CharSequence checkpointRoot;
        if (Os.isWindows()) {
            if (isLegacy) {
                throw SqlException.position(0).put("Snapshot is not supported on Windows");
            }
            throw SqlException.position(0).put("Checkpoint is not supported on Windows");
        }
        if (!this.lock.tryLock()) {
            if (isLegacy) {
                throw SqlException.position(0).put("Another snapshot command is in progress");
            }
            throw SqlException.position(0).put("Another checkpoint command is in progress");
        }
        CharSequence charSequence = checkpointRoot = isLegacy ? this.configuration.getLegacyCheckpointRoot() : this.configuration.getCheckpointRoot();
        if (isLegacy) {
            this.path.of(this.configuration.getCheckpointRoot());
            if (this.ff.exists(this.path.$())) {
                LOG.info().$("removing checkpoint directory to create legacy snapshot [path=").$(this.path).I$();
                this.ff.rmdir(this.path);
            }
        }
        this.checkpointCreate(executionContext, checkpointRoot);
    }

    void checkpointRelease() throws SqlException {
        if (!this.lock.tryLock()) {
            throw SqlException.position(0).put("Another checkpoint command is in progress");
        }
        try {
            this.releaseScoreboardTxns(true);
            this.path.of(this.configuration.getCheckpointRoot()).concat(this.configuration.getDbDirectory()).$();
            this.ff.rmdir(this.path);
            this.path.of(this.configuration.getLegacyCheckpointRoot()).concat(this.configuration.getDbDirectory()).$();
            this.ff.rmdir(this.path);
            if (this.walPurgeJobRunLock != null) {
                try {
                    this.walPurgeJobRunLock.unlock();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            this.startedAtTimestamp.set(Long.MIN_VALUE);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void recover() {
        if (!this.configuration.isCheckpointRecoveryEnabled()) {
            return;
        }
        FilesFacade ff = this.configuration.getFilesFacade();
        String installRoot = this.configuration.getInstallRoot();
        String dbRoot = this.configuration.getDbRoot();
        CharSequence checkpointRoot = this.configuration.getCheckpointRoot();
        CharSequence legacyCheckpointRoot = this.configuration.getLegacyCheckpointRoot();
        try (Path srcPath = new Path();
             Path dstPath = new Path();
             MemoryCMARW memFile = Vm.getCMARWInstance();){
            int version;
            srcPath.of(checkpointRoot);
            if (!ff.exists(srcPath.$())) {
                srcPath.of(legacyCheckpointRoot);
                if (!ff.exists(srcPath.$())) {
                    srcPath.of(checkpointRoot);
                }
            }
            srcPath.concat(this.configuration.getDbDirectory());
            int checkpointRootLen = srcPath.size();
            dstPath.of(installRoot).concat("_restore");
            boolean triggerExists = ff.exists(dstPath.$());
            if (!ff.exists(srcPath.slash$())) {
                if (!triggerExists) return;
                throw CairoException.nonCritical().put("checkpoint trigger file found, but the checkpoint directory does not exist [dir=").put(srcPath).put(", trigger=").put(dstPath).put(']');
            }
            srcPath.trimTo(checkpointRootLen).concat("_snapshot");
            if (!ff.exists(srcPath.$())) {
                srcPath.trimTo(checkpointRootLen).concat("_checkpoint_meta.d");
            }
            if (!ff.exists(srcPath.$())) {
                if (!triggerExists) return;
                throw CairoException.nonCritical().put("checkpoint trigger file found, but the checkpoint metadata file does not exist [file=").put(srcPath).put(", trigger=").put(dstPath).put(']');
            }
            memFile.smallFile(ff, srcPath.$(), 0);
            CharSequence currentInstanceId = this.configuration.getSnapshotInstanceId();
            CharSequence snapshotInstanceId = memFile.getStrA(0L);
            if (Chars.empty(snapshotInstanceId)) {
                srcPath.trimTo(checkpointRootLen).concat("_snapshot.txt");
                String snapshotInstanceIdRaw = TableUtils.readText(ff, srcPath.$());
                if (snapshotInstanceIdRaw != null) {
                    snapshotInstanceId = snapshotInstanceIdRaw.trim();
                }
            }
            if (!triggerExists && (Chars.empty(currentInstanceId) || Chars.empty(snapshotInstanceId) || Chars.equals(currentInstanceId, snapshotInstanceId))) {
                LOG.info().$("skipping recovery from checkpoint [currentId=").$(currentInstanceId).$(", previousId=").$(snapshotInstanceId).I$();
                return;
            }
            if (triggerExists) {
                LOG.info().$("starting checkpoint recovery [trigger=file]").$();
            } else {
                LOG.info().$("starting checkpoint recovery [trigger=snapshot id").$(", currentId=").$(currentInstanceId).$(", previousId=").$(snapshotInstanceId).I$();
            }
            dstPath.of(dbRoot);
            int rootLen = dstPath.size();
            srcPath.trimTo(checkpointRootLen).$();
            int snapshotDbLen = srcPath.size();
            do {
                dstPath.trimTo(rootLen).$();
                version = TableNameRegistryStore.findLastTablesFileVersion(ff, dstPath, this.nameSink);
                dstPath.trimTo(rootLen).concat("tables.d").putAscii('.').put(version);
                LOG.info().$("backup removing table name registry file [dst=").$(dstPath).I$();
                if (ff.removeQuiet(dstPath.$())) continue;
                throw CairoException.critical(ff.errno()).put("Checkpoint recovery failed. Aborting QuestDB startup. Cause: Error could not remove registry file [file=").put(dstPath).put(']');
            } while (version != 0);
            srcPath.trimTo(snapshotDbLen).concat("tables.d").putAscii(".0");
            dstPath.trimTo(rootLen).concat("tables.d").putAscii(".0");
            if (ff.copy(srcPath.$(), dstPath.$()) < 0) {
                throw CairoException.critical(ff.errno()).put("Checkpoint recovery failed. Aborting QuestDB startup. Cause: Could not copy registry file [src=").put(srcPath).put(", dst=").put(dstPath).put(']');
            }
            AtomicInteger recoveredMetaFiles = new AtomicInteger();
            AtomicInteger recoveredTxnFiles = new AtomicInteger();
            AtomicInteger recoveredCVFiles = new AtomicInteger();
            AtomicInteger recoveredWalFiles = new AtomicInteger();
            AtomicInteger symbolFilesCount = new AtomicInteger();
            srcPath.trimTo(checkpointRootLen);
            ff.iterateDir(srcPath.$(), (pUtf8NameZ, type) -> {
                if (ff.isDirOrSoftLinkDirNoDots(srcPath, snapshotDbLen, pUtf8NameZ, type)) {
                    dstPath.trimTo(rootLen).concat(pUtf8NameZ);
                    int srcPathLen = srcPath.size();
                    int dstPathLen = dstPath.size();
                    DatabaseCheckpointAgent.copyOrError(srcPath, dstPath, ff, recoveredMetaFiles, "_meta");
                    DatabaseCheckpointAgent.copyOrError(srcPath.trimTo(srcPathLen), dstPath.trimTo(dstPathLen), ff, recoveredTxnFiles, "_txn");
                    DatabaseCheckpointAgent.copyOrError(srcPath.trimTo(srcPathLen), dstPath.trimTo(dstPathLen), ff, recoveredCVFiles, "_cv");
                    TableUtils.resetTodoLog(ff, dstPath, dstPathLen, memFile);
                    this.rebuildTableFiles(dstPath.trimTo(dstPathLen), symbolFilesCount);
                    srcPath.trimTo(srcPathLen).concat("txn_seq");
                    srcPathLen = srcPath.size();
                    srcPath.concat("_meta");
                    dstPath.trimTo(dstPathLen).concat("txn_seq");
                    dstPathLen = dstPath.size();
                    dstPath.concat("_meta");
                    if (ff.exists(srcPath.$())) {
                        if (ff.copy(srcPath.$(), dstPath.$()) < 0) {
                            throw CairoException.critical(ff.errno()).put("Checkpoint recovery failed. Aborting QuestDB startup. Cause: Error could not copy meta file [src=").put(srcPath).put(", dst=").put(dstPath).put(']');
                        }
                        srcPath.trimTo(srcPathLen);
                        TableUtils.openSmallFile(ff, srcPath, srcPathLen, memFile, "_txn", 13);
                        long newMaxTxn = memFile.getLong(0L);
                        memFile.smallFile(ff, dstPath.$(), 8);
                        dstPath.trimTo(dstPathLen);
                        TableUtils.openSmallFile(ff, dstPath, dstPathLen, memFile, "_txnlog.meta.i", 13);
                        if (newMaxTxn >= 0L) {
                            dstPath.trimTo(dstPathLen);
                            TableUtils.openSmallFile(ff, dstPath, dstPathLen, memFile, "_txnlog", 13);
                            long oldMaxTxn = memFile.getLong(4L);
                            if (newMaxTxn < oldMaxTxn) {
                                memFile.putLong(4L, newMaxTxn);
                                LOG.info().$("updated ").$("_txnlog").$(" file [path=").$(dstPath).$(", oldMaxTxn=").$(oldMaxTxn).$(", newMaxTxn=").$(newMaxTxn).I$();
                            }
                        }
                        recoveredWalFiles.incrementAndGet();
                        LOG.info().$("recovered ").$("_meta").$(" file [src=").$(srcPath).$(", dst=").$(dstPath).I$();
                    }
                }
            });
            LOG.info().$("checkpoint recovered [metaFilesCount=").$(recoveredMetaFiles.get()).$(", txnFilesCount=").$(recoveredTxnFiles.get()).$(", cvFilesCount=").$(recoveredCVFiles.get()).$(", walFilesCount=").$(recoveredWalFiles.get()).$(", symbolFilesCount=").$(symbolFilesCount.get()).I$();
            srcPath.trimTo(checkpointRootLen).$();
            memFile.close();
            if (!ff.rmdir(srcPath)) {
                throw CairoException.critical(ff.errno()).put("could not remove checkpoint dir [dir=").put(srcPath).put(", errno=").put(ff.errno()).put(']');
            }
            dstPath.of(installRoot).concat("_restore");
            if (!triggerExists) return;
            if (ff.removeQuiet(dstPath.$())) return;
            throw CairoException.critical(ff.errno()).put("could not remove restore trigger file. file permission issues? [file=").put(dstPath).put(']');
        }
        finally {
            this.tableMetadata = Misc.free(this.tableMetadata);
            this.columnVersionReader = Misc.free(this.columnVersionReader);
            this.txWriter = Misc.free(this.txWriter);
        }
    }
}

