/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.StringTypeDriver;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.vm.MemoryCMARWImpl;
import io.questdb.cairo.vm.MemoryCMORImpl;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.griffin.ColumnConversionOffsetSink;
import io.questdb.griffin.ConvertersNative;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SymbolMapWriterLite;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.Uuid;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import org.jetbrains.annotations.Nullable;

public class ColumnTypeConverter {
    private static final Log LOG = LogFactory.getLog(ColumnTypeConverter.class);
    private static final Fixed2VarConverter converterFromBoolean2String = ColumnTypeConverter::stringFromBoolean;
    private static final Fixed2VarConverter converterFromByte2String = ColumnTypeConverter::stringFromByte;
    private static final Fixed2VarConverter converterFromChar2String = ColumnTypeConverter::stringFromChar;
    private static final Fixed2VarConverter converterFromDate2String = ColumnTypeConverter::stringFromDate;
    private static final Fixed2VarConverter converterFromDouble2String = ColumnTypeConverter::stringFromDouble;
    private static final Fixed2VarConverter converterFromFloat2String = ColumnTypeConverter::stringFromFloat;
    private static final Fixed2VarConverter converterFromIPv42String = ColumnTypeConverter::stringFromIPv4;
    private static final Fixed2VarConverter converterFromInt2String = ColumnTypeConverter::stringFromInt;
    private static final Fixed2VarConverter converterFromLong2String = ColumnTypeConverter::stringFromLong;
    private static final Fixed2VarConverter converterFromShort2String = ColumnTypeConverter::stringFromShort;
    private static final Fixed2VarConverter converterFromTimestamp2String = ColumnTypeConverter::stringFromTimestamp;
    private static final Fixed2VarConverter converterFromUuid2String = ColumnTypeConverter::stringFromUuid;
    private static final Var2FixedConverter<CharSequence> converterStr2Boolean = ColumnTypeConverter::str2Boolean;
    private static final Var2FixedConverter<CharSequence> converterStr2Byte = ColumnTypeConverter::str2Byte;
    private static final Var2FixedConverter<CharSequence> converterStr2Char = ColumnTypeConverter::str2Char;
    private static final Var2FixedConverter<CharSequence> converterStr2Date = ColumnTypeConverter::str2Date;
    private static final Var2FixedConverter<CharSequence> converterStr2Double = ColumnTypeConverter::str2Double;
    private static final Var2FixedConverter<CharSequence> converterStr2Float = ColumnTypeConverter::str2Float;
    private static final Var2FixedConverter<CharSequence> converterStr2IPv4 = ColumnTypeConverter::str2IpV4;
    private static final Var2FixedConverter<CharSequence> converterStr2Int = ColumnTypeConverter::str2Int;
    private static final Var2FixedConverter<CharSequence> converterStr2Long = ColumnTypeConverter::str2Long;
    private static final Var2FixedConverter<CharSequence> converterStr2Short = ColumnTypeConverter::str2Short;
    private static final Var2FixedConverter<CharSequence> converterStr2Timestamp = ColumnTypeConverter::str2Timestamp;
    private static final Var2FixedConverter<CharSequence> converterStr2Uuid = ColumnTypeConverter::str2Uuid;
    private static final ThreadLocal<MemoryCMARW> dstFixMemTL = new ThreadLocal<MemoryCMARW>(MemoryCMARWImpl::new);
    private static final ThreadLocal<MemoryCMARW> dstVarMemTL = new ThreadLocal<MemoryCMARW>(MemoryCMARWImpl::new);
    private static final int memoryTag = 12;
    private static final ThreadLocal<StringSink> sinkUtf16TL = new ThreadLocal<StringSink>(StringSink::new);
    private static final ThreadLocal<Utf8StringSink> sinkUtf8TL = new ThreadLocal<Utf8StringSink>(Utf8StringSink::new);
    private static final ThreadLocal<MemoryCMORImpl> srcFixMemTL = new ThreadLocal<MemoryCMORImpl>(MemoryCMORImpl::new);
    private static final ThreadLocal<MemoryCMORImpl> srcVarMemTL = new ThreadLocal<MemoryCMORImpl>(MemoryCMORImpl::new);

    public static boolean convertColumn(long skipRows, long rowCount, int srcColumnType, long srcFixFd, long srcVarFd, @Nullable SymbolTable symbolTable, int dstColumnType, long dstFixFd, long dstVarFd, @Nullable SymbolMapWriterLite symbolMapWriter, FilesFacade ff, long appendPageSize, ColumnConversionOffsetSink columnSizesSink) {
        assert (skipRows > -1L && rowCount > -1L);
        if (ColumnType.isSymbol(srcColumnType)) {
            assert (symbolTable != null);
            ColumnTypeConverter.convertFromSymbol(skipRows, rowCount, srcFixFd, symbolTable, dstColumnType, dstFixFd, dstVarFd, ff, appendPageSize, columnSizesSink);
            return true;
        }
        if (ColumnType.isFixedSize(srcColumnType) && ColumnType.isFixedSize(dstColumnType)) {
            return ColumnTypeConverter.convertFixedToFixed(rowCount, skipRows, srcFixFd, dstFixFd, srcColumnType, dstColumnType, ff, columnSizesSink);
        }
        if (ColumnType.isVarSize(srcColumnType)) {
            switch (srcColumnType) {
                case 11: {
                    return ColumnTypeConverter.convertFromString(skipRows, rowCount, srcFixFd, srcVarFd, dstFixFd, dstVarFd, dstColumnType, ff, appendPageSize, symbolMapWriter, columnSizesSink);
                }
                case 26: {
                    return ColumnTypeConverter.convertFromVarchar(skipRows, rowCount, srcFixFd, srcVarFd, dstFixFd, dstVarFd, dstColumnType, ff, appendPageSize, symbolMapWriter, columnSizesSink);
                }
            }
            throw ColumnTypeConverter.unsupportedConversion(srcColumnType, dstColumnType);
        }
        if (ColumnType.isFixedSize(srcColumnType) && ColumnType.isVarSize(dstColumnType)) {
            switch (dstColumnType) {
                case 11: {
                    return ColumnTypeConverter.convertFixedToString(skipRows, rowCount, srcFixFd, srcColumnType, dstFixFd, dstVarFd, ff, appendPageSize, columnSizesSink);
                }
                case 26: {
                    return ColumnTypeConverter.convertFixedToVarchar(skipRows, rowCount, srcFixFd, srcColumnType, dstFixFd, dstVarFd, ff, appendPageSize, columnSizesSink);
                }
            }
            throw ColumnTypeConverter.unsupportedConversion(srcColumnType, dstColumnType);
        }
        if (ColumnType.isFixedSize(srcColumnType) && dstColumnType == 12) {
            assert (symbolMapWriter != null);
            return ColumnTypeConverter.convertFixedToSymbol(skipRows, rowCount, srcFixFd, srcColumnType, dstFixFd, symbolMapWriter, ff, appendPageSize, columnSizesSink);
        }
        throw ColumnTypeConverter.unsupportedConversion(srcColumnType, dstColumnType);
    }

    public static Var2FixedConverter<CharSequence> getConverterFromVarToFixed(short srcType, int dstColumnType) {
        switch (dstColumnType) {
            case 25: {
                return converterStr2IPv4;
            }
            case 19: {
                return converterStr2Uuid;
            }
            case 5: {
                return converterStr2Int;
            }
            case 3: {
                return converterStr2Short;
            }
            case 2: {
                return converterStr2Byte;
            }
            case 4: {
                return converterStr2Char;
            }
            case 6: {
                return converterStr2Long;
            }
            case 10: {
                return converterStr2Double;
            }
            case 9: {
                return converterStr2Float;
            }
            case 7: {
                return converterStr2Date;
            }
            case 8: {
                return converterStr2Timestamp;
            }
            case 1: {
                return converterStr2Boolean;
            }
        }
        throw ColumnTypeConverter.unsupportedConversion(srcType, dstColumnType);
    }

    private static boolean convertFixedToFixed(long rowCount, long skipRows, long srcFixFd, long dstFixFd, int srcColumnType, int dstColumnType, FilesFacade ff, ColumnConversionOffsetSink columnSizesSink) {
        long srcColumnTypeSize = ColumnType.sizeOf(srcColumnType);
        long dstColumnTypeSize = ColumnType.sizeOf(dstColumnType);
        long srcMapAddress = 0L;
        long dstMapAddress = 0L;
        long skipBytes = skipRows * srcColumnTypeSize;
        long mapBytes = rowCount * srcColumnTypeSize;
        long dstMapBytes = rowCount * dstColumnTypeSize;
        try {
            srcMapAddress = TableUtils.mapAppendColumnBuffer(ff, srcFixFd, skipBytes, mapBytes, false, 12);
            columnSizesSink.setSrcOffsets(skipBytes, -1L);
            if (!ff.truncate(dstFixFd, dstMapBytes)) {
                throw CairoException.critical(ff.errno()).put("Cannot allocate fd: ").put(dstFixFd).put(", size: ").put(dstMapBytes);
            }
            dstMapAddress = TableUtils.mapAppendColumnBuffer(ff, dstFixFd, 0L, dstMapBytes, true, 12);
            columnSizesSink.setDestSizes(dstMapBytes, -1L);
            long succeeded = ConvertersNative.fixedToFixed(srcMapAddress, srcColumnType, dstMapAddress, dstColumnType, rowCount);
            switch ((int)succeeded) {
                case 0: {
                    boolean bl = true;
                    return bl;
                }
                case 1: {
                    throw ColumnTypeConverter.unsupportedConversion(srcColumnType, dstColumnType);
                }
            }
            throw CairoException.critical(0).put("Unknown return code from native call: ").put(succeeded);
        }
        finally {
            if (srcMapAddress != 0L) {
                TableUtils.mapAppendColumnBufferRelease(ff, srcMapAddress, skipBytes, mapBytes, 12);
            }
            if (dstMapAddress != 0L) {
                TableUtils.mapAppendColumnBufferRelease(ff, dstMapAddress, 0L, dstMapBytes, 12);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean convertFixedToString(long skipRows, long rowCount, long srcFixFd, int srcColumnType, long dstFixFd, long dstVarFd, FilesFacade ff, long appendPageSize, ColumnConversionOffsetSink columnSizesSink) {
        long srcColumnTypeSize = ColumnType.sizeOf(srcColumnType);
        assert (srcColumnTypeSize > 0L);
        long skipBytes = skipRows * srcColumnTypeSize;
        long mapBytes = rowCount * srcColumnTypeSize;
        MemoryCMARW dstVarMem = dstVarMemTL.get();
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        long srcMapAddress = TableUtils.mapAppendColumnBuffer(ff, srcFixFd, skipBytes, mapBytes, false, 12);
        try {
            dstVarMem.of(ff, dstVarFd, true, null, appendPageSize, appendPageSize, 12);
            dstVarMem.jumpTo(0L);
            dstFixMem.of(ff, dstFixFd, true, null, appendPageSize, StringTypeDriver.INSTANCE.getAuxVectorSize(rowCount), 12);
            dstFixMem.jumpTo(0L);
            dstFixMem.putLong(0L);
            StringSink sink = sinkUtf16TL.get();
            columnSizesSink.setSrcOffsets(skipBytes, -1L);
            Fixed2VarConverter converter = ColumnTypeConverter.getFixedToVarConverter(srcColumnType, 11);
            ColumnTypeConverter.convertFixedToString0(rowCount, srcMapAddress, dstFixMem, dstVarMem, sink, srcColumnType, converter);
            columnSizesSink.setDestSizes(dstVarMem.getAppendOffset(), dstFixMem.getAppendOffset());
        }
        finally {
            TableUtils.mapAppendColumnBufferRelease(ff, srcMapAddress, skipBytes, mapBytes, 12);
            dstFixMem.detachFdClose();
            dstVarMem.detachFdClose();
        }
        return true;
    }

    private static void convertFixedToString0(long rowCount, long srcMapAddress, MemoryCMARW dstFixMem, MemoryCMARW dstVarMem, StringSink sink, int srcColumnType, Fixed2VarConverter converterInt2String) {
        int srcColumnTypeSize = ColumnType.sizeOf(srcColumnType);
        long hi = srcMapAddress + (long)srcColumnTypeSize * rowCount;
        sink.clear();
        for (long addr = srcMapAddress; addr < hi; addr += (long)srcColumnTypeSize) {
            if (converterInt2String.convert(addr, sink)) {
                StringTypeDriver.appendValue(dstFixMem, dstVarMem, sink);
                sink.clear();
                continue;
            }
            StringTypeDriver.INSTANCE.appendNull(dstFixMem, dstVarMem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean convertFixedToSymbol(long skipRows, long rowCount, long srcFixFd, int srcColumnType, long dstFixFd, SymbolMapWriterLite symbolMapWriter, FilesFacade ff, long appendPageSize, ColumnConversionOffsetSink columnSizesSink) {
        long srcColumnTypeSize = ColumnType.sizeOf(srcColumnType);
        assert (srcColumnTypeSize > 0L);
        long skipBytes = skipRows * srcColumnTypeSize;
        long mapBytes = rowCount * srcColumnTypeSize;
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        long srcMapAddress = TableUtils.mapAppendColumnBuffer(ff, srcFixFd, skipBytes, mapBytes, false, 12);
        try {
            dstFixMem.of(ff, dstFixFd, true, null, appendPageSize, StringTypeDriver.INSTANCE.getAuxVectorSize(rowCount), 12);
            dstFixMem.jumpTo(0L);
            StringSink sink = sinkUtf16TL.get();
            columnSizesSink.setSrcOffsets(skipBytes, -1L);
            Fixed2VarConverter converter = ColumnTypeConverter.getFixedToVarConverter(srcColumnType, 12);
            ColumnTypeConverter.convertFixedToSymbol0(rowCount, srcMapAddress, dstFixMem, symbolMapWriter, sink, srcColumnType, converter);
            columnSizesSink.setDestSizes(dstFixMem.getAppendOffset(), -1L);
        }
        finally {
            TableUtils.mapAppendColumnBufferRelease(ff, srcMapAddress, skipBytes, mapBytes, 12);
            dstFixMem.detachFdClose();
        }
        return true;
    }

    private static void convertFixedToSymbol0(long rowCount, long srcMapAddress, MemoryCMARW dstFixMem, SymbolMapWriterLite symbolMapWriter, StringSink sink, int srcColumnType, Fixed2VarConverter converterInt2String) {
        int srcColumnTypeSize = ColumnType.sizeOf(srcColumnType);
        long hi = srcMapAddress + (long)srcColumnTypeSize * rowCount;
        sink.clear();
        for (long addr = srcMapAddress; addr < hi; addr += (long)srcColumnTypeSize) {
            int value;
            if (converterInt2String.convert(addr, sink)) {
                value = symbolMapWriter.resolveSymbol(sink);
                dstFixMem.putInt(value);
                sink.clear();
                continue;
            }
            value = symbolMapWriter.resolveSymbol(null);
            dstFixMem.putInt(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean convertFixedToVarchar(long skipRows, long rowCount, long srcFixFd, int srcColumnType, long dstFixFd, long dstVarFd, FilesFacade ff, long appendPageSize, ColumnConversionOffsetSink columnSizesSink) {
        long srcColumnTypeSize = ColumnType.sizeOf(srcColumnType);
        assert (srcColumnTypeSize > 0L);
        long skipBytes = skipRows * srcColumnTypeSize;
        long mapBytes = rowCount * srcColumnTypeSize;
        MemoryCMARW dstVarMem = dstVarMemTL.get();
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        long srcMapAddress = TableUtils.mapAppendColumnBuffer(ff, srcFixFd, skipBytes, mapBytes, false, 12);
        try {
            dstVarMem.of(ff, dstVarFd, true, null, appendPageSize, appendPageSize, 12);
            dstVarMem.jumpTo(0L);
            dstFixMem.of(ff, dstFixFd, true, null, appendPageSize, StringTypeDriver.INSTANCE.getAuxVectorSize(rowCount), 12);
            dstFixMem.jumpTo(0L);
            Utf8StringSink sink = sinkUtf8TL.get();
            columnSizesSink.setSrcOffsets(skipBytes, -1L);
            Fixed2VarConverter converter = ColumnTypeConverter.getFixedToVarConverter(srcColumnType, 26);
            ColumnTypeConverter.convertFixedToVarchar0(rowCount, srcMapAddress, dstFixMem, dstVarMem, sink, srcColumnType, converter);
            columnSizesSink.setDestSizes(dstVarMem.getAppendOffset(), dstFixMem.getAppendOffset());
        }
        finally {
            TableUtils.mapAppendColumnBufferRelease(ff, srcMapAddress, skipBytes, mapBytes, 12);
            dstFixMem.detachFdClose();
            dstVarMem.detachFdClose();
        }
        return true;
    }

    private static void convertFixedToVarchar0(long rowCount, long srcMapAddress, MemoryCMARW dstFixMem, MemoryCMARW dstVarMem, Utf8StringSink sink, int srcColumnType, Fixed2VarConverter converterInt2String) {
        int srcColumnTypeSize = ColumnType.sizeOf(srcColumnType);
        long hi = srcMapAddress + (long)srcColumnTypeSize * rowCount;
        sink.clear();
        for (long addr = srcMapAddress; addr < hi; addr += (long)srcColumnTypeSize) {
            if (converterInt2String.convert(addr, sink)) {
                VarcharTypeDriver.appendValue(dstFixMem, dstVarMem, sink);
                sink.clear();
                continue;
            }
            VarcharTypeDriver.INSTANCE.appendNull(dstFixMem, dstVarMem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean convertFromString(long skipRows, long rowCount, long srcFixFd, long srcVarFd, long dstFixFd, long dstVarFd, int dstColumnType, FilesFacade ff, long appendPageSize, SymbolMapWriterLite symbolMapWriter, ColumnConversionOffsetSink columnSizesSink) {
        long dataSize;
        long skipDataSize;
        StringTypeDriver typeDriver = StringTypeDriver.INSTANCE;
        try {
            skipDataSize = skipRows > 0L ? typeDriver.getDataVectorSizeAtFromFd(ff, srcFixFd, skipRows - 1L) : 0L;
            dataSize = typeDriver.getDataVectorSizeAtFromFd(ff, srcFixFd, skipRows + rowCount - 1L);
            if (dataSize < typeDriver.getDataVectorMinEntrySize()) {
                throw CairoException.nonCritical().put("String column data vector size is less than minimum entry size [size=").put(dataSize).put(", srcFixFd=").put(srcFixFd).put(']');
            }
        }
        catch (CairoException ex) {
            LOG.error().$("cannot read STRING column data vector size, column data is corrupt will fall back reading file sizes [srcFixFd=").$(srcFixFd).$(", msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            return false;
        }
        columnSizesSink.setSrcOffsets(skipDataSize, typeDriver.getAuxVectorSize(skipRows));
        MemoryCMORImpl srcVarMem = srcVarMemTL.get();
        try {
            srcVarMem.ofOffset(ff, srcVarFd, true, null, skipDataSize, dataSize, 12, 0);
            switch (dstColumnType) {
                case 26: {
                    ColumnTypeConverter.convertStringToVarchar(skipDataSize, rowCount, dstFixFd, dstVarFd, ff, appendPageSize, srcVarMem, columnSizesSink);
                    boolean bl = true;
                    return bl;
                }
                case 12: {
                    ColumnTypeConverter.convertStringToSymbol(skipDataSize, rowCount, dstFixFd, ff, symbolMapWriter, srcVarMem, columnSizesSink);
                    boolean bl = true;
                    return bl;
                }
            }
            Var2FixedConverter<CharSequence> converter = ColumnTypeConverter.getConverterFromVarToFixed((short)11, dstColumnType);
            ColumnTypeConverter.convertStringToFixed(skipDataSize, rowCount, dstFixFd, ff, srcVarMem, columnSizesSink, dstColumnType, converter);
        }
        finally {
            srcVarMem.detachFdClose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertFromSymbol(long skipRows, long rowCount, long srcFixFd, SymbolTable symbolTable, int dstColumnType, long dstFixFd, long dstVarFd, FilesFacade ff, long appendPageSize, ColumnConversionOffsetSink columnSizesSink) {
        columnSizesSink.setSrcOffsets(skipRows * 4L, -1L);
        long symbolMapAddress = TableUtils.mapAppendColumnBuffer(ff, srcFixFd, skipRows * 4L, rowCount * 4L, false, 12);
        try {
            switch (ColumnType.tagOf(dstColumnType)) {
                case 11: {
                    ColumnTypeConverter.convertSymbolToString(rowCount, symbolMapAddress, dstFixFd, dstVarFd, ff, appendPageSize, symbolTable, columnSizesSink);
                    return;
                }
                case 26: {
                    ColumnTypeConverter.convertSymbolToVarchar(rowCount, symbolMapAddress, dstFixFd, dstVarFd, ff, appendPageSize, symbolTable, columnSizesSink);
                    return;
                }
            }
            Var2FixedConverter<CharSequence> converter = ColumnTypeConverter.getConverterFromVarToFixed((short)12, dstColumnType);
            ColumnTypeConverter.convertSymbolToFixed(rowCount, symbolMapAddress, dstFixFd, ff, appendPageSize, symbolTable, columnSizesSink, dstColumnType, converter);
        }
        finally {
            TableUtils.mapAppendColumnBufferRelease(ff, symbolMapAddress, skipRows * 4L, rowCount * 4L, 12);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean convertFromVarchar(long skipRows, long rowCount, long srcFixFd, long srcVarFd, long dstFixFd, long dstVarFd, int dstColumnType, FilesFacade ff, long appendPageSize, SymbolMapWriterLite symbolMapWriter, ColumnConversionOffsetSink columnSizesSink) {
        long dataHi;
        long skipDataSize;
        VarcharTypeDriver driverInstance = VarcharTypeDriver.INSTANCE;
        try {
            skipDataSize = skipRows > 0L ? driverInstance.getDataVectorSizeAtFromFd(ff, srcFixFd, skipRows - 1L) : 0L;
            dataHi = driverInstance.getDataVectorSizeAtFromFd(ff, srcFixFd, skipRows + rowCount - 1L);
        }
        catch (CairoException ex) {
            LOG.error().$("cannot read VARCHAR column data vector size, column data is corrupt will fall back reading file sizes [srcFixFd=").$(srcFixFd).I$();
            return false;
        }
        MemoryCMORImpl srcVarMem = null;
        MemoryCMORImpl srcFixMem = srcFixMemTL.get();
        long skipAuxOffset = driverInstance.getAuxVectorSize(skipRows);
        columnSizesSink.setSrcOffsets(skipDataSize, skipAuxOffset);
        try {
            if (dataHi > skipDataSize) {
                srcVarMem = srcVarMemTL.get();
                srcVarMem.ofOffset(ff, srcVarFd, true, null, skipDataSize, dataHi, 12, 0);
            }
            srcFixMem.ofOffset(ff, srcFixFd, true, null, skipAuxOffset, skipAuxOffset + driverInstance.getAuxVectorSize(rowCount), 12, 0);
            switch (ColumnType.tagOf(dstColumnType)) {
                case 11: {
                    ColumnTypeConverter.convertFromVarcharToString(skipRows, skipRows + rowCount, dstFixFd, dstVarFd, ff, appendPageSize, srcVarMem, srcFixMem, columnSizesSink);
                    boolean bl = true;
                    return bl;
                }
                case 12: {
                    ColumnTypeConverter.convertFromVarcharToSymbol(skipRows, skipRows + rowCount, dstFixFd, ff, symbolMapWriter, srcVarMem, srcFixMem, columnSizesSink);
                    boolean bl = true;
                    return bl;
                }
            }
            Var2FixedConverter<CharSequence> converter = ColumnTypeConverter.getConverterFromVarToFixed((short)26, dstColumnType);
            ColumnTypeConverter.convertFromVarcharToFixed(skipRows, skipRows + rowCount, dstFixFd, ff, srcVarMem, srcFixMem, columnSizesSink, dstColumnType, converter);
        }
        finally {
            if (srcVarMem != null) {
                srcVarMem.detachFdClose();
            }
            srcFixMem.detachFdClose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertFromVarcharToFixed(long rowLo, long rowHi, long dstFixFd, FilesFacade ff, @Nullable MemoryCMORImpl srcVarMem, MemoryCMORImpl srcFixMem, ColumnConversionOffsetSink columnSizesSink, int dstColumnType, Var2FixedConverter<CharSequence> converter) {
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        int dstTypeSize = ColumnType.sizeOf(dstColumnType);
        try {
            dstFixMem.of(ff, dstFixFd, true, null, Files.PAGE_SIZE, (rowHi - rowLo) * (long)dstTypeSize, 12);
            dstFixMem.jumpTo(0L);
            for (long i = rowLo; i < rowHi; ++i) {
                Utf8Sequence utf8 = VarcharTypeDriver.getSplitValue(srcFixMem, srcVarMem, i, 1);
                converter.convert(utf8 != null ? utf8.asAsciiCharSequence() : null, dstFixMem);
            }
            assert (dstFixMem.getAppendOffset() == (rowHi - rowLo) * (long)dstTypeSize);
            columnSizesSink.setDestSizes(dstFixMem.getAppendOffset(), -1L);
        }
        finally {
            dstFixMem.detachFdClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertFromVarcharToString(long rowLo, long rowHi, long dstFixFd, long dstVarFd, FilesFacade ff, long appendPageSize, @Nullable MemoryCMORImpl srcVarMem, MemoryCMORImpl srcFixMem, ColumnConversionOffsetSink columnSizesSink) {
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        MemoryCMARW dstVarMem = dstVarMemTL.get();
        StringSink sink = sinkUtf16TL.get();
        try {
            dstVarMem.of(ff, dstVarFd, true, null, appendPageSize, appendPageSize, 12);
            dstVarMem.jumpTo(0L);
            dstFixMem.of(ff, dstFixFd, true, null, appendPageSize, StringTypeDriver.INSTANCE.getAuxVectorSize(rowHi - rowLo), 12);
            dstFixMem.jumpTo(0L);
            dstFixMem.putLong(0L);
            for (long i = rowLo; i < rowHi; ++i) {
                Utf8Sequence utf8 = VarcharTypeDriver.getSplitValue(srcFixMem, srcVarMem, i, 1);
                if (utf8 != null) {
                    sink.clear();
                    sink.put(utf8);
                    StringTypeDriver.appendValue(dstFixMem, dstVarMem, sink);
                    continue;
                }
                StringTypeDriver.INSTANCE.appendNull(dstFixMem, dstVarMem);
            }
            columnSizesSink.setDestSizes(dstVarMem.getAppendOffset(), dstFixMem.getAppendOffset());
        }
        finally {
            dstVarMem.detachFdClose();
            dstFixMem.detachFdClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertFromVarcharToSymbol(long rowLo, long rowHi, long dstFixFd, FilesFacade ff, SymbolMapWriterLite symbolMapWriterLite, @Nullable MemoryCMORImpl srcVarMem, MemoryCMORImpl srcFixMem, ColumnConversionOffsetSink columnSizesSink) {
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        StringSink sink = sinkUtf16TL.get();
        try {
            dstFixMem.of(ff, dstFixFd, true, null, Files.PAGE_SIZE, (rowHi - rowLo) * 4L, 12);
            dstFixMem.jumpTo(0L);
            for (long i = rowLo; i < rowHi; ++i) {
                int symbol;
                Utf8Sequence utf8 = VarcharTypeDriver.getSplitValue(srcFixMem, srcVarMem, i, 1);
                if (utf8 != null) {
                    sink.clear();
                    sink.put(utf8);
                    symbol = symbolMapWriterLite.resolveSymbol(sink);
                    dstFixMem.putInt(symbol);
                    continue;
                }
                symbol = symbolMapWriterLite.resolveSymbol(null);
                dstFixMem.putInt(symbol);
            }
            columnSizesSink.setDestSizes(dstFixMem.getAppendOffset(), -1L);
        }
        finally {
            dstFixMem.detachFdClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertStringToFixed(long skipOffset, long rowCount, long dstFixFd, FilesFacade ff, MemoryCMORImpl srcVarMem, ColumnConversionOffsetSink columnSizesSink, int dstColumnType, Var2FixedConverter<CharSequence> converter) {
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        int dstTypeSize = ColumnType.sizeOf(dstColumnType);
        assert (dstTypeSize > 0);
        try {
            dstFixMem.of(ff, dstFixFd, true, null, Files.PAGE_SIZE, rowCount * (long)dstTypeSize, 12);
            dstFixMem.jumpTo(0L);
            long offset = skipOffset;
            for (long i = 0L; i < rowCount; ++i) {
                CharSequence str = srcVarMem.getStrA(offset);
                offset += (long)Vm.getStorageLength(str);
                converter.convert(str, dstFixMem);
            }
            assert (dstFixMem.getAppendOffset() == rowCount * (long)dstTypeSize);
            columnSizesSink.setDestSizes(dstFixMem.getAppendOffset(), -1L);
        }
        finally {
            dstFixMem.detachFdClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertStringToSymbol(long skipOffset, long rowCount, long dstFixFd, FilesFacade ff, SymbolMapWriterLite symbolMapWriter, MemoryCMORImpl srcVarMem, ColumnConversionOffsetSink columnSizesSink) {
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        try {
            dstFixMem.of(ff, dstFixFd, true, null, Files.PAGE_SIZE, rowCount * 4L, 12);
            dstFixMem.jumpTo(0L);
            long offset = skipOffset;
            for (long i = 0L; i < rowCount; ++i) {
                CharSequence str = srcVarMem.getStrA(offset);
                offset += (long)Vm.getStorageLength(str);
                int symbolId = symbolMapWriter.resolveSymbol(str);
                dstFixMem.putInt(symbolId);
            }
            columnSizesSink.setDestSizes(dstFixMem.getAppendOffset(), -1L);
        }
        finally {
            dstFixMem.detachFdClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertStringToVarchar(long skipOffset, long rowCount, long dstFixFd, long dstVarFd, FilesFacade ff, long appendPageSize, MemoryCMORImpl srcVarMem, ColumnConversionOffsetSink columnSizesSink) {
        MemoryCMARW dstVarMem = dstVarMemTL.get();
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        Utf8StringSink sink = sinkUtf8TL.get();
        try {
            dstVarMem.of(ff, dstVarFd, true, null, appendPageSize, appendPageSize, 12);
            dstVarMem.jumpTo(0L);
            dstFixMem.of(ff, dstFixFd, true, null, appendPageSize, rowCount * 16L, 12);
            dstFixMem.jumpTo(0L);
            long offset = skipOffset;
            for (long i = 0L; i < rowCount; ++i) {
                CharSequence str = srcVarMem.getStrA(offset);
                offset += (long)Vm.getStorageLength(str);
                if (str != null) {
                    sink.clear();
                    sink.put(str);
                    VarcharTypeDriver.appendValue(dstFixMem, dstVarMem, sink);
                    continue;
                }
                VarcharTypeDriver.appendValue(dstFixMem, dstVarMem, null);
            }
            columnSizesSink.setDestSizes(dstVarMem.getAppendOffset(), dstFixMem.getAppendOffset());
        }
        finally {
            sink.clear();
            sink.resetCapacity();
            dstVarMem.detachFdClose();
            dstFixMem.detachFdClose();
            srcVarMem.detachFdClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertSymbolToFixed(long rowCount, long symbolMapAddress, long dstFixFd, FilesFacade ff, long appendPageSize, SymbolTable symbolTable, ColumnConversionOffsetSink columnSizesSink, int dstColumnType, Var2FixedConverter<CharSequence> converter) {
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        int dstSize = ColumnType.sizeOf(dstColumnType);
        assert (dstSize > 0);
        try {
            dstFixMem.of(ff, dstFixFd, true, null, appendPageSize, rowCount * (long)dstSize, 12);
            dstFixMem.jumpTo(0L);
            long hi = symbolMapAddress + rowCount * 4L;
            for (long lo = symbolMapAddress; lo < hi; lo += 4L) {
                int symbol = Unsafe.getUnsafe().getInt(lo);
                CharSequence str = symbolTable.valueOf(symbol);
                converter.convert(str, dstFixMem);
            }
            assert (dstFixMem.getAppendOffset() == rowCount * (long)dstSize);
            columnSizesSink.setDestSizes(dstFixMem.getAppendOffset(), -1L);
        }
        finally {
            dstFixMem.detachFdClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertSymbolToString(long rowCount, long symbolMapAddress, long dstFixFd, long dstVarFd, FilesFacade ff, long appendPageSize, SymbolTable symbolTable, ColumnConversionOffsetSink columnSizesSink) {
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        MemoryCMARW dstVarMem = dstVarMemTL.get();
        StringTypeDriver typeDriver = StringTypeDriver.INSTANCE;
        long dstFixSize = typeDriver.getAuxVectorSize(rowCount);
        try {
            dstFixMem.of(ff, dstFixFd, true, null, appendPageSize, dstFixSize, 12);
            dstFixMem.jumpTo(0L);
            dstFixMem.putLong(0L);
            dstVarMem.of(ff, dstVarFd, true, null, appendPageSize, appendPageSize, 12);
            dstVarMem.jumpTo(0L);
            long hi = symbolMapAddress + rowCount * 4L;
            for (long lo = symbolMapAddress; lo < hi; lo += 4L) {
                int symbol = Unsafe.getUnsafe().getInt(lo);
                CharSequence str = symbolTable.valueOf(symbol);
                if (str != null) {
                    StringTypeDriver.appendValue(dstFixMem, dstVarMem, str);
                    continue;
                }
                typeDriver.appendNull(dstFixMem, dstVarMem);
            }
            columnSizesSink.setDestSizes(dstVarMem.getAppendOffset(), dstFixMem.getAppendOffset());
        }
        finally {
            dstFixMem.detachFdClose();
            dstVarMem.detachFdClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertSymbolToVarchar(long rowCount, long symbolMapAddress, long dstFixFd, long dstVarFd, FilesFacade ff, long appendPageSize, SymbolTable symbolTable, ColumnConversionOffsetSink columnSizesSink) {
        MemoryCMARW dstFixMem = dstFixMemTL.get();
        MemoryCMARW dstVarMem = dstVarMemTL.get();
        Utf8StringSink sink = sinkUtf8TL.get();
        try {
            VarcharTypeDriver typeDriver = VarcharTypeDriver.INSTANCE;
            dstFixMem.of(ff, dstFixFd, true, null, appendPageSize, typeDriver.getAuxVectorSize(rowCount), 12);
            dstFixMem.jumpTo(0L);
            dstVarMem.of(ff, dstVarFd, true, null, appendPageSize, appendPageSize, 12);
            dstVarMem.jumpTo(0L);
            long hi = symbolMapAddress + rowCount * 4L;
            for (long lo = symbolMapAddress; lo < hi; lo += 4L) {
                int symbol = Unsafe.getUnsafe().getInt(lo);
                CharSequence str = symbolTable.valueOf(symbol);
                if (str != null) {
                    sink.clear();
                    sink.put(str);
                    VarcharTypeDriver.appendValue(dstFixMem, dstVarMem, sink);
                    continue;
                }
                typeDriver.appendNull(dstFixMem, dstVarMem);
            }
            columnSizesSink.setDestSizes(dstVarMem.getAppendOffset(), dstFixMem.getAppendOffset());
        }
        finally {
            sink.clear();
            sink.resetCapacity();
            dstFixMem.detachFdClose();
            dstVarMem.detachFdClose();
        }
    }

    private static Fixed2VarConverter getFixedToVarConverter(int srcColumnType, int dstColumnType) {
        switch (srcColumnType) {
            case 5: {
                return converterFromInt2String;
            }
            case 19: {
                return converterFromUuid2String;
            }
            case 25: {
                return converterFromIPv42String;
            }
            case 3: {
                return converterFromShort2String;
            }
            case 2: {
                return converterFromByte2String;
            }
            case 4: {
                return converterFromChar2String;
            }
            case 6: {
                return converterFromLong2String;
            }
            case 10: {
                return converterFromDouble2String;
            }
            case 9: {
                return converterFromFloat2String;
            }
            case 7: {
                return converterFromDate2String;
            }
            case 8: {
                return converterFromTimestamp2String;
            }
            case 1: {
                return converterFromBoolean2String;
            }
        }
        throw ColumnTypeConverter.unsupportedConversion(srcColumnType, dstColumnType);
    }

    private static void str2Boolean(CharSequence str, MemoryCMARW memoryCMARW) {
        memoryCMARW.putBool(str != null && SqlKeywords.isTrueKeyword(str));
    }

    private static void str2Byte(CharSequence str, MemoryCMARW memoryCMARW) {
        byte num = (byte)Numbers.parseIntQuiet(str);
        memoryCMARW.putByte(num);
    }

    private static void str2Char(CharSequence str, MemoryCMARW memoryCMARW) {
        memoryCMARW.putChar(str == null || str.length() == 0 ? (char)'\u0000' : str.charAt(0));
    }

    private static void str2Date(CharSequence str, MemoryCMARW memoryCMARW) {
        if (str != null) {
            try {
                long timestamp = IntervalUtils.parseFloorPartialTimestamp(str);
                memoryCMARW.putLong(timestamp / 1000L);
                return;
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        memoryCMARW.putLong(Long.MIN_VALUE);
    }

    private static void str2Double(CharSequence str, MemoryCMARW memoryCMARW) {
        try {
            if (str != null) {
                memoryCMARW.putDouble(Numbers.parseDouble(str));
                return;
            }
        }
        catch (NumericException numericException) {
            // empty catch block
        }
        memoryCMARW.putDouble(Double.NaN);
    }

    private static void str2Float(CharSequence str, MemoryCMARW memoryCMARW) {
        try {
            if (str != null) {
                memoryCMARW.putFloat(Numbers.parseFloat(str));
                return;
            }
        }
        catch (NumericException numericException) {
            // empty catch block
        }
        memoryCMARW.putFloat(Float.NaN);
    }

    private static void str2Int(CharSequence str, MemoryCMARW memoryCMARW) {
        if (str != null) {
            try {
                int num = Numbers.parseInt(str);
                memoryCMARW.putInt(num);
                return;
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        memoryCMARW.putInt(Integer.MIN_VALUE);
    }

    private static void str2IpV4(CharSequence str, MemoryCMARW dstFixMem) {
        int ipv4 = Numbers.parseIPv4Quiet(str);
        dstFixMem.putInt(ipv4);
    }

    private static void str2Long(CharSequence str, MemoryCMARW memoryCMARW) {
        if (str != null) {
            try {
                long num = Numbers.parseLong(str);
                memoryCMARW.putLong(num);
                return;
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        memoryCMARW.putLong(Long.MIN_VALUE);
    }

    private static void str2Short(CharSequence value, MemoryCMARW memoryCMARW) {
        try {
            if (value != null) {
                memoryCMARW.putShort((short)Numbers.parseInt(value));
                return;
            }
        }
        catch (NumericException numericException) {
            // empty catch block
        }
        memoryCMARW.putShort((short)0);
    }

    private static void str2Timestamp(CharSequence str, MemoryCMARW memoryCMARW) {
        if (str != null) {
            try {
                long timestamp = IntervalUtils.parseFloorPartialTimestamp(str);
                memoryCMARW.putLong(timestamp);
                return;
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        memoryCMARW.putLong(Long.MIN_VALUE);
    }

    private static void str2Uuid(CharSequence str, MemoryCMARW dstFixMem) {
        if (str != null) {
            try {
                Uuid.checkDashesAndLength(str);
                long uuidHi = Uuid.parseHi(str);
                long uuidLo = Uuid.parseLo(str);
                dstFixMem.putLong(uuidLo);
                dstFixMem.putLong(uuidHi);
                return;
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        dstFixMem.putLong(Long.MIN_VALUE);
        dstFixMem.putLong(Long.MIN_VALUE);
    }

    private static boolean stringFromBoolean(long srcAddr, CharSink<?> sink) {
        byte value = Unsafe.getUnsafe().getByte(srcAddr);
        sink.put(value != 0);
        return true;
    }

    private static boolean stringFromByte(long srcAddr, CharSink<?> sink) {
        byte value = Unsafe.getUnsafe().getByte(srcAddr);
        sink.put(value);
        return true;
    }

    private static boolean stringFromChar(long srcAddr, CharSink<?> sink) {
        char value = Unsafe.getUnsafe().getChar(srcAddr);
        if (value != '\u0000') {
            sink.put(value);
            return true;
        }
        return false;
    }

    private static boolean stringFromDate(long srcAddr, CharSink<?> sink) {
        long value = Unsafe.getUnsafe().getLong(srcAddr);
        if (value != Long.MIN_VALUE) {
            sink.putISODateMillis(value);
            return true;
        }
        return false;
    }

    private static boolean stringFromDouble(long srcAddr, CharSink<?> sink) {
        double value = Unsafe.getUnsafe().getDouble(srcAddr);
        if (!Numbers.isNull(value)) {
            sink.put(value);
            return true;
        }
        return false;
    }

    private static boolean stringFromFloat(long srcAddr, CharSink<?> sink) {
        float value = Unsafe.getUnsafe().getFloat(srcAddr);
        if (!Numbers.isNull(value)) {
            sink.put(value);
            return true;
        }
        return false;
    }

    private static boolean stringFromIPv4(long srcAddr, CharSink<?> sink) {
        int value = Unsafe.getUnsafe().getInt(srcAddr);
        if (value != 0) {
            Numbers.intToIPv4Sink(sink, value);
            return true;
        }
        return false;
    }

    private static boolean stringFromInt(long srcAddr, CharSink<?> sink) {
        int value = Unsafe.getUnsafe().getInt(srcAddr);
        if (value != Integer.MIN_VALUE) {
            sink.put(value);
            return true;
        }
        return false;
    }

    private static boolean stringFromLong(long srcAddr, CharSink<?> sink) {
        long value = Unsafe.getUnsafe().getLong(srcAddr);
        if (value != Long.MIN_VALUE) {
            sink.put(value);
            return true;
        }
        return false;
    }

    private static boolean stringFromShort(long srcAddr, CharSink<?> sink) {
        short value = Unsafe.getUnsafe().getShort(srcAddr);
        sink.put(value);
        return true;
    }

    private static boolean stringFromTimestamp(long srcAddr, CharSink<?> sink) {
        long value = Unsafe.getUnsafe().getLong(srcAddr);
        if (value != Long.MIN_VALUE) {
            TimestampFormatUtils.appendDateTimeUSec(sink, value);
            return true;
        }
        return false;
    }

    private static boolean stringFromUuid(long srcAddr, CharSink<?> sink) {
        long lo = Unsafe.getUnsafe().getLong(srcAddr);
        long hi = Unsafe.getUnsafe().getLong(srcAddr + 8L);
        if (lo != Long.MIN_VALUE || hi != Long.MIN_VALUE) {
            Numbers.appendUuid(lo, hi, sink);
            return true;
        }
        return false;
    }

    private static CairoException unsupportedConversion(int srcColumnType, int dstColumnType) {
        return CairoException.critical(0).put("Unsupported conversion from ").put(ColumnType.nameOf(srcColumnType)).put(" to ").put(ColumnType.nameOf(dstColumnType));
    }

    @FunctionalInterface
    public static interface Var2FixedConverter<T> {
        public void convert(T var1, MemoryCMARW var2);
    }

    @FunctionalInterface
    private static interface Fixed2VarConverter {
        public boolean convert(long var1, CharSink<?> var3);
    }
}

