/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.TelemetryConfiguration;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.griffin.QueryBuilder;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MPSequence;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Os;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8s;
import io.questdb.tasks.AbstractTelemetryTask;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class Telemetry<T extends AbstractTelemetryTask>
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Telemetry.class);
    private final boolean enabled;
    private final int maxFileNameLen;
    private MicrosecondClock clock;
    private long dbSizeEstimateStartTimestamp;
    private long dbSizeEstimateTimeout;
    private MPSequence telemetryPubSeq;
    private RingQueue<T> telemetryQueue;
    private SCSequence telemetrySubSeq;
    private TelemetryType<T> telemetryType;
    private TableWriter writer;
    private final QueueConsumer<T> taskConsumer = this::consume;

    public Telemetry(TelemetryTypeBuilder<T> builder, CairoConfiguration configuration) {
        TelemetryType<T> type = builder.build(configuration);
        TelemetryConfiguration telemetryConfiguration = type.getTelemetryConfiguration(configuration);
        this.enabled = telemetryConfiguration.getEnabled();
        this.maxFileNameLen = configuration.getMaxFileNameLength();
        if (this.enabled) {
            this.telemetryType = type;
            this.clock = configuration.getMicrosecondClock();
            this.dbSizeEstimateTimeout = telemetryConfiguration.getDbSizeEstimateTimeout() * 1000L;
            this.telemetryQueue = new RingQueue<T>(type.getTaskFactory(), telemetryConfiguration.getQueueCapacity());
            this.telemetryPubSeq = new MPSequence(this.telemetryQueue.getCycle());
            this.telemetrySubSeq = new SCSequence();
            this.telemetryPubSeq.then(this.telemetrySubSeq).then(this.telemetryPubSeq);
        }
    }

    public void clear() {
        if (this.writer != null) {
            this.consumeAll();
            this.telemetryType.logStatus(this.writer, (short)101, this.clock.getTicks());
            this.writer = Misc.free(this.writer);
        }
    }

    @Override
    public void close() {
        try {
            this.clear();
        }
        finally {
            this.telemetryQueue = Misc.free(this.telemetryQueue);
        }
    }

    public void consume(T task) {
        task.writeTo(this.writer, this.clock.getTicks());
    }

    public void consumeAll() {
        if (this.enabled && this.telemetrySubSeq.consumeAll(this.telemetryQueue, this.taskConsumer)) {
            this.writer.commit();
        }
    }

    public String getName() {
        return this.telemetryType.getName();
    }

    public void init(CairoEngine engine, SqlCompiler compiler, SqlExecutionContext sqlExecutionContext) throws SqlException {
        TableToken tableToken;
        boolean shouldDropTable;
        String tableName;
        block13: {
            if (!this.enabled) {
                return;
            }
            tableName = this.telemetryType.getTableName();
            shouldDropTable = false;
            try {
                tableToken = engine.verifyTableName(tableName);
                try (TableMetadata meta = engine.getTableMetadata(tableToken);){
                    shouldDropTable = meta.getTtlHoursOrMonths() == 0;
                }
            }
            catch (CairoException e) {
                if (Chars.contains(e.getFlyweightMessage(), "table does not exist")) break block13;
                throw e;
            }
        }
        if (shouldDropTable) {
            compiler.query().$("DROP TABLE '").$(tableName).$("'").compile(sqlExecutionContext).getOperation().execute(sqlExecutionContext, null).await();
        }
        this.telemetryType.getCreateSql(compiler.query()).createTable(sqlExecutionContext);
        tableToken = engine.verifyTableName(tableName);
        try {
            this.writer = engine.getWriter(tableToken, "telemetry");
        }
        catch (CairoException ex) {
            LOG.error().$("could not open [table=`").$(tableToken).$("`, msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
        }
        this.telemetryType.logStatus(this.writer, (short)100, this.clock.getTicks());
        if (this.telemetryType.shouldLogClasses()) {
            this.telemetryType.logStatus(this.writer, Telemetry.getOSClass(), this.clock.getTicks());
            this.telemetryType.logStatus(this.writer, Telemetry.getEnvTypeClass(), this.clock.getTicks());
            this.telemetryType.logStatus(this.writer, Telemetry.getCpuClass(), this.clock.getTicks());
            this.telemetryType.logStatus(this.writer, this.getDBSizeClass(engine.getConfiguration()), this.clock.getTicks());
            this.telemetryType.logStatus(this.writer, Telemetry.getTableCountClass(engine), this.clock.getTicks());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public T nextTask() {
        if (!this.enabled) {
            return null;
        }
        long cursor = this.telemetryPubSeq.next();
        if (cursor < 0L) {
            return null;
        }
        AbstractTelemetryTask task = (AbstractTelemetryTask)this.telemetryQueue.get(cursor);
        task.setQueueCursor(cursor);
        return (T)task;
    }

    public void store(T task) {
        this.telemetryPubSeq.done(task.getQueueCursor());
    }

    private static short getCpuClass() {
        int cpus = Runtime.getRuntime().availableProcessors();
        if (cpus <= 4) {
            return -20;
        }
        if (cpus <= 8) {
            return -21;
        }
        if (cpus <= 16) {
            return -22;
        }
        if (cpus <= 32) {
            return -23;
        }
        if (cpus <= 64) {
            return -24;
        }
        return -25;
    }

    private static short getEnvTypeClass() {
        int type = Os.getEnvironmentType();
        return (short)(-50 - type);
    }

    private static short getOSClass() {
        if (Os.isLinux()) {
            return -10;
        }
        if (Os.isOSX()) {
            return -11;
        }
        if (Os.isWindows()) {
            return -12;
        }
        return -13;
    }

    private static short getTableCountClass(CairoEngine engine) {
        long tableCount = engine.getTableTokenCount(false);
        if (tableCount <= 10L) {
            return -40;
        }
        if (tableCount <= 25L) {
            return -41;
        }
        if (tableCount <= 50L) {
            return -42;
        }
        if (tableCount <= 100L) {
            return -43;
        }
        if (tableCount <= 250L) {
            return -44;
        }
        if (tableCount <= 1000L) {
            return -45;
        }
        return -46;
    }

    private short getDBSizeClass(CairoConfiguration configuration) {
        long dbSize;
        this.dbSizeEstimateStartTimestamp = this.clock.getTicks();
        try {
            Path path = Path.PATH.get().of(configuration.getDbRoot());
            dbSize = this.getDirSize(configuration.getFilesFacade(), path, true, Misc.getThreadLocalSink());
            if (this.hasTimedOut()) {
                LOG.info().$("Unable to estimate DB size, disk scanning timed out").$();
                return -29;
            }
        }
        catch (Throwable e) {
            LOG.info().$("Unable to estimate DB size, error=").$(e).$();
            return -29;
        }
        if (dbSize <= 0x280000000L) {
            return -30;
        }
        if (dbSize <= 0xC80000000L) {
            return -31;
        }
        if (dbSize <= 0x1900000000L) {
            return -32;
        }
        if (dbSize <= 0x7D00000000L) {
            return -33;
        }
        if (dbSize <= 0x10000000000L) {
            return -34;
        }
        if (dbSize <= 0x50000000000L) {
            return -35;
        }
        if (dbSize <= 0xA0000000000L) {
            return -36;
        }
        return -37;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDirSize(FilesFacade ff, Path path, boolean topLevel, StringSink sink) {
        long totalSize = 0L;
        long pFind = ff.findFirst(path.$());
        if (pFind > 0L) {
            int len = path.size();
            try {
                do {
                    if (this.hasTimedOut()) {
                        long l = 0L;
                        return l;
                    }
                    long nameUtf8Ptr = ff.findName(pFind);
                    path.trimTo(len).concat(nameUtf8Ptr).$();
                    if (ff.findType(pFind) == 8) {
                        totalSize += ff.length(path.$());
                        continue;
                    }
                    if (!Files.notDots(nameUtf8Ptr)) continue;
                    if (topLevel) {
                        sink.clear();
                        Utf8s.utf8ToUtf16(path, len + 1, path.size(), sink);
                        int tableNameLen = Chars.indexOf(sink, '~');
                        if (tableNameLen > -1) {
                            sink.trimTo(tableNameLen);
                        }
                        if (!TableUtils.isValidTableName(sink, this.maxFileNameLen)) continue;
                    }
                    totalSize += this.getDirSize(ff, path, false, sink);
                } while (ff.findNext(pFind) > 0);
            }
            finally {
                ff.findClose(pFind);
                path.trimTo(len);
            }
        }
        return totalSize;
    }

    protected boolean hasTimedOut() {
        return this.clock.getTicks() - this.dbSizeEstimateStartTimestamp > this.dbSizeEstimateTimeout;
    }

    public static interface TelemetryTypeBuilder<T extends AbstractTelemetryTask> {
        public TelemetryType<T> build(CairoConfiguration var1);
    }

    public static interface TelemetryType<T extends AbstractTelemetryTask> {
        public QueryBuilder getCreateSql(QueryBuilder var1);

        public String getName();

        public String getTableName();

        public ObjectFactory<T> getTaskFactory();

        default public TelemetryConfiguration getTelemetryConfiguration(@NotNull CairoConfiguration configuration) {
            return configuration.getTelemetryConfiguration();
        }

        default public void logStatus(TableWriter writer, short systemStatus, long micros) {
        }

        default public boolean shouldLogClasses() {
            return false;
        }
    }
}

