/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.context;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springaicommunity.mcp.context.McpRequestContextTypes;

public class DefaultSamplingSpec
implements McpRequestContextTypes.SamplingSpec {
    protected List<McpSchema.SamplingMessage> messages = new ArrayList<McpSchema.SamplingMessage>();
    protected McpSchema.ModelPreferences modelPreferences;
    protected String systemPrompt;
    protected Double temperature;
    protected Integer maxTokens;
    protected List<String> stopSequences = new ArrayList<String>();
    protected Map<String, Object> metadata = new HashMap<String, Object>();
    protected Map<String, Object> meta = new HashMap<String, Object>();
    protected McpSchema.CreateMessageRequest.ContextInclusionStrategy includeContextStrategy = McpSchema.CreateMessageRequest.ContextInclusionStrategy.NONE;

    @Override
    public McpRequestContextTypes.SamplingSpec message(McpSchema.ResourceLink ... content) {
        return this.messageInternal((McpSchema.Content[])content);
    }

    @Override
    public McpRequestContextTypes.SamplingSpec message(McpSchema.EmbeddedResource ... content) {
        return this.messageInternal((McpSchema.Content[])content);
    }

    @Override
    public McpRequestContextTypes.SamplingSpec message(McpSchema.AudioContent ... content) {
        return this.messageInternal((McpSchema.Content[])content);
    }

    @Override
    public McpRequestContextTypes.SamplingSpec message(McpSchema.ImageContent ... content) {
        return this.messageInternal((McpSchema.Content[])content);
    }

    @Override
    public McpRequestContextTypes.SamplingSpec message(McpSchema.TextContent ... content) {
        return this.messageInternal((McpSchema.Content[])content);
    }

    private McpRequestContextTypes.SamplingSpec messageInternal(McpSchema.Content ... content) {
        this.messages.addAll(List.of(content).stream().map(c -> new McpSchema.SamplingMessage(McpSchema.Role.USER, c)).toList());
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec message(McpSchema.SamplingMessage ... message) {
        this.messages.addAll(List.of(message));
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec modelPreferences(Consumer<McpRequestContextTypes.ModelPreferenceSpec> modelPreferenceSpec) {
        DefaultModelPreferenceSpec modelPreferencesSpec = new DefaultModelPreferenceSpec();
        modelPreferenceSpec.accept(modelPreferencesSpec);
        this.modelPreferences = McpSchema.ModelPreferences.builder().hints(modelPreferencesSpec.modelHints).costPriority(modelPreferencesSpec.costPriority).speedPriority(modelPreferencesSpec.speedPriority).intelligencePriority(modelPreferencesSpec.intelligencePriority).build();
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec systemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec includeContextStrategy(McpSchema.CreateMessageRequest.ContextInclusionStrategy includeContextStrategy) {
        this.includeContextStrategy = includeContextStrategy;
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec temperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec maxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec stopSequences(String ... stopSequences) {
        this.stopSequences.addAll(List.of(stopSequences));
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec metadata(Map<String, Object> m) {
        this.metadata.putAll(m);
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec metadata(String k, Object v) {
        this.metadata.put(k, v);
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec meta(Map<String, Object> m) {
        this.meta.putAll(m);
        return this;
    }

    @Override
    public McpRequestContextTypes.SamplingSpec meta(String k, Object v) {
        this.meta.put(k, v);
        return this;
    }

    public static class DefaultModelPreferenceSpec
    implements McpRequestContextTypes.ModelPreferenceSpec {
        private List<McpSchema.ModelHint> modelHints = new ArrayList<McpSchema.ModelHint>();
        private Double costPriority;
        private Double speedPriority;
        private Double intelligencePriority;

        @Override
        public McpRequestContextTypes.ModelPreferenceSpec modelHints(String ... models) {
            Assert.notNull((Object)models, (String)"Models must not be null");
            this.modelHints.addAll(List.of(models).stream().map(McpSchema.ModelHint::new).toList());
            return this;
        }

        @Override
        public McpRequestContextTypes.ModelPreferenceSpec modelHint(String modelHint) {
            Assert.notNull((Object)modelHint, (String)"Model hint must not be null");
            this.modelHints.add(new McpSchema.ModelHint(modelHint));
            return this;
        }

        @Override
        public McpRequestContextTypes.ModelPreferenceSpec costPriority(Double costPriority) {
            this.costPriority = costPriority;
            return this;
        }

        @Override
        public McpRequestContextTypes.ModelPreferenceSpec speedPriority(Double speedPriority) {
            this.speedPriority = speedPriority;
            return this;
        }

        @Override
        public McpRequestContextTypes.ModelPreferenceSpec intelligencePriority(Double intelligencePriority) {
            this.intelligencePriority = intelligencePriority;
            return this;
        }
    }
}

