/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.utils.uri.URISchema;

public class URIFactory<T, P> {
    private URI defaultURI;
    private final Map<String, URISchema<T, P>> schemas = new ConcurrentHashMap<String, URISchema<T, P>>();

    public URI getDefaultURI() {
        return this.defaultURI;
    }

    public void setDefaultURI(URI uri) {
        this.defaultURI = uri;
    }

    public void registerSchema(URISchema<T, P> schemaFactory) {
        this.schemas.put(schemaFactory.getSchemaName(), schemaFactory);
        schemaFactory.setFactory(this);
    }

    public void removeSchema(String schemaName) {
        this.schemas.remove(schemaName);
    }

    public URI expandURI(String uriString) throws Exception {
        return this.normalise(uriString);
    }

    public T newObject(URI uri, P param) throws Exception {
        return Objects.requireNonNull(this.schemas.get(uri.getScheme()), "Schema " + uri.getScheme() + " not found").newObject(uri, param);
    }

    public T newObject(URI uri, Map<String, String> overrides, P param) throws Exception {
        return Objects.requireNonNull(this.schemas.get(uri.getScheme()), "Schema " + uri.getScheme() + " not found").newObject(uri, overrides, param);
    }

    public T newObject(String uri, P param) throws Exception {
        return this.newObject(new URI(uri), param);
    }

    public void populateObject(URI uri, T bean) throws Exception {
        Objects.requireNonNull(this.schemas.get(uri.getScheme()), "Schema " + uri.getScheme() + " not found").populateObject(uri, bean);
    }

    public void populateObject(String uri, T bean) throws Exception {
        this.populateObject(new URI(uri), bean);
    }

    public URI createSchema(String scheme, T bean) throws Exception {
        return Objects.requireNonNull(this.schemas.get(scheme), "Schema " + scheme + " not found").newURI(bean);
    }

    private URI normalise(String uri) throws URISyntaxException {
        if (uri.startsWith("(")) {
            String[] split = uri.split("\\)", 2);
            String[] connectorURIS = split[0].substring(split[0].indexOf(40) + 1).split(",");
            String factoryQuery = split.length > 1 ? split[1] : "";
            StringBuilder builder = new StringBuilder(connectorURIS[0]);
            if (factoryQuery != null && !factoryQuery.isEmpty()) {
                if (connectorURIS[0].contains("?")) {
                    builder.append("&").append(factoryQuery.substring(1));
                } else {
                    builder.append(factoryQuery);
                }
            }
            if (connectorURIS.length > 1) {
                builder.append("#");
                for (int i = 1; i < connectorURIS.length; ++i) {
                    if (i > 1) {
                        builder.append(",");
                    }
                    builder.append(connectorURIS[i]);
                }
            }
            return new URI(builder.toString().replace(";", "&"));
        }
        return new URI(uri.replace(";", "&"));
    }
}

