/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.AbstractStringEncoderTest;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.language.RefinedSoundex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RefinedSoundexTest
extends AbstractStringEncoderTest<RefinedSoundex> {
    RefinedSoundexTest() {
    }

    @Override
    protected RefinedSoundex createStringEncoder() {
        return new RefinedSoundex();
    }

    @Test
    void testDifference() throws EncoderException {
        Assertions.assertEquals((int)0, (int)((RefinedSoundex)this.getStringEncoder()).difference(null, null));
        Assertions.assertEquals((int)0, (int)((RefinedSoundex)this.getStringEncoder()).difference("", ""));
        Assertions.assertEquals((int)0, (int)((RefinedSoundex)this.getStringEncoder()).difference(" ", " "));
        Assertions.assertEquals((int)6, (int)((RefinedSoundex)this.getStringEncoder()).difference("Smith", "Smythe"));
        Assertions.assertEquals((int)3, (int)((RefinedSoundex)this.getStringEncoder()).difference("Ann", "Andrew"));
        Assertions.assertEquals((int)1, (int)((RefinedSoundex)this.getStringEncoder()).difference("Margaret", "Andrew"));
        Assertions.assertEquals((int)1, (int)((RefinedSoundex)this.getStringEncoder()).difference("Janet", "Margaret"));
        Assertions.assertEquals((int)5, (int)((RefinedSoundex)this.getStringEncoder()).difference("Green", "Greene"));
        Assertions.assertEquals((int)1, (int)((RefinedSoundex)this.getStringEncoder()).difference("Blotchet-Halls", "Greene"));
        Assertions.assertEquals((int)6, (int)((RefinedSoundex)this.getStringEncoder()).difference("Smith", "Smythe"));
        Assertions.assertEquals((int)8, (int)((RefinedSoundex)this.getStringEncoder()).difference("Smithers", "Smythers"));
        Assertions.assertEquals((int)5, (int)((RefinedSoundex)this.getStringEncoder()).difference("Anothers", "Brothers"));
    }

    @Test
    void testEncode() {
        Assertions.assertEquals((Object)"T6036084", (Object)((RefinedSoundex)this.getStringEncoder()).encode("testing"));
        Assertions.assertEquals((Object)"T6036084", (Object)((RefinedSoundex)this.getStringEncoder()).encode("TESTING"));
        Assertions.assertEquals((Object)"T60", (Object)((RefinedSoundex)this.getStringEncoder()).encode("The"));
        Assertions.assertEquals((Object)"Q503", (Object)((RefinedSoundex)this.getStringEncoder()).encode("quick"));
        Assertions.assertEquals((Object)"B1908", (Object)((RefinedSoundex)this.getStringEncoder()).encode("brown"));
        Assertions.assertEquals((Object)"F205", (Object)((RefinedSoundex)this.getStringEncoder()).encode("fox"));
        Assertions.assertEquals((Object)"J408106", (Object)((RefinedSoundex)this.getStringEncoder()).encode("jumped"));
        Assertions.assertEquals((Object)"O0209", (Object)((RefinedSoundex)this.getStringEncoder()).encode("over"));
        Assertions.assertEquals((Object)"T60", (Object)((RefinedSoundex)this.getStringEncoder()).encode("the"));
        Assertions.assertEquals((Object)"L7050", (Object)((RefinedSoundex)this.getStringEncoder()).encode("lazy"));
        Assertions.assertEquals((Object)"D6043", (Object)((RefinedSoundex)this.getStringEncoder()).encode("dogs"));
        Assertions.assertEquals((Object)"D6043", (Object)RefinedSoundex.US_ENGLISH.encode("dogs"));
    }

    @Test
    void testGetMappingCodeNonLetter() {
        char code = ((RefinedSoundex)this.getStringEncoder()).getMappingCode('#');
        Assertions.assertEquals((int)0, (int)code, (String)"Code does not equals zero");
    }

    @Test
    void testInvalidSoundexCharacter() {
        char[] invalid = new char[256];
        for (int i = 0; i < invalid.length; ++i) {
            invalid[i] = (char)i;
        }
        Assertions.assertEquals((Object)new RefinedSoundex().encode(new String(invalid)), (Object)"A0136024043780159360205050136024043780159360205053");
    }

    @Test
    void testNewInstance() {
        Assertions.assertEquals((Object)"D6043", (Object)new RefinedSoundex().soundex("dogs"));
    }

    @Test
    void testNewInstance2() {
        Assertions.assertEquals((Object)"D6043", (Object)new RefinedSoundex("01360240043788015936020505".toCharArray()).soundex("dogs"));
    }

    @Test
    void testNewInstance3() {
        Assertions.assertEquals((Object)"D6043", (Object)new RefinedSoundex("01360240043788015936020505").soundex("dogs"));
    }
}

