/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.AreaIterator;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.geom.AreaOp;
import sun.awt.geom.Crossings;
import sun.awt.geom.Curve;

public class Area
implements Shape,
Cloneable {
    private static Vector EmptyCurves = new Vector();
    private Vector curves;
    private Rectangle2D cachedBounds;

    public Area() {
        this.curves = EmptyCurves;
    }

    public Area(Shape shape) {
        this.curves = shape instanceof Area ? ((Area)shape).curves : Area.pathToCurves(shape.getPathIterator(null));
    }

    private static Vector pathToCurves(PathIterator pathIterator) {
        Vector vector = new Vector();
        int n = pathIterator.getWindingRule();
        double[] dArray = new double[23];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    Curve.insertLine(vector, d3, d4, d, d2);
                    d3 = d = dArray[0];
                    d4 = d2 = dArray[1];
                    Curve.insertMove(vector, d, d2);
                    break;
                }
                case 1: {
                    double d5 = dArray[0];
                    double d6 = dArray[1];
                    Curve.insertLine(vector, d3, d4, d5, d6);
                    d3 = d5;
                    d4 = d6;
                    break;
                }
                case 2: {
                    double d5 = dArray[2];
                    double d6 = dArray[3];
                    Curve.insertQuad(vector, d3, d4, dArray);
                    d3 = d5;
                    d4 = d6;
                    break;
                }
                case 3: {
                    double d5 = dArray[4];
                    double d6 = dArray[5];
                    Curve.insertCubic(vector, d3, d4, dArray);
                    d3 = d5;
                    d4 = d6;
                    break;
                }
                case 4: {
                    Curve.insertLine(vector, d3, d4, d, d2);
                    d3 = d;
                    d4 = d2;
                }
            }
            pathIterator.next();
        }
        Curve.insertLine(vector, d3, d4, d, d2);
        AreaOp areaOp = n == 0 ? new AreaOp.EOWindOp() : new AreaOp.NZWindOp();
        return areaOp.calculate(vector, EmptyCurves);
    }

    public void add(Area area) {
        this.curves = new AreaOp.AddOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void subtract(Area area) {
        this.curves = new AreaOp.SubOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void intersect(Area area) {
        this.curves = new AreaOp.IntOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void exclusiveOr(Area area) {
        this.curves = new AreaOp.XorOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void reset() {
        this.curves = new Vector();
        this.invalidateBounds();
    }

    public boolean isEmpty() {
        return this.curves.size() == 0;
    }

    public boolean isPolygonal() {
        Enumeration enumeration = this.curves.elements();
        while (enumeration.hasMoreElements()) {
            if (((Curve)enumeration.nextElement()).getOrder() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isRectangular() {
        int n = this.curves.size();
        if (n == 0) {
            return true;
        }
        if (n > 3) {
            return false;
        }
        Curve curve = (Curve)this.curves.get(1);
        Curve curve2 = (Curve)this.curves.get(2);
        if (curve.getOrder() != 1 || curve2.getOrder() != 1) {
            return false;
        }
        if (curve.getXTop() != curve.getXBot() || curve2.getXTop() != curve2.getXBot()) {
            return false;
        }
        return curve.getYTop() == curve2.getYTop() && curve.getYBot() == curve2.getYBot();
    }

    public boolean isSingular() {
        if (this.curves.size() < 3) {
            return true;
        }
        Enumeration enumeration = this.curves.elements();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            if (((Curve)enumeration.nextElement()).getOrder() != 0) continue;
            return false;
        }
        return true;
    }

    private void invalidateBounds() {
        this.cachedBounds = null;
    }

    private Rectangle2D getCachedBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (this.curves.size() > 0) {
            Curve curve = (Curve)this.curves.get(0);
            ((Rectangle2D)double_).setRect(curve.getX0(), curve.getY0(), 0.0, 0.0);
            for (int i = 1; i < this.curves.size(); ++i) {
                ((Curve)this.curves.get(i)).enlarge(double_);
            }
        }
        this.cachedBounds = double_;
        return this.cachedBounds;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getCachedBounds().getBounds2D();
    }

    @Override
    public Rectangle getBounds() {
        return this.getCachedBounds().getBounds();
    }

    public Object clone() {
        return new Area(this);
    }

    public boolean equals(Area area) {
        if (area == this) {
            return true;
        }
        if (area == null) {
            return false;
        }
        Vector vector = new AreaOp.XorOp().calculate(this.curves, area.curves);
        return vector.isEmpty();
    }

    public void transform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new NullPointerException("transform must not be null");
        }
        this.curves = Area.pathToCurves(this.getPathIterator(affineTransform));
        this.invalidateBounds();
    }

    public Area createTransformedArea(AffineTransform affineTransform) {
        Area area = new Area(this);
        area.transform(affineTransform);
        return area;
    }

    @Override
    public boolean contains(double d, double d2) {
        if (!this.getCachedBounds().contains(d, d2)) {
            return false;
        }
        Enumeration enumeration = this.curves.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            n += curve.crossingsFor(d, d2);
        }
        return n & true;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        if (d3 < 0.0 || d4 < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().contains(d, d2, d3, d4)) {
            return false;
        }
        Crossings crossings = Crossings.findCrossings(this.curves, d, d2, d + d3, d2 + d4);
        return crossings != null && crossings.covers(d2, d2 + d4);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        if (d3 < 0.0 || d4 < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().intersects(d, d2, d3, d4)) {
            return false;
        }
        Crossings crossings = Crossings.findCrossings(this.curves, d, d2, d + d3, d2 + d4);
        return crossings == null || !crossings.isEmpty();
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new AreaIterator(this.curves, affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }
}

