/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.data;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCNumberValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class DB2DecFloatValueHandler
extends JDBCNumberValueHandler {
    static final int DECFLOAT_SPECIALVALUE_ENCOUNTERED = -4231;

    public DB2DecFloatValueHandler(DBSTypedObject type, DBDFormatSettings formatSettings) {
        super(type, formatSettings);
    }

    @Nullable
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        try {
            return resultSet.getBigDecimal(index);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -4231) {
                return resultSet.getDouble(index);
            }
            throw e;
        }
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws SQLException, DBCException {
        if (value instanceof BigDecimal) {
            statement.setBigDecimal(paramIndex, (BigDecimal)value);
        } else if (value instanceof Double) {
            statement.setDouble(paramIndex, ((Double)value).doubleValue());
        } else {
            super.bindParameter(session, statement, paramType, paramIndex, value);
        }
    }
}

