import { type ChildProcessWithoutNullStreams, type SpawnOptions } from 'child_process';
export declare function spawn(command: string, args?: string[] | ReadonlyArray<string>, options?: SpawnPromiseOptions): ChildProcessWithoutNullStreamsAndPromise;
export interface ChildProcessWithoutNullStreamsAndPromise extends ChildProcessWithoutNullStreams {
    promise: Promise<number>;
    then<TResult1 = number, TResult2 = never>(onfulfilled?: ((value: number) => TResult1 | PromiseLike<TResult1>) | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | null): Promise<TResult1 | TResult2>;
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | null): Promise<number | TResult>;
    finally(onfinally?: (() => void) | null): Promise<number>;
}
export interface SpawnPromiseOptions extends SpawnOptions {
    rejectOnNonZero?: boolean;
}
export default spawn;
