/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.json.JsonBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FixPropertyNameTypoFix
extends PsiUpdateModCommandQuickFix {
    private final String myAltName;
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public FixPropertyNameTypoFix(String altName, JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myAltName = altName;
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message((String)"fix.property.name.spelling", (Object[])new Object[]{this.myAltName});
        if (string == null) {
            FixPropertyNameTypoFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        JsonLikePsiWalker walker;
        if (project == null) {
            FixPropertyNameTypoFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            FixPropertyNameTypoFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            FixPropertyNameTypoFix.$$$reportNull$$$0(3);
        }
        if ((walker = JsonLikePsiWalker.getWalker(element)) == null) {
            return;
        }
        JsonPropertyAdapter parentProperty = walker.getParentPropertyAdapter(element);
        if (parentProperty == null) {
            return;
        }
        PsiElement newProperty = walker.getSyntaxAdapter(project).createProperty(this.myAltName, "foo", project);
        parentProperty.getNameValueAdapter().getDelegate().replace(walker.getParentPropertyAdapter(newProperty).getNameValueAdapter().getDelegate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/FixPropertyNameTypoFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/FixPropertyNameTypoFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

