/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.reindex;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.SlicedScroll;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.reindex.RemoteSource;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Source
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Source> {
    @Nonnull
    private final List<String> index;
    @Nullable
    private final Query query;
    @Nullable
    private final RemoteSource remote;
    @Nullable
    private final Integer size;
    @Nullable
    private final SlicedScroll slice;
    @Nonnull
    private final List<SortOptions> sort;
    @Nonnull
    private final List<String> sourceFields;
    public static final JsonpDeserializer<Source> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Source::setupSourceDeserializer);

    private Source(Builder builder) {
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.query = builder.query;
        this.remote = builder.remote;
        this.size = builder.size;
        this.slice = builder.slice;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.sourceFields = ApiTypeHelper.unmodifiable(builder.sourceFields);
    }

    public static Source of(Function<Builder, ObjectBuilder<Source>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final RemoteSource remote() {
        return this.remote;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final SlicedScroll slice() {
        return this.slice;
    }

    @Nonnull
    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Nonnull
    public final List<String> sourceFields() {
        return this.sourceFields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.writeStartArray();
        for (String string : this.index) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.remote != null) {
            generator.writeKey("remote");
            this.remote.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.slice != null) {
            generator.writeKey("slice");
            this.slice.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.sourceFields)) {
            generator.writeKey("_source");
            generator.writeStartArray();
            for (String string : this.sourceFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::remote, RemoteSource._DESERIALIZER, "remote");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::slice, SlicedScroll._DESERIALIZER, "slice");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
        op.add(Builder::sourceFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "_source");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.query);
        result = 31 * result + Objects.hashCode(this.remote);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.slice);
        result = 31 * result + Objects.hashCode(this.sort);
        result = 31 * result + Objects.hashCode(this.sourceFields);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Source other = (Source)o;
        return this.index.equals(other.index) && Objects.equals(this.query, other.query) && Objects.equals(this.remote, other.remote) && Objects.equals(this.size, other.size) && Objects.equals(this.slice, other.slice) && Objects.equals(this.sort, other.sort) && Objects.equals(this.sourceFields, other.sourceFields);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Source> {
        private List<String> index;
        @Nullable
        private Query query;
        @Nullable
        private RemoteSource remote;
        @Nullable
        private Integer size;
        @Nullable
        private SlicedScroll slice;
        @Nullable
        private List<SortOptions> sort;
        @Nullable
        private List<String> sourceFields;

        public Builder() {
        }

        private Builder(Source o) {
            this.index = Builder._listCopy(o.index);
            this.query = o.query;
            this.remote = o.remote;
            this.size = o.size;
            this.slice = o.slice;
            this.sort = Builder._listCopy(o.sort);
            this.sourceFields = Builder._listCopy(o.sourceFields);
        }

        private Builder(Builder o) {
            this.index = Builder._listCopy(o.index);
            this.query = o.query;
            this.remote = o.remote;
            this.size = o.size;
            this.slice = o.slice;
            this.sort = Builder._listCopy(o.sort);
            this.sourceFields = Builder._listCopy(o.sourceFields);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Nonnull
        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder remote(@Nullable RemoteSource value) {
            this.remote = value;
            return this;
        }

        @Nonnull
        public final Builder remote(Function<RemoteSource.Builder, ObjectBuilder<RemoteSource>> fn) {
            return this.remote(fn.apply(new RemoteSource.Builder()).build());
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder slice(@Nullable SlicedScroll value) {
            this.slice = value;
            return this;
        }

        @Nonnull
        public final Builder slice(Function<SlicedScroll.Builder, ObjectBuilder<SlicedScroll>> fn) {
            return this.slice(fn.apply(new SlicedScroll.Builder()).build());
        }

        @Nonnull
        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        @Nonnull
        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        @Nonnull
        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        @Nonnull
        public final Builder sourceFields(List<String> list) {
            this.sourceFields = Builder._listAddAll(this.sourceFields, list);
            return this;
        }

        @Nonnull
        public final Builder sourceFields(String value, String ... values) {
            this.sourceFields = Builder._listAdd(this.sourceFields, value, values);
            return this;
        }

        @Override
        @Nonnull
        public Source build() {
            this._checkSingleUse();
            return new Source(this);
        }
    }
}

