/*
 * Decompiled with CFR 0.152.
 */
package HMAC;

import HMAC._ExternBase___default;
import Wrappers_Compile.Result;
import dafny.Array;
import dafny.DafnySequence;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;

public class HMac
extends _ExternBase___default {
    private String algorithm;
    private Mac hmac;

    public static Result<HMac, Error> Build(DigestAlgorithm digest) {
        try {
            HMac output = new HMac(digest);
            return HMac.CreateHMacSuccess(output);
        }
        catch (NoSuchAlgorithmException ex) {
            Error err = ToDafny.Error(AwsCryptographicPrimitivesError.builder().message("Requested digest Algorithm is not supported.").cause(ex).build());
            return HMac.CreateHMacFailure(err);
        }
    }

    public HMac(DigestAlgorithm digest) throws NoSuchAlgorithmException {
        if (digest.is_SHA__256()) {
            this.algorithm = "HmacSHA256";
        } else if (digest.is_SHA__384()) {
            this.algorithm = "HmacSHA384";
        } else if (digest.is_SHA__512()) {
            this.algorithm = "HmacSHA512";
        } else {
            throw new NoSuchAlgorithmException();
        }
        this.hmac = Mac.getInstance(this.algorithm);
    }

    public void Init(DafnySequence<? extends Byte> key) {
        byte[] keyBytes = (byte[])Array.unwrap((Array)key.toArray());
        try {
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, this.algorithm);
            this.hmac.init(secretKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Encountered InvalidKeyException: " + e.getMessage());
        }
    }

    public void BlockUpdate(DafnySequence<? extends Byte> input) {
        byte[] inputBytes = (byte[])Array.unwrap((Array)input.toArray());
        this.hmac.update(inputBytes);
    }

    public DafnySequence<? extends Byte> GetResult() {
        byte[] digest = this.hmac.doFinal();
        return DafnySequence.fromBytes((byte[])digest);
    }
}

