/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableBufferImpl;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.HeapNonNativeWritableBufferImpl;
import com.yahoo.memory.Util;
import com.yahoo.memory.WritableBufferImpl;
import java.nio.ByteOrder;

final class HeapWritableBufferImpl
extends WritableBufferImpl {
    private static final int id = 64;
    private final Object unsafeObj;
    private final byte typeId;

    HeapWritableBufferImpl(Object unsafeObj, long regionOffset, long capacityBytes, int typeId, BaseWritableMemoryImpl originMemory) {
        super(unsafeObj, 0L, regionOffset, capacityBytes, originMemory);
        this.unsafeObj = unsafeObj;
        this.typeId = (byte)(0x40 | typeId & 7);
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return Util.isNativeOrder(byteOrder) ? new HeapWritableBufferImpl(this.unsafeObj, this.getRegionOffset(offsetBytes), capacityBytes, type, this.originMemory) : new HeapNonNativeWritableBufferImpl(this.unsafeObj, this.getRegionOffset(offsetBytes), capacityBytes, type, this.originMemory);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 4 | (readOnly ? 1 : 0);
        return Util.isNativeOrder(byteOrder) ? new HeapWritableBufferImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, this.originMemory) : new HeapNonNativeWritableBufferImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, this.originMemory);
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    Object getUnsafeObject() {
        return this.unsafeObj;
    }
}

