/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.infinispan.commons.util.Experimental;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.Traversable;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.SimpleFunctionalMap;
import org.infinispan.functional.impl.Traversables;
import org.infinispan.notifications.cachelistener.CacheNotifier;

@Experimental
public class SimpleReadOnlyMapImpl<K, V>
extends ReadOnlyMapImpl<K, V>
implements SimpleFunctionalMap<K, V> {
    private static final String KEY_CANNOT_BE_NULL = "Key cannot be null";
    private static final String FUNCTION_CANNOT_BE_NULL = "Function cannot be null";
    private final CacheNotifier<K, V> notifier;

    SimpleReadOnlyMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(params, functionalMap);
        this.notifier = ComponentRegistry.componentOf(functionalMap.cache, CacheNotifier.class);
    }

    @Override
    public <R> CompletableFuture<R> eval(K key, Function<EntryView.ReadEntryView<K, V>, R> f) {
        try {
            return this.internalEval(key, f);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    @Override
    public <R> Traversable<R> evalMany(Set<? extends K> keys, Function<EntryView.ReadEntryView<K, V>, R> f) {
        ArrayList<R> results = new ArrayList<R>(keys.size());
        for (K key : keys) {
            R r = this.toLocalExecution(this.eval(key, f));
            results.add(r);
        }
        return Traversables.of(results.stream());
    }

    private <R> CompletableFuture<R> internalEval(K key, Function<EntryView.ReadEntryView<K, V>, R> f) {
        EntryView.ReadEntryView view;
        Objects.requireNonNull(key, KEY_CANNOT_BE_NULL);
        Objects.requireNonNull(f, FUNCTION_CANNOT_BE_NULL);
        K storageKey = this.toStorageKey(key);
        InternalCacheEntry ice = this.fmap.cache.getDataContainer().peek(storageKey);
        boolean notify = false;
        if (ice == null || ice.isNull()) {
            view = EntryViews.noValue(storageKey, this.fmap.cache.getKeyDataConversion());
        } else {
            view = EntryViews.readOnly(ice, this.fmap.cache.getKeyDataConversion(), this.fmap.cache.getValueDataConversion());
            notify = true;
        }
        if (notify && this.hasListeners()) {
            CompletionStages.join(this.notifier.notifyCacheEntryVisited(ice.getKey(), ice.getValue(), true, ImmutableContext.INSTANCE, null));
        }
        R r = EntryViews.snapshot(f.apply(view));
        if (notify && this.hasListeners()) {
            CompletionStages.join(this.notifier.notifyCacheEntryVisited(ice.getKey(), ice.getValue(), false, ImmutableContext.INSTANCE, null));
        }
        if (r == null) {
            return CompletableFutures.completedNull();
        }
        return CompletableFuture.completedFuture(r);
    }

    private boolean hasListeners() {
        return this.notifier.hasListeners();
    }
}

