/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.EnumType;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.boot.model.process.internal.EnumeratedValueConverter;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class EnumJavaType<T extends Enum<T>>
extends AbstractClassJavaType<T> {
    public EnumJavaType(Class<T> type) {
        super(type, ImmutableMutabilityPlan.instance());
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(this.sqlType(context));
    }

    private int sqlType(JdbcTypeIndicators context) {
        EnumType enumType = context.getEnumeratedType();
        boolean preferNativeEnumTypes = context.isPreferNativeEnumTypesEnabled();
        JdbcTypeRegistry jdbcTypeRegistry = context.getTypeConfiguration().getJdbcTypeRegistry();
        return switch (enumType == null ? EnumType.ORDINAL : enumType) {
            default -> throw new IncompatibleClassChangeError();
            case EnumType.ORDINAL -> {
                if (preferNativeEnumTypes && jdbcTypeRegistry.hasRegisteredDescriptor(6002)) {
                    yield 6002;
                }
                if (preferNativeEnumTypes && jdbcTypeRegistry.hasRegisteredDescriptor(6003)) {
                    yield 6003;
                }
                if (this.hasManyValues()) {
                    yield 5;
                }
                yield -6;
            }
            case EnumType.STRING -> {
                if (jdbcTypeRegistry.hasRegisteredDescriptor(6000)) {
                    yield 6000;
                }
                if (preferNativeEnumTypes && jdbcTypeRegistry.hasRegisteredDescriptor(6001)) {
                    yield 6001;
                }
                if (context.getColumnLength() == 1L) {
                    if (context.isNationalized()) {
                        yield -15;
                    }
                    yield 1;
                }
                yield context.isNationalized() ? -9 : 12;
            }
        };
    }

    public boolean hasManyValues() {
        return ((Enum[])this.getJavaTypeClass().getEnumConstants()).length > 128;
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(T value) {
        return value == null ? "<null>" : ((Enum)value).name();
    }

    @Override
    public T fromString(CharSequence string) {
        return string == null ? null : (T)Enum.valueOf(this.getJavaTypeClass(), string.toString());
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (String.class.equals(type)) {
            return (X)this.toName(value);
        }
        if (Long.class.equals(type)) {
            return (X)this.toLong(value);
        }
        if (Integer.class.equals(type)) {
            return (X)this.toInteger(value);
        }
        if (Short.class.equals(type)) {
            return (X)this.toShort(value);
        }
        if (Byte.class.equals(type)) {
            return (X)this.toByte(value);
        }
        return (X)value;
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String string = (String)value;
            return this.fromName(string);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return this.fromLong(longValue);
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return this.fromInteger(integerValue);
        }
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return this.fromShort(shortValue);
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return this.fromByte(byteValue);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return this.fromLong(number.longValue());
        }
        return (T)((Enum)value);
    }

    public Byte toByte(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return (byte)((Enum)domainForm).ordinal();
    }

    public Short toShort(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return (short)((Enum)domainForm).ordinal();
    }

    public Integer toInteger(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).ordinal();
    }

    public Long toLong(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).ordinal();
    }

    public Integer toOrdinal(T domainForm) {
        return this.toInteger(domainForm);
    }

    public T fromByte(Byte relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm];
    }

    public T fromShort(Short relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm];
    }

    public T fromInteger(Integer relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm];
    }

    public T fromLong(Long relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm.intValue()];
    }

    public T fromOrdinal(Integer relationalForm) {
        return this.fromInteger(relationalForm);
    }

    public String toName(T domainForm) {
        return domainForm == null ? null : ((Enum)domainForm).name();
    }

    public T fromName(String relationalForm) {
        return relationalForm == null ? null : (T)Enum.valueOf(this.getJavaTypeClass(), relationalForm.trim());
    }

    @Override
    public String getCheckCondition(String columnName, JdbcType jdbcType, BasicValueConverter<T, ?> converter, Dialect dialect) {
        if (converter != null && jdbcType.getDefaultSqlTypeCode() != 6001) {
            return this.renderConvertedEnumCheckConstraint(columnName, jdbcType, converter, dialect);
        }
        if (jdbcType.isInteger()) {
            int max = ((Enum[])this.getJavaTypeClass().getEnumConstants()).length - 1;
            return dialect.getCheckCondition(columnName, 0L, max);
        }
        if (jdbcType.isString()) {
            return dialect.getCheckCondition(columnName, this.getJavaTypeClass());
        }
        return null;
    }

    private String renderConvertedEnumCheckConstraint(String columnName, JdbcType jdbcType, BasicValueConverter<T, ?> converter, Dialect dialect) {
        Set<?> valueSet = this.valueSet(jdbcType, converter);
        return valueSet == null ? null : dialect.getCheckCondition(columnName, valueSet, jdbcType);
    }

    private <R> Set<R> valueSet(JdbcType jdbcType, BasicValueConverter<T, R> converter) {
        if (converter instanceof EnumeratedValueConverter) {
            EnumeratedValueConverter enumeratedValueConverter = (EnumeratedValueConverter)converter;
            return enumeratedValueConverter.getRelationalValueSet();
        }
        if (!SqlTypes.isIntegral(jdbcType.getJdbcTypeCode()) && !SqlTypes.isCharacterType(jdbcType.getJdbcTypeCode())) {
            return null;
        }
        Enum[] enumConstants = (Enum[])this.getJavaTypeClass().getEnumConstants();
        HashSet valueSet = CollectionHelper.setOfSize(enumConstants.length);
        for (Enum enumConstant : enumConstants) {
            valueSet.add(converter.toRelationalValue(enumConstant));
        }
        return valueSet;
    }
}

