/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.cache.spi.Region;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.stat.CacheableDataStatistics;

public abstract class AbstractCacheableDataStatistics
implements CacheableDataStatistics {
    private final @Nullable String cacheRegionName;
    private final @Nullable LongAdder cacheHitCount;
    private final @Nullable LongAdder cacheMissCount;
    private final @Nullable LongAdder cachePutCount;
    private final @Nullable LongAdder cacheRemoveCount;

    public AbstractCacheableDataStatistics(Supplier<@Nullable Region> regionSupplier) {
        Region region = regionSupplier.get();
        if (region == null) {
            this.cacheRegionName = null;
            this.cacheHitCount = null;
            this.cacheMissCount = null;
            this.cachePutCount = null;
            this.cacheRemoveCount = null;
        } else {
            this.cacheRegionName = region.getName();
            this.cacheHitCount = new LongAdder();
            this.cacheMissCount = new LongAdder();
            this.cachePutCount = new LongAdder();
            this.cacheRemoveCount = new LongAdder();
        }
    }

    @Override
    public @Nullable String getCacheRegionName() {
        return this.cacheRegionName;
    }

    @Override
    public long getCacheHitCount() {
        if (this.cacheRegionName == null) {
            return Long.MIN_VALUE;
        }
        return NullnessUtil.castNonNull(this.cacheHitCount).sum();
    }

    @Override
    public long getCachePutCount() {
        if (this.cacheRegionName == null) {
            return Long.MIN_VALUE;
        }
        return NullnessUtil.castNonNull(this.cachePutCount).sum();
    }

    @Override
    public long getCacheMissCount() {
        if (this.cacheRegionName == null) {
            return Long.MIN_VALUE;
        }
        return NullnessUtil.castNonNull(this.cacheMissCount).sum();
    }

    @Override
    public long getCacheRemoveCount() {
        if (this.cacheRegionName == null) {
            return Long.MIN_VALUE;
        }
        return NullnessUtil.castNonNull(this.cacheRemoveCount).sum();
    }

    public void incrementCacheHitCount() {
        if (this.cacheRegionName == null) {
            throw new IllegalStateException("Illegal attempt to increment cache hit count for non-cached data");
        }
        NullnessUtil.castNonNull(this.cacheHitCount).increment();
    }

    public void incrementCacheMissCount() {
        if (this.cacheRegionName == null) {
            throw new IllegalStateException("Illegal attempt to increment cache miss count for non-cached data");
        }
        NullnessUtil.castNonNull(this.cacheMissCount).increment();
    }

    public void incrementCachePutCount() {
        if (this.cacheRegionName == null) {
            throw new IllegalStateException("Illegal attempt to increment cache put count for non-cached data");
        }
        NullnessUtil.castNonNull(this.cachePutCount).increment();
    }

    public void incrementCacheRemoveCount() {
        if (this.cacheRegionName == null) {
            throw new IllegalStateException("Illegal attempt to increment cache put count for non-cached data");
        }
        NullnessUtil.castNonNull(this.cacheRemoveCount).increment();
    }

    protected void appendCacheStats(StringBuilder buf) {
        buf.append(",cacheRegion=").append(this.cacheRegionName);
        if (this.cacheRegionName == null) {
            return;
        }
        buf.append(",cacheHitCount=").append(this.getCacheHitCount()).append(",cacheMissCount=").append(this.getCacheMissCount()).append(",cachePutCount=").append(this.getCachePutCount()).append(",cacheRemoveCount=").append(this.getCacheRemoveCount());
    }
}

