/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import jakarta.annotation.Priority;
import java.util.Iterator;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

@Priority(value=4980)
public class DisabledMappersInterceptor
implements ConfigSourceInterceptor {
    private static final ThreadLocal<Boolean> ENABLED = ThreadLocal.withInitial(() -> false);

    public static void enable() {
        DisabledMappersInterceptor.enable(true);
    }

    public static void disable() {
        DisabledMappersInterceptor.enable(false);
    }

    public static void enable(boolean enable) {
        ENABLED.set(enable);
    }

    private <T> boolean isDisabledMapper(String property) {
        return property.startsWith("kc.") && PropertyMappers.isDisabledMapper(property);
    }

    Iterator<String> filterDisabledMappers(Iterator<String> iter) {
        return new FilterIterator(iter, item -> !this.isDisabledMapper((String)item));
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        return this.filterDisabledMappers(context.iterateNames());
    }

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (DisabledMappersInterceptor.isEnabled() && this.isDisabledMapper(name)) {
            return null;
        }
        return context.proceed(name);
    }

    public static boolean isEnabled() {
        return Boolean.TRUE.equals(ENABLED.get());
    }

    public static void runWithDisabled(Runnable execution) {
        if (!DisabledMappersInterceptor.isEnabled()) {
            execution.run();
            return;
        }
        try {
            DisabledMappersInterceptor.disable();
            execution.run();
        }
        finally {
            DisabledMappersInterceptor.enable();
        }
    }
}

