/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.fips;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.keycloak.common.crypto.CertificateUtilsProvider;
import org.keycloak.common.util.BouncyIntegration;

public class BCFIPSCertificateUtilsProvider
implements CertificateUtilsProvider {
    public X509Certificate generateV3Certificate(KeyPair keyPair, PrivateKey caPrivateKey, X509Certificate caCert, String subject) {
        try {
            X500Name subjectDN = new X500Name("CN=" + subject);
            SecureRandom random = new SecureRandom();
            BigInteger serialNumber = BigInteger.valueOf(Math.abs(random.nextInt()));
            Date notBefore = new Date(System.currentTimeMillis());
            Date notAfter = new Date(System.currentTimeMillis() + 93312000000L);
            SubjectPublicKeyInfo subjPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(new X500Name(caCert.getSubjectDN().getName()), serialNumber, notBefore, notAfter, subjectDN, subjPubKeyInfo);
            JcaX509ExtensionUtils x509ExtensionUtils = new JcaX509ExtensionUtils();
            certGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createSubjectKeyIdentifier(subjPubKeyInfo));
            certGen.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createAuthorityKeyIdentifier(caCert));
            certGen.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(134));
            KeyPurposeId[] EKU = new KeyPurposeId[]{KeyPurposeId.id_kp_emailProtection, KeyPurposeId.id_kp_serverAuth};
            certGen.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(EKU));
            certGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
            return new JcaX509CertificateConverter().setProvider(BouncyIntegration.PROVIDER).getCertificate(certGen.build(switch (caCert.getPublicKey().getAlgorithm()) {
                case "EC" -> new JcaContentSignerBuilder("SHA256WithECDSA").setProvider(BouncyIntegration.PROVIDER).build(caPrivateKey);
                default -> new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider(BouncyIntegration.PROVIDER).build(caPrivateKey);
            }));
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating X509v3Certificate.", e);
        }
    }

    public X509Certificate generateV1SelfSignedCertificate(KeyPair caKeyPair, String subject) {
        return this.generateV1SelfSignedCertificate(caKeyPair, subject, BigInteger.valueOf(System.currentTimeMillis()));
    }

    public X509Certificate generateV1SelfSignedCertificate(KeyPair caKeyPair, String subject, BigInteger serialNumber) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 10);
        return this.generateV1SelfSignedCertificate(caKeyPair, subject, serialNumber, calendar.getTime());
    }

    public X509Certificate generateV1SelfSignedCertificate(KeyPair caKeyPair, String subject, BigInteger serialNumber, Date validityEndDate) {
        try {
            X500Name subjectDN = new X500Name("CN=" + subject);
            Date validityStartDate = new Date(System.currentTimeMillis() - 100000L);
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)caKeyPair.getPublic().getEncoded());
            X509v1CertificateBuilder builder = new X509v1CertificateBuilder(subjectDN, serialNumber, validityStartDate, validityEndDate, subjectDN, subPubKeyInfo);
            X509CertificateHolder holder = builder.build(this.createSigner(caKeyPair.getPrivate()));
            return new JcaX509CertificateConverter().getCertificate(holder);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating X509v1Certificate.", e);
        }
    }

    private ContentSigner createSigner(PrivateKey privateKey) {
        try {
            return (switch (privateKey.getAlgorithm()) {
                case "RSA" -> new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider(BouncyIntegration.PROVIDER);
                case "EC" -> new JcaContentSignerBuilder("SHA256WithECDSA").setProvider(BouncyIntegration.PROVIDER);
                case "Ed25519", "Ed448" -> new JcaContentSignerBuilder(privateKey.getAlgorithm()).setProvider(BouncyIntegration.PROVIDER);
                default -> throw new RuntimeException(String.format("Keytype %s is not supported.", privateKey.getAlgorithm()));
            }).build(privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create content signer.", e);
        }
    }

    public List<String> getCertificatePolicyList(X509Certificate cert) throws GeneralSecurityException {
        Extensions certExtensions = new JcaX509CertificateHolder(cert).getExtensions();
        if (certExtensions == null) {
            throw new GeneralSecurityException("Certificate Policy validation was expected, but no certificate extensions were found");
        }
        CertificatePolicies policies = CertificatePolicies.fromExtensions((Extensions)certExtensions);
        if (policies == null) {
            throw new GeneralSecurityException("Certificate Policy validation was expected, but no certificate policy extensions were found");
        }
        LinkedList<String> policyList = new LinkedList<String>();
        Arrays.stream(policies.getPolicyInformation()).forEach(p -> policyList.add(p.getPolicyIdentifier().toString().toLowerCase()));
        return policyList;
    }

    public List<String> getCRLDistributionPoints(X509Certificate cert) throws IOException {
        CRLDistPoint crlDP;
        DEROctetString octetString;
        byte[] data = cert.getExtensionValue("2.5.29.31");
        if (data == null) {
            return Collections.emptyList();
        }
        LinkedList<String> distributionPointUrls = new LinkedList<String>();
        try (ASN1InputStream crldpExtensionInputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(data));){
            octetString = (DEROctetString)crldpExtensionInputStream.readObject();
        }
        byte[] octets = octetString.getOctets();
        try (ASN1InputStream crldpInputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(octets));){
            crlDP = CRLDistPoint.getInstance((Object)crldpInputStream.readObject());
        }
        for (DistributionPoint dp : crlDP.getDistributionPoints()) {
            GeneralName[] names;
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            for (GeneralName gn : names = GeneralNames.getInstance((Object)dpn.getName()).getNames()) {
                if (gn.getTagNo() != 6) continue;
                String url = DERIA5String.getInstance((Object)gn.getName()).getString();
                distributionPointUrls.add(url);
            }
        }
        return distributionPointUrls;
    }

    public X509Certificate createServicesTestCertificate(String dn, Date startDate, Date expiryDate, KeyPair keyPair, String ... certificatePolicyOid) {
        X500Name subjectDN = new X500Name(dn);
        X500Name issuerDN = new X500Name(dn);
        SubjectPublicKeyInfo subjPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Sequence.getInstance((Object)keyPair.getPublic().getEncoded()));
        BigInteger serialNumber = new BigInteger(130, new SecureRandom());
        X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(issuerDN, serialNumber, startDate, expiryDate, subjectDN, subjPubKeyInfo);
        if (certificatePolicyOid != null) {
            try {
                for (Extension certExtension : this.certPolicyExtensions(certificatePolicyOid)) {
                    certGen.addExtension(certExtension);
                }
            }
            catch (CertIOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256withRSA").setProvider(BouncyIntegration.PROVIDER).build(keyPair.getPrivate());
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(BouncyIntegration.PROVIDER).getCertificate(certGen.build(contentSigner));
            return x509Certificate;
        }
        catch (CertificateException | OperatorCreationException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<Extension> certPolicyExtensions(String ... certificatePolicyOid) {
        LinkedList<Extension> certificatePolicies = new LinkedList<Extension>();
        if (certificatePolicyOid != null && certificatePolicyOid.length > 0) {
            LinkedList<PolicyInformation> policyInfoList = new LinkedList<PolicyInformation>();
            for (String oid : certificatePolicyOid) {
                policyInfoList.add(new PolicyInformation(new ASN1ObjectIdentifier(oid)));
            }
            CertificatePolicies policies = new CertificatePolicies(policyInfoList.toArray(new PolicyInformation[0]));
            try {
                boolean isCritical = false;
                Extension extension = new Extension(Extension.certificatePolicies, isCritical, policies.getEncoded());
                certificatePolicies.add(extension);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return certificatePolicies;
    }
}

