/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.util.TextUtils;

public class SecretProperty
extends PropertyBean {
    private static final String SHOW_TEXT_KEY = "OptionPanel.secret.show";
    private static final String HIDE_TEXT_KEY = "OptionPanel.secret.hide";
    private static final String SHOW_TEXT_FALLBACK = "Show";
    private static final String HIDE_TEXT_FALLBACK = "Hide";
    private static final String SHOW_ICON_PATH = "/images/eye.svg?useAccentColor=true";
    private static final String HIDE_ICON_PATH = "/images/hide.svg?useAccentColor=true";
    private final JPasswordField passwordField = new JPasswordField();
    private final JButton toggleVisibilityButton;
    private final char maskEchoChar;
    private final Icon showIcon;
    private final Icon hideIcon;
    private boolean valueVisible;

    public SecretProperty(String name) {
        super(name);
        char configuredEchoChar = this.passwordField.getEchoChar();
        this.maskEchoChar = (char)(configuredEchoChar == '\u0000' ? 8226 : (int)configuredEchoChar);
        this.passwordField.setEchoChar(this.maskEchoChar);
        this.passwordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SecretProperty.this.firePropertyChangeEvent();
            }
        });
        this.toggleVisibilityButton = new JButton();
        this.toggleVisibilityButton.setMaximumSize(new Dimension(1000, 1000));
        this.showIcon = this.loadIcon(SHOW_ICON_PATH);
        this.hideIcon = this.loadIcon(HIDE_ICON_PATH);
        this.toggleVisibilityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SecretProperty.this.setValueVisible(!SecretProperty.this.valueVisible);
            }
        });
        this.setValueVisible(false);
    }

    @Override
    public String getValue() {
        return new String(this.passwordField.getPassword());
    }

    @Override
    public JComponent getValueComponent() {
        return this.passwordField;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        Box row = Box.createHorizontalBox();
        row.add(this.passwordField);
        row.add(this.toggleVisibilityButton);
        this.appendToForm(builder, row);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.passwordField.setEnabled(enabled);
        this.toggleVisibilityButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void setValue(String value) {
        this.passwordField.setText(value);
        this.passwordField.selectAll();
    }

    JButton getToggleVisibilityButton() {
        return this.toggleVisibilityButton;
    }

    boolean isValueVisible() {
        return this.valueVisible;
    }

    private void setValueVisible(boolean valueVisible) {
        Icon icon;
        this.valueVisible = valueVisible;
        this.passwordField.setEchoChar(valueVisible ? (char)'\u0000' : this.maskEchoChar);
        String textKey = valueVisible ? HIDE_TEXT_KEY : SHOW_TEXT_KEY;
        String fallback = valueVisible ? HIDE_TEXT_FALLBACK : SHOW_TEXT_FALLBACK;
        Icon icon2 = icon = valueVisible ? this.hideIcon : this.showIcon;
        if (icon != null) {
            this.toggleVisibilityButton.setIcon(icon);
            this.toggleVisibilityButton.setText(null);
        } else {
            this.toggleVisibilityButton.setIcon(null);
            LabelAndMnemonicSetter.setLabelAndMnemonic(this.toggleVisibilityButton, this.translatedText(textKey, fallback));
        }
        this.toggleVisibilityButton.setToolTipText(this.translatedText(textKey, fallback));
    }

    private String translatedText(String key, String fallback) {
        try {
            return TextUtils.getText(key);
        }
        catch (RuntimeException runtimeException) {
            return fallback;
        }
    }

    private Icon loadIcon(String resourcePath) {
        try {
            return ResourceController.getResourceController().getImageIcon(resourcePath);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }
}

