/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.FakeConstr;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.DimacsStringSolver;

public class LPStringSolver
extends DimacsStringSolver
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    private ObjectiveFunction obj;
    private boolean inserted = false;

    public LPStringSolver(int initSize) {
        super(initSize);
    }

    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        for (int p : assumps) {
            if (p > 0) {
                this.getOut().append("x" + p + " >= 1 \n");
            } else {
                this.getOut().append("- x" + -p + " >= 0 \n");
            }
            ++this.nbOfConstraints;
        }
        throw new TimeoutException();
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        if (moreThan) {
            return this.addAtLeast(lits, coeffs, d);
        }
        return this.addAtMost(lits, coeffs, d);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        this.obj = obj;
    }

    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        StringBuilder out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        boolean first = true;
        for (int p : literals) {
            assert (p != 0);
            if (first) {
                if (p > 0) {
                    this.getOut().append("x" + p + " ");
                } else {
                    this.getOut().append("- x" + -p + " ");
                    ++negationweight;
                }
                first = false;
                continue;
            }
            if (p > 0) {
                out.append("+ x" + p + " ");
                continue;
            }
            out.append("- x" + -p + " ");
            ++negationweight;
        }
        out.append(">= " + (degree - negationweight) + " \n");
        return FakeConstr.instance();
    }

    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        StringBuilder out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        boolean first = true;
        for (int p : literals) {
            assert (p != 0);
            if (first) {
                if (p > 0) {
                    this.getOut().append("- x" + p + " ");
                } else {
                    this.getOut().append("x" + -p + " ");
                    ++negationweight;
                }
                first = false;
                continue;
            }
            if (p > 0) {
                out.append("- x" + p + " ");
                continue;
            }
            out.append("+ x" + -p + " ");
            ++negationweight;
        }
        out.append(">= " + (-degree + negationweight) + " \n");
        return FakeConstr.instance();
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        StringBuilder out = this.getOut();
        ++this.nbOfConstraints;
        boolean first = true;
        int negationweight = 0;
        for (int lit : literals) {
            if (first) {
                if (lit > 0) {
                    out.append("x" + lit + " ");
                } else {
                    out.append("-x" + -lit + " ");
                    ++negationweight;
                }
                first = false;
                continue;
            }
            if (lit > 0) {
                out.append("+ x" + lit + " ");
                continue;
            }
            out.append("- x" + -lit + " ");
            ++negationweight;
        }
        out.append(">= " + (1 - negationweight) + "\n");
        return FakeConstr.instance();
    }

    public String getExplanation() {
        return null;
    }

    public void setListOfVariablesForExplanation(IVecInt listOfVariables) {
    }

    public void objectiveFunctionToLP(ObjectiveFunction obj, StringBuilder buffer) {
        buffer.append("Minimize \n");
        buffer.append("obj: ");
        IVecInt variables = obj.getVars();
        IVec<BigInteger> coeffs = obj.getCoeffs();
        int n = variables.size();
        if (n > 0) {
            buffer.append(coeffs.get(0));
            buffer.append("x");
            buffer.append(variables.get(0));
            buffer.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            BigInteger coeff = (BigInteger)coeffs.get(i);
            if (coeff.signum() > 0) {
                buffer.append("+ " + coeff);
            } else {
                buffer.append("- " + coeff.negate());
            }
            buffer.append("x");
            buffer.append(variables.get(i));
            buffer.append(" ");
        }
    }

    public String toString() {
        StringBuilder out = this.getOut();
        if (!this.inserted) {
            StringBuilder tmp = new StringBuilder();
            if (this.obj != null) {
                this.objectiveFunctionToLP(this.obj, tmp);
                tmp.append("\n");
                tmp.append("Subject To\n ");
            }
            out.insert(this.indxConstrObj, tmp.toString());
            this.inserted = true;
        }
        out.append("Binary \n");
        for (int i = 1; i <= this.nVars(); ++i) {
            out.append("x" + i + "\n");
        }
        out.append("\n");
        out.append("End");
        return out.toString();
    }

    public String toString(String prefix) {
        return this.toString();
    }

    public int newVar(int howmany) {
        StringBuilder out = this.getOut();
        this.setNbVars(howmany);
        this.indxConstrObj = out.length();
        out.append("\n");
        return howmany;
    }

    public void setExpectedNumberOfClauses(int nb) {
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.obj;
    }

    public int nConstraints() {
        return this.nbOfConstraints;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        StringBuilder out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int n = literals.size();
        if (n > 0) {
            out.append(-coeffs.get(0));
            out.append("x");
            out.append(literals.get(0));
            out.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            int coeff = coeffs.get(i);
            if (coeff > 0) {
                out.append("+ " + -coeff);
            } else {
                out.append("- " + coeff);
            }
            out.append("x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append(">= ");
        out.append(-degree);
        out.append(" \n");
        return FakeConstr.instance();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        StringBuilder out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int n = literals.size();
        if (n > 0) {
            out.append(((BigInteger)coeffs.get(0)).negate());
            out.append("x");
            out.append(literals.get(0));
            out.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            BigInteger coeff = (BigInteger)coeffs.get(i);
            if (coeff.signum() < 0) {
                out.append("+ " + coeff.negate());
            } else {
                out.append("- " + coeff);
            }
            out.append("x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append(">= ");
        out.append(degree.negate());
        out.append(" \n");
        return FakeConstr.instance();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        StringBuilder out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int n = literals.size();
        if (n > 0) {
            out.append(coeffs.get(0));
            out.append("x");
            out.append(literals.get(0));
            out.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            int coeff = coeffs.get(i);
            if (coeff > 0) {
                out.append("+ " + coeff);
            } else {
                out.append("- " + coeff * -1);
            }
            out.append("x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append(">= ");
        out.append(degree);
        out.append(" \n");
        return FakeConstr.instance();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        StringBuilder out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int n = literals.size();
        if (n > 0) {
            out.append(coeffs.get(0));
            out.append("x");
            out.append(literals.get(0));
            out.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            BigInteger coeff = (BigInteger)coeffs.get(i);
            if (coeff.signum() > 0) {
                out.append("+ " + coeff);
            } else {
                out.append("- " + coeff.negate());
            }
            out.append("x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append(">= ");
        out.append(degree);
        out.append(" \n");
        return FakeConstr.instance();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        StringBuilder out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int n = literals.size();
        if (n > 0) {
            out.append(coeffs.get(0));
            out.append("x");
            out.append(literals.get(0));
            out.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            int coeff = coeffs.get(i);
            if (coeff > 0) {
                out.append("+ " + coeff);
            } else {
                out.append("- " + coeff * -1);
            }
            out.append("x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append("= ");
        out.append(weight);
        out.append(" \n");
        return FakeConstr.instance();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        StringBuilder out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int n = literals.size();
        if (n > 0) {
            out.append(coeffs.get(0));
            out.append("x");
            out.append(literals.get(0));
            out.append(" ");
        }
        for (int i = 1; i < n; ++i) {
            BigInteger coeff = (BigInteger)coeffs.get(i);
            if (coeff.signum() > 0) {
                out.append("+ " + coeff);
            } else {
                out.append("- " + coeff.negate());
            }
            out.append("x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append("= ");
        out.append(weight);
        out.append(" \n");
        return FakeConstr.instance();
    }
}

