/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.representer;

import it.krzeminski.snakeyaml.engine.kmp.api.DumpSettings;
import it.krzeminski.snakeyaml.engine.kmp.api.RepresentToNode;
import it.krzeminski.snakeyaml.engine.kmp.common.FlowStyle;
import it.krzeminski.snakeyaml.engine.kmp.common.NonPrintableStyle;
import it.krzeminski.snakeyaml.engine.kmp.common.ScalarStyle;
import it.krzeminski.snakeyaml.engine.kmp.exceptions.YamlEngineException;
import it.krzeminski.snakeyaml.engine.kmp.nodes.Node;
import it.krzeminski.snakeyaml.engine.kmp.nodes.Tag;
import it.krzeminski.snakeyaml.engine.kmp.representer.BaseRepresenter;
import it.krzeminski.snakeyaml.engine.kmp.scanner.StreamReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u001b\u001a\u00020\t2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eH\u0084\b\u00f8\u0001\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/representer/CommonRepresenter;", "Lit/krzeminski/snakeyaml/engine/kmp/representer/BaseRepresenter;", "settings", "Lit/krzeminski/snakeyaml/engine/kmp/api/DumpSettings;", "<init>", "(Lit/krzeminski/snakeyaml/engine/kmp/api/DumpSettings;)V", "classTags", "", "Lkotlin/reflect/KClass;", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/Tag;", "getClassTags", "()Ljava/util/Map;", "representString", "Lit/krzeminski/snakeyaml/engine/kmp/api/RepresentToNode;", "representBoolean", "getRepresentBoolean", "()Lit/krzeminski/snakeyaml/engine/kmp/api/RepresentToNode;", "representNumber", "getRepresentNumber", "representList", "representIterator", "representArray", "representPrimitiveArray", "representMap", "representSet", "representEnum", "representByteArray", "getTag", "clazz", "defaultTag", "Lkotlin/Function0;", "Companion", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nCommonRepresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonRepresenter.kt\nit/krzeminski/snakeyaml/engine/kmp/representer/CommonRepresenter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n231#1:239\n231#1:240\n231#1:241\n231#1:242\n231#1:243\n231#1:250\n231#1:251\n1279#2,2:244\n1293#2,4:246\n*S KotlinDebug\n*F\n+ 1 CommonRepresenter.kt\nit/krzeminski/snakeyaml/engine/kmp/representer/CommonRepresenter\n*L\n85#1:239\n100#1:240\n109#1:241\n119#1:242\n154#1:243\n165#1:250\n174#1:251\n163#1:244,2\n163#1:246,4\n*E\n"})
public class CommonRepresenter
extends BaseRepresenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DumpSettings settings;
    @NotNull
    private final Map<KClass<?>, Tag> classTags;
    @NotNull
    private final RepresentToNode representString;
    @NotNull
    private final RepresentToNode representBoolean;
    @NotNull
    private final RepresentToNode representNumber;
    @NotNull
    private final RepresentToNode representList;
    @NotNull
    private final RepresentToNode representIterator;
    @NotNull
    private final RepresentToNode representArray;
    @NotNull
    private final RepresentToNode representPrimitiveArray;
    @NotNull
    private final RepresentToNode representMap;
    @NotNull
    private final RepresentToNode representSet;
    @NotNull
    private final RepresentToNode representEnum;
    @NotNull
    private final RepresentToNode representByteArray;
    @NotNull
    private static final Regex MULTILINE_PATTERN = new Regex("[\n\u0085]");

    public CommonRepresenter(@NotNull DumpSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.settings = settings;
        this.classTags = new LinkedHashMap();
        this.representString = arg_0 -> CommonRepresenter.representString$lambda$0(this, arg_0);
        this.representBoolean = arg_0 -> CommonRepresenter.representBoolean$lambda$1(this, arg_0);
        this.representNumber = arg_0 -> CommonRepresenter.representNumber$lambda$4(this, arg_0);
        this.representList = arg_0 -> CommonRepresenter.representList$lambda$6(this, arg_0);
        this.representIterator = arg_0 -> CommonRepresenter.representIterator$lambda$9(this, arg_0);
        this.representArray = arg_0 -> CommonRepresenter.representArray$lambda$10(this, arg_0);
        this.representPrimitiveArray = arg_0 -> CommonRepresenter.representPrimitiveArray$lambda$11(this, arg_0);
        this.representMap = arg_0 -> CommonRepresenter.representMap$lambda$13(this, arg_0);
        this.representSet = arg_0 -> CommonRepresenter.representSet$lambda$16(this, arg_0);
        this.representEnum = arg_0 -> CommonRepresenter.representEnum$lambda$18(this, arg_0);
        this.representByteArray = arg_0 -> CommonRepresenter.representByteArray$lambda$19(this, arg_0);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(String.class), (Object)this.representString), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE), (Object)this.representBoolean), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Character.TYPE), (Object)this.representString), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(byte[].class), (Object)this.representByteArray), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(short[].class), (Object)this.representPrimitiveArray), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(int[].class), (Object)this.representPrimitiveArray), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(long[].class), (Object)this.representPrimitiveArray), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(float[].class), (Object)this.representPrimitiveArray), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(double[].class), (Object)this.representPrimitiveArray), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(char[].class), (Object)this.representPrimitiveArray), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(boolean[].class), (Object)this.representPrimitiveArray)};
        this.representers.putAll(MapsKt.mapOf((Pair[])pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Number.class), (Object)this.representNumber), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(List.class), (Object)this.representList), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Map.class), (Object)this.representMap), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Set.class), (Object)this.representSet), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Iterator.class), (Object)this.representIterator), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Object[].class), (Object)this.representArray), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Enum.class), (Object)this.representEnum)};
        this.parentClassRepresenters.putAll(MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    protected final Map<KClass<?>, Tag> getClassTags() {
        return this.classTags;
    }

    @NotNull
    protected final RepresentToNode getRepresentBoolean() {
        return this.representBoolean;
    }

    @NotNull
    protected final RepresentToNode getRepresentNumber() {
        return this.representNumber;
    }

    @NotNull
    protected final Tag getTag(@NotNull KClass<?> clazz, @NotNull Function0<Tag> defaultTag) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(defaultTag, (String)"defaultTag");
        boolean $i$f$getTag = false;
        Object object = this.classTags.get(clazz);
        if (object == null) {
            object = defaultTag.invoke();
        }
        return (Tag)object;
    }

    private static final Node representString$lambda$0(CommonRepresenter this$0, Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Tag tag = null;
        ScalarStyle style = ScalarStyle.PLAIN;
        String value = data.toString();
        if (this$0.settings.nonPrintableStyle == NonPrintableStyle.BINARY && !StreamReader.Companion.isPrintable(value)) {
            tag = Tag.BINARY;
            byte[] bytes = StringsKt.encodeToByteArray((String)value);
            if (!Intrinsics.areEqual((Object)StringsKt.decodeToString((byte[])bytes), (Object)value)) {
                throw new YamlEngineException("invalid string value has occurred");
            }
            value = Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])bytes, (int)0, (int)0, (int)6, null);
            style = ScalarStyle.LITERAL;
        } else {
            tag = Tag.STR;
            value = data.toString();
        }
        if (this$0.defaultScalarStyle == ScalarStyle.PLAIN && MULTILINE_PATTERN.containsMatchIn((CharSequence)value)) {
            style = ScalarStyle.LITERAL;
        }
        return this$0.representScalar(tag, value, style);
    }

    private static final Node representBoolean$lambda$1(CommonRepresenter this$0, Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String value = Intrinsics.areEqual((Object)data, (Object)true) ? "true" : "false";
        return BaseRepresenter.representScalar$default(this$0, Tag.BOOL, value, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Node representNumber$lambda$4(CommonRepresenter this$0, Object data) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data instanceof Byte || data instanceof Short || data instanceof Integer || data instanceof Long) {
            void this_$iv;
            String value = data.toString();
            BaseRepresenter baseRepresenter = this$0;
            CommonRepresenter commonRepresenter = this$0;
            KClass clazz$iv = Reflection.getOrCreateKotlinClass(data.getClass());
            boolean $i$f$getTag = false;
            Object object = ((CommonRepresenter)this_$iv).classTags.get(clazz$iv);
            if (object == null) {
                BaseRepresenter baseRepresenter2 = baseRepresenter;
                boolean bl = false;
                object = Tag.INT;
                baseRepresenter = baseRepresenter2;
            }
            node = BaseRepresenter.representScalar$default(baseRepresenter, (Tag)object, value, null, 4, null);
        } else {
            void this_$iv;
            Number number = (Number)data;
            String value = number instanceof Double && Double.isNaN(number.doubleValue()) || number instanceof Float && Float.isNaN(number.floatValue()) ? ".nan" : (Intrinsics.areEqual((Object)number, (Object)Double.POSITIVE_INFINITY) || Intrinsics.areEqual((Object)number, (Object)Float.valueOf(Float.POSITIVE_INFINITY)) ? ".inf" : (Intrinsics.areEqual((Object)number, (Object)Double.NEGATIVE_INFINITY) || Intrinsics.areEqual((Object)number, (Object)Float.valueOf(Float.NEGATIVE_INFINITY)) ? "-.inf" : number.toString()));
            BaseRepresenter baseRepresenter = this$0;
            CommonRepresenter clazz$iv = this$0;
            KClass clazz$iv2 = Reflection.getOrCreateKotlinClass(data.getClass());
            boolean $i$f$getTag = false;
            Object object = ((CommonRepresenter)this_$iv).classTags.get(clazz$iv2);
            if (object == null) {
                BaseRepresenter baseRepresenter3 = baseRepresenter;
                boolean bl = false;
                object = Tag.FLOAT;
                baseRepresenter = baseRepresenter3;
            }
            node = BaseRepresenter.representScalar$default(baseRepresenter, (Tag)object, value, null, 4, null);
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    private static final Node representList$lambda$6(CommonRepresenter this$0, Object data) {
        void this_$iv;
        CommonRepresenter commonRepresenter;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CommonRepresenter commonRepresenter2 = commonRepresenter = this$0;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(data.getClass());
        boolean $i$f$getTag = false;
        Object object = ((CommonRepresenter)this_$iv).classTags.get(clazz$iv);
        if (object == null) {
            CommonRepresenter commonRepresenter3 = commonRepresenter2;
            boolean bl = false;
            object = Tag.SEQ;
            commonRepresenter2 = commonRepresenter3;
        }
        return commonRepresenter2.representSequence((Tag)object, (List)data, this$0.settings.defaultFlowStyle);
    }

    /*
     * WARNING - void declaration
     */
    private static final Node representIterator$lambda$9(CommonRepresenter this$0, Object data) {
        void this_$iv;
        CommonRepresenter commonRepresenter;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Iterator iter2 = (Iterator)data;
        CommonRepresenter commonRepresenter2 = commonRepresenter = this$0;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(iter2.getClass());
        boolean $i$f$getTag = false;
        Object object = ((CommonRepresenter)this_$iv).classTags.get(clazz$iv);
        if (object == null) {
            CommonRepresenter commonRepresenter3 = commonRepresenter2;
            boolean bl = false;
            object = Tag.SEQ;
            commonRepresenter2 = commonRepresenter3;
        }
        return commonRepresenter2.representSequence((Tag)object, new Iterable<Object>(iter2){
            final /* synthetic */ Iterator $iter$inlined;
            {
                this.$iter$inlined = iterator;
            }

            public Iterator<Object> iterator() {
                boolean bl = false;
                return this.$iter$inlined;
            }
        }, this$0.settings.defaultFlowStyle);
    }

    private static final Node representArray$lambda$10(CommonRepresenter this$0, Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Iterable list = ArraysKt.asIterable((Object[])((Object[])data));
        return this$0.representSequence(Tag.SEQ, list, this$0.settings.defaultFlowStyle);
    }

    private static final Node representPrimitiveArray$lambda$11(CommonRepresenter this$0, Object data) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FlowStyle style = this$0.settings.defaultFlowStyle;
        Object object = data;
        if (object instanceof byte[]) {
            iterable = ArraysKt.asIterable((byte[])((byte[])data));
        } else if (object instanceof short[]) {
            iterable = ArraysKt.asIterable((short[])((short[])data));
        } else if (object instanceof int[]) {
            iterable = ArraysKt.asIterable((int[])((int[])data));
        } else if (object instanceof long[]) {
            iterable = ArraysKt.asIterable((long[])((long[])data));
        } else if (object instanceof float[]) {
            iterable = ArraysKt.asIterable((float[])((float[])data));
        } else if (object instanceof double[]) {
            iterable = ArraysKt.asIterable((double[])((double[])data));
        } else if (object instanceof char[]) {
            iterable = ArraysKt.asIterable((char[])((char[])data));
        } else if (object instanceof boolean[]) {
            iterable = ArraysKt.asIterable((boolean[])((boolean[])data));
        } else {
            throw new YamlEngineException("Unexpected primitive '" + Reflection.getOrCreateKotlinClass(data.getClass()) + '\'');
        }
        Iterable iterableData = iterable;
        return this$0.representSequence(Tag.SEQ, iterableData, style);
    }

    /*
     * WARNING - void declaration
     */
    private static final Node representMap$lambda$13(CommonRepresenter this$0, Object data) {
        void this_$iv;
        CommonRepresenter commonRepresenter;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CommonRepresenter commonRepresenter2 = commonRepresenter = this$0;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(data.getClass());
        boolean $i$f$getTag = false;
        Object object = ((CommonRepresenter)this_$iv).classTags.get(clazz$iv);
        if (object == null) {
            CommonRepresenter commonRepresenter3 = commonRepresenter2;
            boolean bl = false;
            object = Tag.MAP;
            commonRepresenter2 = commonRepresenter3;
        }
        return commonRepresenter2.representMapping((Tag)object, (Map)data, this$0.settings.defaultFlowStyle);
    }

    /*
     * WARNING - void declaration
     */
    private static final Node representSet$lambda$16(CommonRepresenter this$0, Object data) {
        void this_$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Set set = (Set)data;
        Object $this$associateWith$iv = set;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            Object t2 = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Object v = null;
            object.put(t2, v);
        }
        Map value = result$iv;
        Object object2 = $this$associateWith$iv = this$0;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(data.getClass());
        boolean $i$f$getTag = false;
        Object object3 = ((CommonRepresenter)this_$iv).classTags.get(clazz$iv);
        if (object3 == null) {
            object = object2;
            boolean bl = false;
            object3 = Tag.SET;
            object2 = object;
        }
        return ((BaseRepresenter)object2).representMapping((Tag)object3, value, this$0.settings.defaultFlowStyle);
    }

    /*
     * WARNING - void declaration
     */
    private static final Node representEnum$lambda$18(CommonRepresenter this$0, Object data) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BaseRepresenter baseRepresenter = this$0;
        CommonRepresenter commonRepresenter = this$0;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(data.getClass());
        boolean $i$f$getTag = false;
        Object object = ((CommonRepresenter)this_$iv).classTags.get(clazz$iv);
        if (object == null) {
            BaseRepresenter baseRepresenter2 = baseRepresenter;
            boolean bl = false;
            String string = Reflection.getOrCreateKotlinClass(data.getClass()).getSimpleName();
            Intrinsics.checkNotNull((Object)string);
            object = Tag.Companion.forType(string);
            baseRepresenter = baseRepresenter2;
        }
        return BaseRepresenter.representScalar$default(baseRepresenter, (Tag)object, ((Enum)data).name(), null, 4, null);
    }

    private static final Node representByteArray$lambda$19(CommonRepresenter this$0, Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this$0.representScalar(Tag.BINARY, Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])((byte[])data), (int)0, (int)0, (int)6, null), ScalarStyle.LITERAL);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/representer/CommonRepresenter$Companion;", "", "<init>", "()V", "MULTILINE_PATTERN", "Lkotlin/text/Regex;", "snakeyaml-engine-kmp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

