/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dynamodbv2.model.IncrementalExportSpecification;
import java.util.Date;

@SdkInternalApi
public class IncrementalExportSpecificationMarshaller {
    private static final MarshallingInfo<Date> EXPORTFROMTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportFromTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> EXPORTTOTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportToTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> EXPORTVIEWTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportViewType").build();
    private static final IncrementalExportSpecificationMarshaller instance = new IncrementalExportSpecificationMarshaller();

    public static IncrementalExportSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(IncrementalExportSpecification incrementalExportSpecification, ProtocolMarshaller protocolMarshaller) {
        if (incrementalExportSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)incrementalExportSpecification.getExportFromTime(), EXPORTFROMTIME_BINDING);
            protocolMarshaller.marshall((Object)incrementalExportSpecification.getExportToTime(), EXPORTTOTIME_BINDING);
            protocolMarshaller.marshall((Object)incrementalExportSpecification.getExportViewType(), EXPORTVIEWTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

