/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.tree;

import java.util.List;
import java.util.SplittableRandom;
import org.tribuo.Output;
import org.tribuo.common.tree.Node;
import org.tribuo.common.tree.SplitNode;
import org.tribuo.math.la.SparseVector;

public abstract class AbstractTrainingNode<T extends Output<T>>
implements Node<T> {
    protected static final int DEFAULT_SIZE = 16;
    protected final int depth;
    protected final int numExamples;
    protected final LeafDeterminer leafDeterminer;
    protected boolean split;
    protected int splitID;
    protected double splitValue;
    protected double impurityScore;
    protected Node<T> greaterThan;
    protected Node<T> lessThanOrEqual;

    protected AbstractTrainingNode(int depth, int numExamples, LeafDeterminer leafDeterminer) {
        this.depth = depth;
        this.numExamples = numExamples;
        this.leafDeterminer = leafDeterminer;
    }

    public abstract List<AbstractTrainingNode<T>> buildTree(int[] var1, SplittableRandom var2, boolean var3);

    public abstract Node<T> convertTree();

    public abstract float getWeightSum();

    public int getDepth() {
        return this.depth;
    }

    public boolean shouldMakeLeaf(double impurityScore, float weightSum) {
        return impurityScore == 0.0 || this.depth + 1 >= this.leafDeterminer.getMaxDepth() || weightSum < this.leafDeterminer.getMinChildWeight();
    }

    public SplitNode<T> createSplitNode() {
        Node<T> newGreaterThan = this.greaterThan;
        Node<T> newLessThan = this.lessThanOrEqual;
        if (this.greaterThan instanceof AbstractTrainingNode) {
            AbstractTrainingNode abstractGreaterThan = (AbstractTrainingNode)this.greaterThan;
            newGreaterThan = abstractGreaterThan.convertTree();
        }
        if (this.lessThanOrEqual instanceof AbstractTrainingNode) {
            AbstractTrainingNode abstractLessThan = (AbstractTrainingNode)this.lessThanOrEqual;
            newLessThan = abstractLessThan.convertTree();
        }
        return new SplitNode<T>(this.splitValue, this.splitID, this.getImpurity(), newGreaterThan, newLessThan);
    }

    @Override
    public Node<T> getNextNode(SparseVector example) {
        if (this.split) {
            double feature = example.get(this.splitID);
            if (feature > this.splitValue) {
                return this.greaterThan;
            }
            return this.lessThanOrEqual;
        }
        return null;
    }

    public int getNumExamples() {
        return this.numExamples;
    }

    @Override
    public boolean isLeaf() {
        return !this.split;
    }

    @Override
    public Node<T> copy() {
        throw new UnsupportedOperationException("Copy is not supported on training nodes.");
    }

    public static class LeafDeterminer {
        private final int maxDepth;
        private final float minChildWeight;
        private final float scaledMinImpurityDecrease;

        public LeafDeterminer(int maxDepth, float minChildWeight, float scaledMinImpurityDecrease) {
            this.maxDepth = maxDepth;
            this.minChildWeight = minChildWeight;
            this.scaledMinImpurityDecrease = scaledMinImpurityDecrease;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public float getMinChildWeight() {
            return this.minChildWeight;
        }

        public float getScaledMinImpurityDecrease() {
            return this.scaledMinImpurityDecrease;
        }
    }
}

