/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.MLMemoryContainerSearchAction;
import org.opensearch.ml.rest.AbstractMLSearchAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLSearchMemoryContainerAction
extends AbstractMLSearchAction<MLMemoryContainer> {
    private static final String ML_SEARCH_MODEL_GROUP_ACTION = "ml_search_memory_container_action";
    private static final String SEARCH_MEMORY_CONTAINER_PATH = "/_plugins/_ml/memory_containers/_search";

    public RestMLSearchMemoryContainerAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super((List<String>)ImmutableList.of((Object)SEARCH_MEMORY_CONTAINER_PATH), ".plugins-ml-am-memory-container", MLMemoryContainer.class, (ActionType<SearchResponse>)MLMemoryContainerSearchAction.INSTANCE, mlFeatureEnabledSetting);
    }

    public String getName() {
        return ML_SEARCH_MODEL_GROUP_ACTION;
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            throw new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]);
        }
        return super.prepareRequest(request, client);
    }
}

