"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notebookSavedObject = exports.getVisualizationSavedObject = exports.getSearchSavedObject = void 0;
var _shared = require("../../common/constants/shared");
var _observability_saved_object_attributes = require("../../common/types/observability_saved_object_attributes");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getVisualizationSavedObject = dataSourceEnabled => ({
  name: _observability_saved_object_attributes.VISUALIZATION_SAVED_OBJECT,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    icon: 'visQueryPPL',
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      const editPath = `#/explorer/${_observability_saved_object_attributes.VISUALIZATION_SAVED_OBJECT}:${obj.id}`;
      const editUrl = `/app/${_shared.observabilityLogsID}${editPath}`;
      return {
        path: dataSourceEnabled ? '' : editUrl,
        uiCapabilitiesPath: 'observability.show'
      };
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  migrations: {}
});
exports.getVisualizationSavedObject = getVisualizationSavedObject;
const getSearchSavedObject = dataSourceEnabled => ({
  name: _observability_saved_object_attributes.SEARCH_SAVED_OBJECT,
  icon: 'editorCodeBlock',
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      const editPath = `#/explorer/${_observability_saved_object_attributes.SEARCH_SAVED_OBJECT}:${obj.id}`;
      const editUrl = `/app/${_shared.observabilityLogsID}${editPath}`;
      return {
        path: dataSourceEnabled ? '' : editUrl,
        uiCapabilitiesPath: 'observability.show'
      };
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  migrations: {}
});
exports.getSearchSavedObject = getSearchSavedObject;
const notebookSavedObject = exports.notebookSavedObject = {
  name: _observability_saved_object_attributes.NOTEBOOK_SAVED_OBJECT,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    icon: 'notebookApp',
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      const editUrl = `/app/${_shared.observabilityNotebookID}#/${obj.id}?view=view_both`;
      return {
        path: editUrl,
        uiCapabilitiesPath: 'observability.show'
      };
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  migrations: {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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