(module ($char-constituent? $char-subsequent? $char-upper-case?
         $char-lower-case? $char-title-case? $char-alphabetic?
         $char-numeric? $char-whitespace? $char-cased?
         $char-case-ignorable? $char-category
         $char-extended-pictographic? $wb-aletter? $wb-numeric?
         $wb-katakana? $wb-extend? $wb-format? $wb-midnum?
         $wb-midletter? $wb-midnumlet? $wb-extendnumlet?
         $char-combining-class $char-dump $wb-hebrew-letter?
         $wb-single-quote? $wb-double-quote? $wb-regional-indicator?
         $wb-zwj? $wb-wsegspace?)
  (define category-mask 31)
  (define unicode-category-table
    '#(#(#(51200 51200 51200 51200 51200 51200 51200 51200 51200 51712
           772608 838144 838144 707072 51200 51200 51200 51200 51200
           51200 51200 51200 51200 51200 51200 51200 51200 51200 51200
           51200 51200 51200 1225216 34816 886784 34816 38912 34816
           34816 952322 26624 28672 34816 36864 428032 24576 559106
           34816 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 493570 428032 36864 36864 36864 34816)
         #(34816 65681 65681 65681 65681 65681 65681 65681 65681 65681
           65681 65681 65681 65681 65681 65681 65681 65681 65681 65681
           65681 65681 65681 65681 65681 65681 65681 26624 34816 28672
           40962 612352 40962 67745 67745 67745 67745 67745 67745 67745
           67745 67745 67745 67745 67745 67745 67745 67745 67745 67745
           67745 67745 67745 67745 67745 67745 67745 67745 67745 26624
           36864 28672 36864 51200)
         #(51200 51200 51200 51200 51200 838144 51200 51200 51200 51200
           51200 51200 51200 51200 51200 51200 51200 51200 51200 51200
           51200 51200 51200 51200 51200 51200 51200 51200 51200 51200
           51200 51200 45568 34820 38916 38916 38916 38916 43012 34820
           40966 44036 73892 30720 36868 380930 44036 40966 43012 36868
           20740 20740 40966 67749 34820 493574 40966 20740 73892 32768
           20740 20740 20740 34820)
         #(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 36868 65685 65685 65685 65685 65685 65685
           65685 67748 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 36868 67749 67749 67749 67749
           67749 67749 67749 67749)
         #(65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 67748 65685 67749 65685
           67749 65685 67749 65685)
         #(67749 65685 67749 65685 67749 65685 67749 65685 67749 67748
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 65685 67749 65685
           67749 65685 67749 67749)
         #(67749 65685 65685 67749 65685 67749 65685 65685 67749 65685
           65685 65685 67749 67748 65685 65685 65685 65685 67749 65685
           65685 67749 65685 65685 65685 67749 67749 67748 65685 65685
           67749 65685 65685 67749 65685 67749 65685 67749 65685 65685
           67749 65685 67748 67748 65685 67749 65685 65685 67749 65685
           65685 65685 67749 65685 67749 65685 65685 67749 67748 73860
           65685 67749 67748 67749)
         #(73860 73860 73860 73860 65685 69829 67749 65685 69829 67749
           65685 69829 67749 65685 67749 65685 67749 65685 67749 65685
           67749 65685 67749 65685 67749 65685 67749 65685 67749 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 67748 65685
           69829 67749 65685 67749 65685 65685 65685 67749 65685 67749
           65685 67749 65685 67749)
         #(65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67748 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 67748 67748 67748 67748 67748 67748 65685 65685
           67749 65685 65685 67749)
         #(67749 65685 67749 65685 65685 65685 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 67749 67749 67749 67749
           67749 67748 67749 67749 67748 67749 67748 67749 67749 67748
           67748 67748 67749 67749 67748 67749 67748 67749 67749 67748
           67749 67749 67749 67749 67749 67748 67748 67749 67748 67749
           67749 67748 67748 67749 67748 67748 67748 67748 67748 67748
           67748 67749 67748 67748)
         #(67749 67748 67749 67749 67748 67748 67748 67749 67749 67749
           67749 67749 67749 67748 67748 67748 67748 67748 67749 67748
           73860 67748 67748 67748 67748 67748 67748 67748 67748 67749
           67749 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71814 71814 71814
           71814 71814 71814 71814)
         #(71846 71846 106502 106502 106502 106502 71814 71814 71814
           71814 71814 71814 71814 71814 71814 71814 71814 71814 106502
           106502 106502 106502 106502 106502 40966 40966 40966 40966
           40966 40966 106502 106502 71846 71846 71846 71846 71846
           106502 106502 106502 106502 106502 106502 106502 71814
           106502 71814 106502 106502 106502 106502 106502 106502
           106502 106502 106502 106502 106502 106502 106502 106502
           106502 106502 106502)
         #(482617350 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 482617350 486811654 461645830 461645830
           461645830 461645830 486811654 453257222 461645830 461645830
           461645830 461645830 461645830 423897094 423897094 461645830
           461645830 461645830 461645830 423897094 423897094 461645830
           461645830 461645830 461645830 461645830 461645830 461645830
           461645830 461645830 461645830 461645830 2369542 2369542
           2369542 2369542 2369542 461645830 461645830 461645830
           461645830 482617350 482617350 482617350)
         #(482617350 482617350 482617350 482617350 482617350 503589031
           482617350 461645830 461645830 461645830 482617350 482617350
           482617350 461645830 461645830 272390 482617350 482617350
           482617350 461645830 461645830 461645830 461645830 482617350
           486811654 461645830 461645830 482617350 488908806 491005958
           491005958 488908806 491005958 491005958 488908806 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           65685 67749 65685 67749 71814 40966 65685 67749 59392 59392
           71846 67749 67749 67749 428036 65685)
         #(59392 59392 59392 59392 40966 40966 65685 493574 65685 65685
           65685 59392 65685 59392 65685 65685 67748 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 59392 65685 65685 65685 65685 65685
           65685 65685 65685 65685 67749 67749 67749 67749 67748 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749)
         #(67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 65685 67749 67749 65684 65684
           65684 67749 67749 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 67749 67749
           67749 67749 65685 67749 36868 65685 67749 65685 65685 67749
           67748 65685 65685 65685)
         #0=#(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
              65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
              65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
              65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
              65685 65685 65685 65685 65685 65685 65685 65685 67749 67749
              67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
              67749 67749 67749 67749)
         #(67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749)
         #(65685 67749 43012 482617350 482617350 482617350 482617350
           482617350 276490 276490 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749)
         #(65685 65685 67749 65685 67749 65685 67749 65685 67749 65685
           67749 65685 67749 65685 67749 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749)
         #(65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 59392 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685)
         #(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 59392 59392 71814 100356 100356 100356
           34820 100356 493574 67748 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749)
         #(67749 67749 67749 67749 67749 67749 67749 67748 67748 428036
           90116 59392 59392 43012 43012 38916 59392 461645830
           482617350 482617350 482617350 482617350 461645830 482617350
           482617350 482617350 465840134 461645830 482617350 482617350
           482617350 482617350 482617350 482617350 461645830 461645830
           461645830 461645830 461645830 461645830 482617350 482617350
           461645830 482617350 482617350 465840134 478423046 482617350
           21244038 23341190 25438342 27535494 29632646 31729798
           33826950 35924102 38021254 40118406 40118406 42215558
           44312710 46409862 24580 48507014)
         #(34820 50604166 52701318 34820 482617478 461645958 34820
           38021254 59392 59392 59392 59392 59392 59392 59392 59392
           991364 991364 991364 991364 991364 991364 991364 991364
           991364 991364 991364 991364 991364 991364 991364 991364
           991364 991364 991364 991364 991364 991364 991364 991364
           991364 991364 991364 59392 59392 59392 59392 991364 991364
           991364 991364 100356 493574 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392)
         #(380930 380930 380930 380930 380930 380930 36868 36868 36868
           34820 34820 38916 428036 428036 43012 43012 482617478
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 63187078 65284230 67381382 34820 380930 34820
           34820 34820 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(71814 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 56895622 58992774 61089926 63187078 65284230 67381382
           69478534 71575686 482617478 482617478 461645958 461645958
           482617478 482617350 482617478 482617478 482617478 461645958
           482617478 482617478 461645958 147720 147720 147720 147720
           147720 147720 147720 147720 147720 147720 34820 165892
           428036 34820 73860 73860 73672838 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860)
         #1=#(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
              73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
              73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
              73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
              73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
              73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
              73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           34820 73860 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 380930 43012 482617350
           482617350 482617478 482617478 461645958 482617478 71814
           71814 482617478 482617478 43012 461645830 482617350
           482617350 461645958 73860 73860 147720 147720 147720 147720
           147720 147720 147720 147720 147720 147720 73860 73860 73860
           43012 43012 73860)
         #(34820 34820 34820 34820 34820 34820 34820 34820 34820 34820
           34820 34820 34820 34820 59392 380930 73860 75769990 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860
           482617478 461645958 482617478 482617478 461645958 482617478
           482617478 461645958 461645958 461645958 482617478 461645958
           461645958 482617478 461645958 482617478)
         #(482617350 482617350 461645830 482617350 461645830 482617350
           461645830 482617350 461645830 482617350 482617350 59392
           59392 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 272518
           272518 272518 272518 272518 272518 272518 272518 272518
           272518 272518 73860 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392)
         #(147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 482617350 482617350
           482617350 482617350 482617350 482617350 482617350 461645830
           482617350 71814 71814 43012 34820 428036 34820 71814 59392
           59392 461645830 38916 38916)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 482617478 482617478 482617350 482617350 71814
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 71814 482617478 482617478
           482617478 71814 482617478 482617478 482617478 482617478
           482617350 59392 59392 34820 34820 34820 34820 34820 34820
           34820 34820 34820 34820 34820 34820 34820 34820 34820 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 461645830 461645830 461645830
           59392 59392 34820 59392 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 59392 59392 59392 59392 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 40966 73860
           73860 73860 73860 73860 73860 59392 380930 380930 59392
           59392 59392 59392 59392 59392 482617350 461645830 461645830
           461645830 482617350 482617350 482617350 482617350 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 71814
           482617350 482617350 482617350 482617350 482617350 461645830
           461645830 461645830 461645830 461645830 482617478 482617478
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617350 482617350
           380930 461645958 482617478 482617478 461645958 482617478
           482617478 461645958 482617350 482617350 482617350 461645830
           461645830 461645830 56895622 58992774 61089926 482617478
           482617478 482617478 461645958 482617478 482617478 461645958
           461645958 482617478 482617478 482617478 482617478 482617478)
         #(272518 272518 272518 274568 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 272518
           274568 14952454 73860 274568 274568)
         #(274568 272518 272518 272518 272518 272518 272518 272518
           272518 274568 274568 274568 274568 19146758 274568 274568
           73860 482617350 461645830 482617350 482617350 272518 272518
           272518 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 272518 272518 34820 34820 147720 147720 147720 147720
           147720 147720 147720 147720 147720 147720 34820 71814 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860)
         #(73860 272518 274568 274568 59392 73860 73860 73860 73860
           73860 73860 73860 73860 59392 59392 73860 73860 59392 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 73860 73860 73860 73860 73860 73860 73860
           59392 73860 59392 59392 59392 73860 73860 73860 73860 59392
           59392 14952454 73860 274568 274568)
         #(274568 272518 272518 272518 272518 59392 59392 274568 274568
           59392 59392 274568 274568 19146758 73860 59392 59392 59392
           59392 59392 59392 59392 59392 274568 59392 59392 59392 59392
           73860 73860 59392 73860 73860 73860 272518 272518 59392
           59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 73860 73860 38916 38916 20740 20740
           20740 20740 20740 20740 43012 38916 73860 34820 482617350
           59392)
         #(59392 272518 272518 274568 59392 73860 73860 73860 73860
           73860 73860 59392 59392 59392 59392 73860 73860 59392 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 73860 73860 73860 73860 73860 73860 73860
           59392 73860 73860 59392 73860 73860 59392 73860 73860 59392
           59392 14952454 59392 274568 274568)
         #(274568 272518 272518 59392 59392 59392 59392 272518 272518
           59392 59392 272518 272518 19146758 59392 59392 59392 272518
           59392 59392 59392 59392 59392 59392 59392 73860 73860 73860
           73860 59392 73860 59392 59392 59392 59392 59392 59392 59392
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 272518 272518 73860 73860 73860 272518 34820
           59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #(59392 272518 272518 274568 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 59392 73860 73860 73860 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 73860 73860 73860 73860 73860 73860 73860
           59392 73860 73860 59392 73860 73860 73860 73860 73860 59392
           59392 14952454 73860 274568 274568)
         #(274568 272518 272518 272518 272518 272518 59392 272518
           272518 274568 59392 274568 274568 19146758 59392 59392 73860
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 73860 73860 272518 272518
           59392 59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 34820 38916 59392 59392 59392 59392
           59392 59392 59392 73860 272518 272518 272518 272390 272390
           272390)
         #(59392 272518 274568 274568 59392 73860 73860 73860 73860
           73860 73860 73860 73860 59392 59392 73860 73860 59392 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 73860 73860 73860 73860 73860 73860 73860
           59392 73860 73860 59392 73860 73860 73860 73860 73860 59392
           59392 14952454 73860 274568 272518)
         #(274568 272518 272518 272518 272518 59392 59392 274568 274568
           59392 59392 274568 274568 19146758 59392 59392 59392 59392
           59392 59392 59392 272390 272518 274568 59392 59392 59392
           59392 73860 73860 59392 73860 73860 73860 272518 272518
           59392 59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 43012 73860 20740 20740 20740 20740
           20740 20740 59392 59392 59392 59392 59392 59392 59392 59392)
         #(59392 59392 272518 73860 59392 73860 73860 73860 73860 73860
           73860 59392 59392 59392 73860 73860 73860 59392 73860 73860
           73860 73860 59392 59392 59392 73860 73860 59392 73860 59392
           73860 73860 59392 59392 59392 73860 73860 59392 59392 59392
           73860 73860 73860 59392 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 59392 59392
           59392 59392 274568 274568)
         #(272518 274568 274568 59392 59392 59392 274568 274568 274568
           59392 274568 274568 274568 19146758 59392 59392 73860 59392
           59392 59392 59392 59392 59392 274568 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 20740 20740 20740 43012 43012 43012 43012
           43012 43012 38916 43012 59392 59392 59392 59392 59392)
         #(272518 274568 274568 274568 272390 73860 73860 73860 73860
           73860 73860 73860 73860 59392 73860 73860 73860 59392 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           59392 14952454 73860 272518 272518)
         #(272518 274568 274568 274568 274568 59392 272518 272518
           272518 59392 272518 272518 272518 19146758 59392 59392 59392
           59392 59392 59392 59392 176433286 191113350 59392 73860
           73860 73860 59392 59392 73860 59392 59392 73860 73860 272518
           272518 59392 59392 147720 147720 147720 147720 147720 147720
           147720 147720 147720 147720 59392 59392 59392 59392 59392
           59392 59392 34820 20740 20740 20740 20740 20740 20740 20740
           43012)
         #(73860 272518 274568 274568 34820 73860 73860 73860 73860
           73860 73860 73860 73860 59392 73860 73860 73860 59392 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 59392 73860 73860 73860 73860 73860 59392
           59392 14952454 73860 274568 272518)
         #(274568 274568 274568 274568 274568 59392 272518 274568
           274568 59392 274568 274568 272518 19146758 59392 59392 59392
           59392 59392 59392 59392 274568 274568 59392 59392 59392
           59392 59392 59392 73860 73860 59392 73860 73860 272518
           272518 59392 59392 147720 147720 147720 147720 147720 147720
           147720 147720 147720 147720 59392 73860 73860 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392)
         #(272518 272518 274568 274568 73860 73860 73860 73860 73860
           73860 73860 73860 73860 59392 73860 73860 73860 59392 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           19146758 19146758 73860 274568 274568)
         #(274568 272518 272518 272518 272518 59392 274568 274568
           274568 59392 274568 274568 274568 19146758 73860 43012 59392
           59392 59392 59392 73860 73860 73860 274568 20740 20740 20740
           20740 20740 20740 20740 73860 73860 73860 272518 272518
           59392 59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 20740 20740 20740 20740 20740 20740
           20740 20740 20740 43012 73860 73860 73860 73860 73860 73860)
         #(59392 272518 274568 274568 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 59392 59392 59392 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 73860 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 59392 59392 59392
           19146758 59392 59392 59392 59392 274568 274568 274568 272518
           272518 272518 59392 272518 59392 274568 274568 274568 274568
           274568 274568 274568 274568 59392 59392 59392 59392 59392
           59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 59392 59392 274568 274568 34820 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #(59392 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 272518 8324 8324 272518 272518 272518 272518 216279174
           216279174 19146886 59392 59392 59392 59392 38916)
         #(8324 8324 8324 8324 8324 8324 6278 272390 224667654
           224667654 224667654 224667654 272390 272518 272390 34820
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 34820 34820 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392)
         #(59392 8324 8324 59392 8324 59392 8324 8324 8324 8324 8324
           59392 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 59392 8324 59392 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 272518 8324 8324 272518 272518 272518 272518
           247736454 247736454 19146758 272518 272518 8324 59392 59392)
         #(8324 8324 8324 8324 8324 59392 6278 59392 256124934
           256124934 256124934 256124934 272390 272518 59392 59392
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 59392 59392 8324 8324 8324 8324 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #(73860 43012 43012 43012 34820 34820 34820 34820 34820 34820
           34820 34820 34820 34820 34820 34820 34820 34820 34820 43012
           34820 43012 43012 43012 461645830 461645830 43012 43012
           43012 43012 43012 43012 147720 147720 147720 147720 147720
           147720 147720 147720 147720 147720 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 43012 461645830 43012
           461645830 43012 453257222 26624 28672 26624 28672 274440
           274440)
         #(73860 73860 73860 73860 73860 73860 73860 73860 59392 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 59392 59392 59392 59392
           270805126 272902278 272518 277096582 272518 272518 272518
           272518 272518 272902278 272902278 272902278 272902278 272518
           274568)
         #(272902278 272518 482617350 482617350 19146758 34820
           482617350 482617350 73860 73860 73860 73860 73860 272518
           272518 272518 272518 272518 272518 272518 272518 272518
           272518 272518 59392 272518 272518 272518 272518 272518
           272518 272518 272518 272518 272518 272518 272518 272518
           272518 272518 272518 272518 272518 272518 272518 272518
           272518 272518 272518 272518 272518 272518 272518 272518
           272518 272518 272518 272518 272518 272518 272518 59392 43012
           43012)
         #(43012 43012 43012 43012 43012 43012 461645830 43012 43012
           43012 43012 43012 43012 59392 43012 43012 34820 34820 34820
           34820 34820 43012 43012 43012 43012 34820 34820 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392))
       #(#(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 274568 274568 272518
           272518 272518 272518 274568 272518 272518 272518 272518
           272518 14952454 274568 19146758 19146758 274568 274568
           272518 272518 8324)
         #(147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 34820 34820 34820 34820 34820 34820 8324 8324
           8324 8324 8324 8324 274568 274568 272518 272518 8324 8324
           8324 8324 272518 272518 272518 8324 274568 274568 274568
           8324 8324 274568 274568 274568 274568 274568 274568 274568
           8324 8324 8324 272518 272518 272518 272518 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324)
         #(8324 8324 272518 274568 274568 272518 272518 274568 274568
           274568 274568 274568 274568 461645958 8324 274568 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 274568 274568 274568 272518 43012 43012 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685)
         #(65685 65685 65685 65685 65685 65685 59392 65685 59392 59392
           59392 59392 59392 65685 59392 59392 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 34820
           71814 67749 67749 67749)
         #1# #1# #1# #1# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           73860 73860 73860 73860 59392 59392 73860 73860 73860 73860
           73860 73860 73860 59392 73860 59392 73860 73860 73860 73860
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           73860 73860 73860 73860 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           73860 73860 73860 73860 59392 59392 73860 73860 73860 73860
           73860 73860 73860 59392)
         #(73860 59392 73860 73860 73860 73860 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 59392 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 59392 73860 73860
           73860 73860 59392 59392 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 59392 59392
           482617350 482617350 482617350 34820 34820 34820 34820 34820
           34820 34820 34820 34820 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 59392 59392 59392 59392
           59392 59392 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685)
         #(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 59392 59392 67749 67749 67749 67749
           67749 67749 59392 59392)
         #(24580 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #1# #1# #1# #1# #1# #1# #1# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 43012 34820 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(1225216 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 26624 28672
           59392 59392 59392 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 34820 34820 34820 84356 84356 84356 73860
           73860 73860 73860 73860 73860 73860 73860 59392 59392 59392
           59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 272518
           272518 19146758 19148808 59392 59392 59392 59392 59392 59392
           59392 59392 59392 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 272518 272518 19148808 34820 34820 59392 59392
           59392 59392 59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 272518
           272518 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 59392 73860 73860 73860
           59392 272518 272518 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 272390 272390 274568 272518 272518
           272518 272518 272518 272518 272518 274568 274568)
         #(274568 274568 274568 274568 274568 274568 272518 274568
           274568 272390 272390 272390 272390 272390 272390 272390
           272390 272390 19146758 272390 34820 34820 34820 6278 34820
           34820 34820 38916 8324 482617350 59392 59392 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           59392 59392 59392 59392 59392 59392 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 59392 59392 59392 59392
           59392 59392)
         #(34820 34820 34820 34820 34820 34820 24580 34820 34820 34820
           34820 272390 272390 272390 380930 272390 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           59392 59392 59392 59392 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 71814 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 59392 59392 59392
           59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 272518 272518 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 478423174 73860 59392 59392 59392 59392 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 272518 272518 272518 274568 274568 274568 274568
           272518 272518 274568 274568 274568 59392 59392 59392 59392
           274568 274568 272518 274568 274568 274568 274568 274568
           274568 465840134 482617350 461645830 59392 59392 59392
           59392)
         #(43012 59392 59392 59392 34820 34820 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 59392 59392 8324 8324 8324 8324 8324
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 59392 59392 59392
           59392 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 59392
           59392 59392 59392 59392 59392 147720 147720 147720 147720
           147720 147720 147720 147720 147720 147720 20740 59392 59392
           59392 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 482617478 461645958 274568 274568 272518
           59392 59392 34820 34820 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 274568 272518
           274568 272518 272518 272518 272518 272518 272518 272518
           59392 19146758 274568 272518 274568 274568 272518 272518
           272518 272518 272518 272518 272518 272518 274568 274568
           274568 274568 274568 274568 272518 272518 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           482617350 59392 59392 461645830)
         #(147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 59392 59392 59392 59392 59392 59392 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 59392 59392 59392 59392 59392 59392 34820 34820 34820
           34820 34820 34820 34820 6278 34820 34820 34820 34820 34820
           34820 59392 59392 482617350 482617350 482617350 482617350
           482617350 461645830 461645830 461645830 461645830 461645830
           461645830 482617350 482617350 461645830 276490 461645958)
         #(461645958 482617350 482617350 461645830 461645830 482617350
           482617350 482617350 482617350 482617350 461645830 482617350
           482617478 482617478 482617478 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(272518 272518 272518 272518 274568 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 14952454 274568 272518 272518 272518
           272518 272518 274568 272518 274568 274568 274568)
         #(274568 274568 272518 274568 19148808 73860 73860 73860 73860
           73860 73860 73860 73860 59392 59392 59392 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           34820 34820 34820 34820 34820 34820 34820 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 482617350
           461645830 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 43012 43012 43012 43012 43012 43012
           43012 43012 43012 34820 34820 59392)
         #(272518 272518 274568 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 274568 272518 272518 272518 272518
           274568 274568 272518 272518 19148808 19146758 272518 272518
           73860 73860 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 14952454
           274568 272518 272518 274568 274568 274568 272518 274568
           272518 272518 272518 19148808 19148808 59392 59392 59392
           59392 59392 59392 59392 59392 34820 34820 34820 34820)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 274568 274568 274568
           274568 274568 274568 274568 274568 272518 272518 272518
           272518 272518 272518 272518 272518 274568 274568 272518
           14952454 59392 59392 59392 34820 34820 34820 34820 34820)
         #(147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 59392 59392 59392 73860 73860 73860 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 71814 71814 71814 71814 71814 71814 34820 34820)
         #(67749 67749 67749 67749 67749 67749 67749 67749 67749 59392
           59392 59392 59392 59392 59392 59392 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 59392
           59392 65685 65685 65685)
         #(34820 34820 34820 34820 34820 34820 34820 34820 59392 59392
           59392 59392 59392 59392 59392 59392 482617350 482617350
           482617350 34820 2369542 461645830 461645830 461645830
           461645830 461645830 482617350 482617350 461645830 461645830
           461645830 461645830 482617350 274440 2369542 2369542 2369542
           2369542 2369542 2369542 2369542 73860 73860 73860 73860
           461645830 73860 73860 73860 73860 73860 73860 482617350
           73860 73860 274440 482617350 482617350 73860 59392 59392
           59392 59392 59392)
         #(67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846)
         #(71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 71846 67749 67748 67748
           67748 67749 67748 67748)
         #(67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67749 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846)
         #(482617350 482617350 461645830 482617350 482617350 482617350
           482617350 482617350 482617350 482617350 461645830 482617350
           482617350 491005958 449062918 461645830 423897094 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 482617350 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617478 482617350
           486811654 478423046 478423046 461645830 457451526 482617350
           488908806 461645830 482617350 461645830)
         #2=#(65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
              65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
              65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
              65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
              65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
              65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
              65685 67749 65685 67749)
         #2#
         #(65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 67748 67748 67748 67748 67748 67749 67748 67748
           65685 67748 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749)
         #2#
         #(67749 67749 67749 67749 67749 67749 67749 67749 65685 65685
           65685 65685 65685 65685 65685 65685 67749 67749 67749 67749
           67749 67749 59392 59392 65685 65685 65685 65685 65685 65685
           59392 59392 67749 67749 67749 67749 67749 67749 67749 67749
           65685 65685 65685 65685 65685 65685 65685 65685 67749 67749
           67749 67749 67749 67749 67749 67749 65685 65685 65685 65685
           65685 65685 65685 65685)
         #(67749 67749 67749 67749 67749 67749 59392 59392 65685 65685
           65685 65685 65685 65685 59392 59392 67748 67749 67748 67749
           67748 67749 67748 67749 59392 65685 59392 65685 59392 65685
           59392 65685 67749 67749 67749 67749 67749 67749 67749 67749
           65685 65685 65685 65685 65685 65685 65685 65685 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 59392 59392)
         #(67749 67749 67749 67749 67749 67749 67749 67749 69829 69829
           69829 69829 69829 69829 69829 69829 67749 67749 67749 67749
           67749 67749 67749 67749 69829 69829 69829 69829 69829 69829
           69829 69829 67749 67749 67749 67749 67749 67749 67749 67749
           69829 69829 69829 69829 69829 69829 69829 69829 67749 67749
           67748 67749 67748 59392 67748 67748 65685 65685 65685 65685
           69829 40966 67749 40966)
         #(40966 40966 67748 67749 67748 59392 67748 67748 65685 65685
           65685 65685 69829 40966 40966 40966 67749 67749 67748 67748
           59392 59392 67748 67748 65685 65685 65685 65685 59392 40966
           40966 40966 67749 67749 67748 67748 67748 67749 67748 67748
           65685 65685 65685 65685 65685 40966 40966 40966 59392 59392
           67748 67749 67748 59392 67748 67748 65685 65685 65685 65685
           69829 40966 40966 59392))
       #(#(1225216 1225216 1225216 1225216 1225216 1225216 1225216
           45568 1225216 1225216 1225216 53250 315394 1167362 380930
           380930 24580 24580 24580 24580 24580 24580 34820 34820
           555010 557058 26624 30720 30720 32768 26624 30720 34820
           34820 34820 34820 559110 34820 34820 493574 834048 836096
           380930 380930 380930 380930 380930 635392 34820 34820 34820
           34820 34820 34820 34820 34820 34820 30720 32768 34820 35844
           34820 34820 612356)
         #(612356 34820 34820 34820 430084 26624 28672 34820 34820
           35844 34820 34820 34820 34820 34820 34820 34820 34820 36868
           34820 612356 34820 34820 34820 34820 34820 34820 34820 34820
           34820 34820 1225216 380930 380930 380930 380930 380930 59392
           380930 380930 380930 380930 380930 380930 380930 380930
           380930 380930 20740 71846 59392 59392 20740 20740 20740
           20740 20740 20740 36868 36868 36868 26624 28672 71846)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           36868 36868 36868 26624 28672 59392 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 59392
           59392 59392 38916 38916 38916 38916 38916 38916 38916 38916
           38916 38916 38916 38916 38916 38916 38916 38916 38916 38916
           38916 38916 38916 38916 38916 38916 38916 38916 38916 38916
           38916 38916 38916 38916)
         #(38916 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 482617350 482617350
           2369542 2369542 482617350 482617350 482617350 482617350
           2369542 2369542 2369542 482617350 482617350 276490 276490
           276490 276490 482617350 276490 276490 276490 2369542 2369542
           482617350 461645830 482617350 2369542 2369542 461645830
           461645830 461645830 461645830 482617350 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392)
         #(43012 43012 65684 43012 43012 43012 43012 65684 43012 43012
           67748 65684 65684 65684 67748 67748 65684 65684 65684 67748
           43012 65684 43012 43012 36868 65684 65684 65684 65684 65684
           43012 43012 43012 43012 44036 43012 65684 43012 65685 43012
           65684 43012 65685 65685 65684 65684 43012 67748 65684 65684
           65685 65684 67748 73860 73860 73860 73860 68772 43012 43012
           67748 67748 65684 65684)
         #(36868 36868 36868 36868 36868 65684 67748 67748 67748 67748
           43012 36868 43012 43012 67749 43012 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 84373 84373 84373 84373 84373 84373 84373 84373
           84373 84373 84373 84373 84373 84373 84373 84373 84389 84389
           84389 84389 84389 84389 84389 84389 84389 84389 84389 84389
           84389 84389 84389 84389)
         #(84356 84356 84356 65685 67749 84356 84356 84356 84356 20740
           43012 43012 59392 59392 59392 59392 36868 36868 36868 36868
           37892 44036 44036 44036 44036 44036 36868 36868 43012 43012
           43012 43012 36868 43012 43012 36868 43012 43012 36868 43012
           43012 44036 44036 43012 43012 43012 36868 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 36868 36868 43012 43012 36868 43012
           36868 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868)
         #3=#(36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
              36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
              36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
              36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
              36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
              36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
              36868 36868 36868 36868)
         #3# #3# #3#
         #(43012 43012 43012 43012 43012 43012 43012 43012 26624 28672
           26624 28672 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 44036 44036 43012 43012
           43012 43012 36868 36868 43012 43012 43012 43012 43012 43012
           44036 26624 28672 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           36868 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 44036 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 44036 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 36868 36868
           36868 36868 36868 36868 43012 43012 43012 43012 43012 43012
           43012 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 43012 43012 43012 43012 44036 44036 44036 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 108693 108693 108693 108693 108693
           108693 108693 108693 108693 108693)
         #(108693 108693 109717 108693 108693 108693 108693 108693
           108693 108693 108693 108693 108693 108693 108693 108693
           108709 108709 108709 108709 108709 108709 108709 108709
           108709 108709 108709 108709 108709 108709 108709 108709
           108709 108709 108709 108709 108709 108709 108709 108709
           108709 108709 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740)
         #4=#(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
              43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
              43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
              43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
              43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
              43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
              43012 43012 43012 43012)
         #4#
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 44036 44036 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 44036 36868 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(44036 36868 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 36868 36868 36868 37892
           37892 37892 37892 36868)
         #(44036 44036 44036 44036 44036 44036 43012 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 43012
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036)
         #(44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 37892 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036)
         #(44036 44036 44036 44036 44036 44036 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036)
         #5=#(44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
              44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
              44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
              44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
              44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
              44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
              44036 44036 44036 44036)
         #(44036 44036 44036 44036 44036 44036 43012 43012 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 43012
           44036 43012 44036 43012 43012 43012 43012 43012 43012 44036
           43012 43012 43012 44036 43012 43012 43012 43012 43012 43012
           44036 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 44036 44036 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 44036 43012 43012 44036 43012 43012
           43012 43012 44036 43012 44036 43012 43012 43012 43012 44036
           44036 44036 43012 44036 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 44036 44036 44036 44036 44036
           26624 28672 26624 28672 26624 28672 26624 28672 26624 28672
           26624 28672 26624 28672 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           43012 44036 44036 44036 43012 43012 43012 43012 43012 43012
           43012 43012 43012 44036 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 44036 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 44036)
         #(36868 36868 36868 36868 36868 26624 28672 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 26624 28672
           26624 28672 26624 28672 26624 28672 26624 28672 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868)
         #4# #4# #4# #4#
         #(36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 37892 37892 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868)
         #3#
         #(36868 36868 36868 26624 28672 26624 28672 26624 28672 26624
           28672 26624 28672 26624 28672 26624 28672 26624 28672 26624
           28672 26624 28672 26624 28672 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868)
         #(36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 26624 28672 26624 28672 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           26624 28672 36868 36868)
         #3# #3# #3# #3#
         #(43012 43012 43012 43012 43012 44036 44036 44036 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 44036 44036 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 36868 36868
           36868 36868 36868 36868 36868 36868 36868 36868 36868 36868
           36868 36868 36868 36868)
         #(36868 36868 36868 36868 36868 43012 43012 36868 36868 36868
           36868 36868 36868 43012 43012 43012 44036 43012 43012 43012
           43012 44036 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 59392 59392 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 59392 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #4# #0#
         #(67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 65685 67749 65685 65685 65685 67749 67749 65685
           67749 65685 67749 65685 67749 65685 65685 65685 65685 67748
           65685 67749 67748 65685 67749 67748 67748 67748 67748 67748
           71846 71846 65685 65685)
         #2#
         #(65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 67748 43012 43012 43012
           43012 43012 43012 65685 67749 65685 67749 482617350
           482617350 482617350 65685 67749 59392 59392 59392 59392
           59392 34820 34820 34820 34820 20740 34820 34820)
         #(67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 59392 67749
           59392 59392 59392 59392 59392 67749 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           59392 59392 59392 59392 59392 59392 59392 71814 34820 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 19146758)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 59392 59392 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 59392
           73860 73860 73860 73860 73860 73860 73860 59392 73860 73860
           73860 73860 73860 73860 73860 59392 73860 73860 73860 73860
           73860 73860 73860 59392)
         #(73860 73860 73860 73860 73860 73860 73860 59392 73860 73860
           73860 73860 73860 73860 73860 59392 73860 73860 73860 73860
           73860 73860 73860 59392 73860 73860 73860 73860 73860 73860
           73860 59392 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478)
         #(34820 34820 30720 32768 30720 32768 34820 34820 34820 30720
           32768 34820 30720 32768 34820 34820 34820 34820 34820 34820
           34820 34820 34820 24580 34820 34820 24580 34820 30720 32768
           34820 34820 30720 32768 26624 28672 26624 28672 26624 28672
           26624 28672 34820 34820 34820 34820 34820 71814 34820 34820
           34820 34820 34820 34820 34820 34820 34820 34820 24580 24580
           34820 34820 34820 34820)
         #(24580 34820 26624 34820 34820 34820 34820 34820 34820 34820
           34820 34820 34820 34820 34820 34820 43012 43012 34820 34820
           34820 26624 28672 26624 28672 26624 28672 26624 28672 24580
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 59392 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #4# #4# #4#
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           59392 59392 59392 59392))
       #(#(1225216 34820 34820 34820 43012 71814 8324 18820 26624 28672
           26624 28672 26624 28672 26624 28672 26624 28672 43012 43012
           26624 28672 26624 28672 26624 28672 26624 28672 24580 26624
           28672 28672 43012 18820 18820 18820 18820 18820 18820 18820
           18820 18820 457451526 478423046 486811654 465840134
           470036488 470036488 25604 202886 202886 202886 202886 202886
           43012 43012 18820 18820 18820 71814 73860 35844 43012 43012)
         #(59392 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 59392
           59392 17049606 17049606 237574 237574 6278 6278 8324 221188
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932)
         #(204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 34820 202886 202886 202886 204932)
         #(59392 59392 59392 59392 59392 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 59392 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 59392 43012 43012 20740 20740
           20740 20740 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 59392 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 20740 20740
           20740 20740 20740 20740 20740 20740 43012 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 44036 43012 44036 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 43012)
         #(239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620)
         #(239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           239620 239620 239620 239620 239620 239620 239620 239620
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012)
         #4# #4#
         #6=#(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
              8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
              8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
              8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
              8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
              8324 8324 8324 8324)
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6#)
       #(#6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #4# #6# #6# #6# #6#
         #6# #6# #6# #6#)
       #7=#(#6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
            #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
            #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
            #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
            #6# #6# #6# #6#)
       #7# #7# #7# #7#
       #(#(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 71814 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
         #1# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 59392 59392 59392 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 59392 59392 59392
           59392 59392 59392 59392 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 71814 71814 71814 71814
           71814 71814 34820 34820)
         #1# #1# #1# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 71814 34820 34820 34820 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 73860 73860 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392)
         #(65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 73860 482617350 276490
           276490 276490 34820 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617350 482617350
           34820 71814)
         #(65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 71846 71846
           482617478 482617478 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 482617350
           482617350 34820 34820 34820 34820 34820 34820 59392 59392
           59392 59392 59392 59392 59392 59392)
         #(40966 40966 40966 40966 40966 40966 40966 40966 106502
           106502 106502 106502 106502 106502 106502 106502 106502
           106502 106502 106502 106502 106502 106502 71814 71814 71814
           71814 71814 71814 71814 71814 71814 106502 106502 65685
           67749 65685 67749 65685 67749 65685 67749 65685 67749 65685
           67749 65685 67749 67748 67748 65685 67749 65685 67749 65685
           67749 65685 67749 65685 67749 65685 67749 65685 67749)
         #(65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 71846 67748
           67748 67748 67748 67748 67748 67748 67748 65685 67749 65685
           67749 65685 65685 67749)
         #(65685 67749 65685 67749 65685 67749 65685 67749 71814 106502
           106502 65685 67749 65685 67748 73860 65685 67749 65685 67749
           67749 67748 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 65685 65685 65685 65685 67748 65685 65685
           65685 65685 65685 67749 65685 67749 65685 67749 65685 67749
           65685 67749 65685 67749)
         #(65685 67749 65685 67749 65685 65685 65685 65685 67749 65685
           67749 59392 59392 59392 59392 59392 65685 67749 59392 67748
           59392 67748 65685 67749 65685 67749 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           71814 71814 71814 65685 67749 73860 71846 71846 67748 73860
           73860 73860 73860 73860)
         #(73860 73860 272518 73860 73860 73860 19146758 73860 73860
           73860 73860 272518 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 274568 274568 272518
           272518 274568 43012 43012 43012 43012 19146758 59392 59392
           59392 20740 20740 20740 20740 20740 20740 43012 43012 38916
           43012 59392 59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 34820 34820 34820 34820 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(274568 274568 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 274568 274568 274568 274568 274568 274568
           274568 274568 274568 274568 274568 274568)
         #(274568 274568 274568 274568 19146758 272518 59392 59392
           59392 59392 59392 59392 59392 59392 34820 34820 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 59392 59392 59392 59392 59392 59392 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 482617350 482617350 482617350 73860
           73860 73860 73860 73860 73860 34820 34820 34820 73860 34820
           73860 73860 272518)
         #(147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 272518 272518 272518 272518 272518 461645830 461645830
           461645830 34820 34820 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 272518 272518
           272518 272518 272518 272518 272518 272518 272518 272518
           272518 274568 19148808 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 34820 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 59392 59392 59392)
         #(272518 272518 272518 274568 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 14952454 274568 274568 272518 272518 272518
           272518 274568 274568 272518 272518 274568 274568)
         #(19148808 34820 34820 34820 34820 34820 34820 34820 34820
           34820 34820 34820 34820 34820 59392 71814 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           59392 59392 59392 59392 34820 34820 8324 8324 8324 8324 8324
           272518 6278 8324 8324 8324 8324 8324 8324 8324 8324 8324
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 8324 8324 8324 8324 8324 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 272518 272518 272518 272518 272518 272518 274568
           274568 272518 272518 274568 274568 272518 272518 59392 59392
           59392 59392 59392 59392 59392 59392 59392)
         #(73860 73860 73860 272518 73860 73860 73860 73860 73860 73860
           73860 73860 272518 274568 59392 59392 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 59392 59392
           34820 34820 34820 34820 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 6278 8324 8324
           8324 8324 8324 8324 43012 43012 43012 8324 274568 272518
           274568 8324 8324)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           482617478 8324 482617478 482617478 461645958 8324 8324
           482617478 482617478 8324 8324 8324 8324 8324 482617478
           482617350)
         #(8324 482617350 8324 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 8324 8324
           6278 34820 34820 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 274568 272518 272518 274568 274568
           34820 34820 73860 71814 71814 274568 19146758 59392 59392
           59392 59392 59392 59392 59392 59392 59392)
         #(59392 73860 73860 73860 73860 73860 73860 59392 59392 73860
           73860 73860 73860 73860 73860 59392 59392 73860 73860 73860
           73860 73860 73860 59392 59392 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 59392
           73860 73860 73860 73860 73860 73860 73860 59392 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748)
         #(67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67749
           67748 67748 67748 67748 67748 67748 67748 106502 71846 71846
           71846 71846 67748 67748 67748 67748 67748 67748 67748 67748
           67748 71814 40966 40966 59392 59392 59392 59392 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749)
         #(67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 274568 274568 272518 274568
           274568 272518 274568 274568 34820 274440 19146758 59392
           59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 59392 59392 59392 59392 59392 59392)
         #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
         #1#)
       #8=#(#1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
            #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
            #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
            #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
            #1# #1# #1# #1#)
       #8#
       #(#1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
         #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 59392 59392 59392
           59392 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           59392 59392 59392 59392)
         #9=#(55296 55296 55296 55296 55296 55296 55296 55296 55296 55296
              55296 55296 55296 55296 55296 55296 55296 55296 55296 55296
              55296 55296 55296 55296 55296 55296 55296 55296 55296 55296
              55296 55296 55296 55296 55296 55296 55296 55296 55296 55296
              55296 55296 55296 55296 55296 55296 55296 55296 55296 55296
              55296 55296 55296 55296 55296 55296 55296 55296 55296 55296
              55296 55296 55296 55296)
         #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9#
         #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9#
         #9#)
       #10=#(#11=#(57348 57348 57348 57348 57348 57348 57348 57348 57348
                   57348 57348 57348 57348 57348 57348 57348 57348 57348
                   57348 57348 57348 57348 57348 57348 57348 57348 57348
                   57348 57348 57348 57348 57348 57348 57348 57348 57348
                   57348 57348 57348 57348 57348 57348 57348 57348 57348
                   57348 57348 57348 57348 57348 57348 57348 57348 57348
                   57348 57348 57348 57348 57348 57348 57348 57348 57348
                   57348)
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11#)
       #(#11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8580 8324 8324 8324 8324
           8324 8324 8324 8580 8324 8324 8324 8324 8580 8324 8324 8324
           8324 8324 8324 8324)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8580 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8580 8324 8580 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8580 8324 8324)
         #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 59392
           59392 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324)
         #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #(67748 67748 67748 67748 67748 67748 67748 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 67748
           67748 67748 67748 67748 59392 59392 59392 59392 59392 991364
           54798470 991364 991364 991364 991364 991364 991364 991364
           991364 991364 991364 36868 991364 991364 991364 991364
           991364 991364 991364 991364 991364 991364 991364 991364
           991364 59392 991364 991364 991364 991364 991364 59392 991364
           59392)
         #(991364 991364 59392 991364 991364 59392 991364 991364 991364
           991364 991364 991364 991364 991364 991364 991364 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           40966 40966 40966 40966 40966 40966 40966 40966 40966 40966
           40966 40966 40966 40966)
         #(40966 40966 40966 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #1# #1# #1# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 28672 26624)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 59392 59392
           59392 59392 59392 59392 59392 43012 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           38916 43012 43012 43012)
         #(272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           428036 34820 34820 493574 428036 34820 34820 26624 28672
           34820 59392 59392 59392 59392 59392 59392 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           461645830 461645830 461645830 461645830 461645830 461645830
           461645830 482617350 482617350 34820 24580 24580 612356
           612356 26624 28672 26624 28672 26624 28672 26624 28672 26624
           28672 26624)
         #(28672 26624 28672 26624 28672 34820 34820 26624 28672 34820
           34820 34820 34820 612356 612356 612356 428036 34820 559110
           59392 428036 493574 34820 34820 24580 26624 28672 26624
           28672 26624 28672 34820 34820 34820 36868 24580 36868 36868
           36868 59392 34820 38916 34820 34820 59392 59392 59392 59392
           73860 73860 73860 73860 73860 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860)
         #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 59392 380930)
         #(59392 34820 34820 34820 38916 34820 34820 559110 26624 28672
           34820 36868 428036 24580 559110 34820 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 493574
           428036 36868 36868 36868 34820 34820 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 26624 34820 28672 40966 612356)
         #(40966 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 26624 36868 28672
           36868 26624 28672 34820 26624 28672 34820 34820 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 202886 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932)
         #(204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 204932 204932
           204932 204932 204932 204932 204932 204932 268422 268422
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392)
         #(59392 59392 73860 73860 73860 73860 73860 73860 59392 59392
           73860 73860 73860 73860 73860 73860 59392 59392 73860 73860
           73860 73860 73860 73860 59392 59392 73860 73860 73860 59392
           59392 59392 38916 38916 36868 40966 43012 38916 38916 59392
           43012 36868 36868 36868 36868 43012 43012 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 380930 380930
           380930 43012 43012 59392 59392))
       #(#(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           73860 73860 59392 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           59392 59392 59392 59392)
         #(34820 34820 34820 59392 59392 59392 59392 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 59392 59392 59392 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 20740 20740 20740 20740 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           20740 20740 43012 43012 43012 59392 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 59392
           59392 59392 43012 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 461645830 59392 59392)
         #12=#(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
               59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
               59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
               59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
               59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
               59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
               59392 59392 59392 59392)
         #12#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 461645830 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 20740 20740 20740 20740 59392 59392 59392 59392
           59392 59392 59392 59392 59392 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 84356 73860 73860 73860 73860 73860 73860 73860 73860
           84356 59392 59392 59392 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 482617478 482617478 482617478
           482617478 482617478 59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           59392 34820 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 59392 59392 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 34820 84356 84356 84356
           84356 84356 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749)
         #(67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           59392 59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 59392 59392 59392 59392 59392 59392
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685)
         #(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           59392 59392 59392 59392 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           59392 59392 59392 59392 59392 59392 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 34820 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 59392
           65685 65685 65685 65685)
         #(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 59392 65685 65685 65685 65685 65685 65685 65685 59392
           65685 65685 59392 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 59392 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           59392 67749 67749 67749 67749 67749 67749 67749 59392 67749
           67749 59392 59392 59392)
         #12# #1# #1# #1# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(71846 71814 71814 71846 71846 71846 59392 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 71846
           71846 71846 71846 71846 71846 71846 71846 71846 71846 59392
           71846 71846 71846 71846 71846 71846 71846 71846 71846 59392
           59392 59392 59392 59392)
         #12#
         #(73860 73860 73860 73860 73860 73860 59392 59392 73860 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 59392 73860 73860 59392 59392 59392
           73860 59392 59392 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 34820 20740 20740 20740 20740 20740 20740
           20740 20740 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 43012 43012 20740 20740 20740
           20740 20740 20740 20740)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 59392 59392 59392 59392 59392 59392 59392 20740
           20740 20740 20740 20740 20740 20740 20740 20740 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 73860 73860 59392 59392 59392 59392 59392 20740
           20740 20740 20740 20740)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 20740 20740 20740 20740 20740 20740 59392 59392
           59392 34820 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 59392 59392
           59392 59392 59392 34820)
         #12#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 59392 59392 59392 59392
           20740 20740 73860 73860)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 59392 59392 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740)
         #(73860 272518 272518 272518 59392 272518 272518 59392 59392
           59392 59392 59392 272518 461645958 272518 482617478 73860
           73860 73860 73860 59392 73860 73860 73860 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 59392 59392
           482617350 2369542 461645830 59392 59392 59392 59392
           19146758)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 59392
           59392 59392 59392 59392 59392 59392 34820 34820 34820 34820
           34820 34820 34820 34820 34820 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 20740 20740 34820)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 20740
           20740 20740 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 43012 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 482617350
           461645830 59392 59392 59392 59392 20740 20740 20740 20740
           20740 34820 34820 34820 34820 34820 34820 34820 59392 59392
           59392 59392 59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 59392 59392 59392 34820 34820 34820
           34820 34820 34820 34820)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 59392 20740 20740 20740 20740 20740 20740
           20740 20740 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 59392 59392 59392 59392 20740 20740 20740 20740
           20740 20740 20740 20740)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 59392 59392
           59392 59392 59392 59392 59392 34820 34820 34820 34820 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 20740 20740 20740 20740 20740 20740 20740 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 59392 59392 59392 59392 59392 59392 59392 20740 20740
           20740 20740 20740 20740)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 482617478 482617478
           482617478 482617478 59392 59392 59392 59392 59392 59392
           59392 59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 59392 59392 59392 59392 59392 59392)
         #12# #12# #12# #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 482617478 482617478 24580 59392 59392
           73860 73860 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392)
         #12#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 73860
           59392 59392 59392 59392 59392 59392 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 461645830 461645830
           482617350 482617350 482617350 461645830 482617350 461645830
           461645830 461645830 461645830 20740 20740 20740 20740 34820
           34820 34820 34820 34820 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860)
         #(73860 73860 482617350 461645830 482617350 461645830 34820
           34820 34820 34820 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 20740 20740 20740 20740 20740
           20740 20740 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 59392 59392 59392 59392 59392
           59392 59392 59392 59392))
       #(#(274568 272518 274568 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 272518 272518
           272518 272518 272518 272518 272518 272518)
         #(272518 272518 272518 272518 272518 272518 19146758 34820
           34820 34820 34820 34820 34820 34820 59392 59392 59392 59392
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 19146758 73860 73860 272518 272518 73860 59392
           59392 59392 59392 59392 59392 59392 59392 59392 19146758)
         #(272390 272390 274568 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 274568
           274568 274568 272518 272518 272518 272518 274568 274568
           19146758 14952454 34820 34820 380930 34820 34820)
         #(34820 34820 272518 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 380930 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 59392 59392 59392 59392 59392 59392 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 59392 59392 59392 59392 59392 59392)
         #(482617478 482617478 482617478 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 272518 272518 272518 272518 272518 274568 272518
           272518 272518 272518 272518 272518 19146758 19146758 59392
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720)
         #(34820 34820 34820 34820 73860 274568 274568 73860 59392
           59392 59392 59392 59392 59392 59392 59392 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 14952454 34820 34820 73860 59392 59392 59392
           59392 59392 59392 59392 59392 59392)
         #(272518 272518 274568 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 274568 274568 274568 272518 272518 272518 272518
           272518 272518 272518 272518 272518 274568)
         #(19148808 73860 73860 73860 73860 34820 34820 34820 34820
           272390 14952454 272390 272390 34820 274568 272518 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 73860 34820 73860 34820 34820 34820 59392 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 59392 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 274568 274568 274568 272518 272518
           272518 274568 274568 272518 19148808 14952454 272518 34820
           34820 34820 34820 34820 34820 272518 59392)
         #12#
         #(73860 73860 73860 73860 73860 73860 73860 59392 73860 59392
           73860 73860 73860 73860 59392 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           59392 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 34820 59392 59392 59392 59392 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 272518 274568 274568 274568 272518 272518 272518
           272518 272518 272518 14952454 19146758 59392 59392 59392
           59392 59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 59392 59392 59392 59392 59392 59392)
         #(272518 272518 274568 274568 59392 73860 73860 73860 73860
           73860 73860 73860 73860 59392 59392 73860 73860 59392 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 73860 73860 73860 73860 73860 73860 73860
           59392 73860 73860 59392 73860 73860 73860 73860 73860 59392
           14952454 14952454 73860 274568 274568)
         #(272518 274568 274568 274568 274568 59392 59392 274568 274568
           59392 59392 274568 274568 19148808 59392 59392 73860 59392
           59392 59392 59392 59392 59392 274568 59392 59392 59392 59392
           59392 73860 73860 73860 73860 73860 274568 274568 59392
           59392 482617350 482617350 482617350 482617350 482617350
           482617350 482617350 59392 59392 59392 482617350 482617350
           482617350 482617350 482617350 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392)
         #12# #12#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 274568 274568 274568 272518 272518 272518
           272518 272518 272518 272518 272518)
         #(274568 274568 19146758 272518 272518 274568 14952454 73860
           73860 73860 73860 34820 34820 34820 34820 34820 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 34820 34820 59392 34820 482617350 73860 73860 73860
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 274568
           274568 274568 272518 272518 272518 272518 272518 272518
           274568 272518 274568 274568 274568 274568 272518)
         #(272518 274568 19146758 14952454 73860 73860 34820 73860
           59392 59392 59392 59392 59392 59392 59392 59392 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #12# #12#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 274568 274568
           274568 272518 272518 272518 272518 59392 59392 274568 274568
           274568 274568 272518 272518 274568 19146758)
         #(14952454 34820 34820 34820 34820 34820 34820 34820 34820
           34820 34820 34820 34820 34820 34820 34820 34820 34820 34820
           34820 34820 34820 34820 34820 73860 73860 73860 73860 272518
           272518 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 274568
           274568 274568 272518 272518 272518 272518 272518 272518
           272518 272518 274568 274568 272518 274568 19146758)
         #(272518 34820 34820 34820 73860 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 59392 59392
           59392 59392 59392 59392 34820 34820 34820 34820 34820 34820
           34820 34820 34820 34820 34820 34820 34820 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 272518 274568 272518 274568 274568 272518
           272518 272518 272518 272518 272518 19148808 14952454 73860
           34820 59392 59392 59392 59392 59392 59392)
         #(147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 59392 59392 272518 272518 272518 274568
           274568 272518 272518 272518 272518 274568 272518 272518
           272518 272518 19146758 59392 59392 59392 59392 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           20740 20740 34820 34820 34820 43012)
         #(8324 8324 8324 8324 8324 8324 8324 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392)
         #12# #12#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 274568 274568 274568 272518 272518
           272518 272518 272518 272518 272518 272518 272518 274568
           19146758 14952454 34820 59392 59392 59392 59392)
         #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685)
         #(67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 20740 20740 20740 20740 20740 20740
           20740 20740 20740 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 73860)
         #(73860 73860 73860 73860 73860 73860 73860 59392 59392 73860
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           59392 73860 73860 59392 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 274568
           274568 274568 274568 274568 274568 59392 274568 274568 59392
           59392 272518 272518 19148808 19146758 73860)
         #(274568 73860 274568 14952454 34820 34820 34820 59392 59392
           59392 59392 59392 59392 59392 59392 59392 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392)
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 274568 274568
           274568 272518 272518 272518 272518 59392 59392 272518 272518
           274568 274568 274568 274568 19146758 73860 34820 73860
           274568 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392)
         #(73860 272518 272518 272518 272518 272518 272518 272518
           272518 272518 272518 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 272390 19146758 272518 272518 272518
           272518 274568 73860 272518 272518 272518 272518 34820)
         #(34820 34820 34820 34820 34820 34820 34820 19146758 59392
           59392 59392 59392 59392 59392 59392 59392 73860 272518
           272518 272518 272518 272518 272518 274568 274568 272518
           272518 272518 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           272518 272518 272518 272518 272518 272518 272518 272518
           272518 272518 272518 272518 272518 274568 272390 19146758
           34820 34820 34820 73860 34820 34820 34820 34820 34820 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860)
         #13=#(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
               73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
               73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
               73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
               73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
               73860 73860 73860 73860 73860 73860 73860 59392 59392 59392
               59392 59392 59392 59392)
         #12# #12# #12# #12#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 274568 272518
           272518 272518 272518 272518 272518 272518 59392 272518
           272518 272518 272518 272518 272518 274568 19146758)
         #(73860 34820 34820 34820 34820 34820 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 59392 59392 59392
           34820 34820 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 59392 59392 272518
           272518 272518 272518 272518 272518 272518 272518 272518
           272518 272518 272518 272518 272518 272518 272518 272518
           272518 272518 272518 272518 272518 59392 274568 272518
           272518 272518 272518 272518 272518 272518 274568 272518
           272518 274568 272518 272518 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12#
         #(73860 73860 73860 73860 73860 73860 73860 59392 73860 73860
           59392 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 272518
           272518 272518 272518 272518 272518 59392 59392 59392 272518
           59392 272518 272518 59392 272518)
         #(272518 272518 14952454 272518 19146758 19146758 73860 272518
           59392 59392 59392 59392 59392 59392 59392 59392 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 59392 59392 59392 59392 59392 59392 73860 73860 73860
           73860 73860 73860 59392 73860 73860 59392 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           274568 274568 274568 274568 274568 59392 272518 272518 59392
           274568 274568 272518 274568 19146758 73860 59392 59392 59392
           59392 59392 59392 59392 147720 147720 147720 147720 147720
           147720 147720 147720 147720 147720 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392)
         #12# #12# #12# #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 272518 272518 274568 274568 34820 34820 59392 59392
           59392 59392 59392 59392 59392)
         #12# #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 73860 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 43012 43012 43012 43012 43012 43012 43012 43012 38916
           38916 38916 38916 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 34820))
       #(#1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12#
         #(84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356)
         #(84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 84356 84356 84356
           84356 84356 84356 84356 84356 84356 84356 59392 34820 34820
           34820 34820 34820 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #1# #1# #1#
         #(73860 73860 73860 73860 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 34820
           34820 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392))
       #(#1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
         #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 59392 380930
           380930 380930 380930 380930 380930 380930 380930 380930
           59392 59392 59392 59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#)
       #(#12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #1# #1# #1# #1# #1# #1# #1# #1# #1#
         #(73860 73860 73860 73860 73860 73860 73860 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12#)
       #14=#(#12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
             #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
             #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
             #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
             #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
             #12# #12# #12# #12#)
       #(#12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #1# #1# #1# #1# #1#
         #1# #1# #1# #13#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 59392 59392 59392 59392 34820 34820
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 59392)
         #(147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 59392 59392 59392 59392 59392 59392 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           59392 2369542 2369542 2369542 2369542 2369542 34820 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           34820 34820 34820 34820 34820 43012 43012 43012 43012)
         #(71814 71814 71814 71814 34820 43012 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 59392 20740
           20740 20740 20740 20740 20740 20740 59392 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 59392 59392
           59392 59392 59392 73860 73860 73860)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 34820 34820 34820 34820 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12# #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 59392 59392 59392 272518 73860 274568 274568
           274568 274568 274568 274568 274568 274568 274568 274568
           274568 274568 274568 274568 274568 274568 274568 274568
           274568 274568 274568 274568 274568 274568 274568 274568
           274568 274568 274568 274568 274568 274568 274568 274568
           274568 274568 274568 274568 274568 274568 274568 274568
           274568 274568 274568 274568 274568)
         #(274568 274568 274568 274568 274568 274568 274568 274568
           59392 59392 59392 59392 59392 59392 59392 272518 272518
           272518 272518 71814 71814 71814 71814 71814 71814 71814
           71814 71814 71814 71814 71814 71814 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392)
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 71814 71814 34820 71814 272390 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 12857480
           12857480 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392))
       #7#
       #(#6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 59392 59392 59392
           59392 59392 59392 59392 59392)
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392)
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#)
       #14#
       #(#12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 202886
           202886 202886 202886 59392 202886 202886 202886 202886
           202886 202886 202886 59392 202886 202886 59392))
       #(#(204932 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324)
         #6# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 204932 204932 204932
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 8324 8324 8324 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 204932 204932 204932
           204932 59392 59392 59392 59392 59392 59392 59392 59392 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324)
         #6# #6# #6# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #1#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 59392 59392 59392 59392 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 59392
           59392 59392 59392 59392 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 59392 59392 43012 272390
           2369670 34820 380930 380930 380930 380930 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12#)
       #(#12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #(272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 59392 59392 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390)
         #(272390 272390 272390 272390 272390 272390 272390 59392 59392
           59392 59392 59392 59392 59392 59392 59392 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012)
         #4#
         #(43012 43012 43012 43012 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392))
       #(#4# #4# #4#
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 59392
           59392 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 453259272
           453259272 2369542 2369542 2369542 43012 43012 43012
           474230792 453259272 453259272 453259272 453259272 453259272
           380930 380930 380930 380930 380930 380930 380930 380930
           461645830 461645830 461645830 461645830 461645830)
         #(461645830 461645830 461645830 43012 43012 482617350
           482617350 482617350 482617350 482617350 461645830 461645830
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           482617350 482617350 482617350 482617350 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #4#
         #(43012 43012 482617350 482617350 482617350 43012 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392)
         #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #4#
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 59392 59392 59392 59392 59392 59392 59392
           59392 59392 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 59392 59392 59392
           59392 59392 59392 59392)
         #12# #12#
         #(65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684)
         #(65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 67748 67748 67748 67748 67748 67748
           67748 59392 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684)
         #(65684 65684 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 65684 59392
           65684 65684 59392 59392 65684 59392 59392 65684 65684 59392
           59392 65684 65684 65684 65684 59392 65684 65684 65684 65684
           65684 65684 65684 65684 67748 67748 67748 67748 59392 67748
           59392 67748 67748 67748)
         #(67748 67748 67748 67748 59392 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748)
         #(67748 67748 67748 67748 65684 65684 59392 65684 65684 65684
           65684 59392 59392 65684 65684 65684 65684 65684 65684 65684
           65684 59392 65684 65684 65684 65684 65684 65684 65684 59392
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 65684 65684 59392 65684
           65684 65684 65684 59392)
         #(65684 65684 65684 65684 65684 59392 65684 59392 59392 59392
           65684 65684 65684 65684 65684 65684 65684 59392 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684)
         #(65684 65684 65684 65684 65684 65684 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 67748 67748
           67748 67748 67748 67748)
         #(67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748)
         #(67748 67748 67748 67748 67748 67748 67748 67748 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           65684 65684 65684 65684)
         #(65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684)
         #(65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 59392 59392
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684)
         #(65684 36868 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 36868 67748 67748
           67748 67748 67748 67748 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 36868
           67748 67748 67748 67748)
         #(67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 36868 67748 67748 67748 67748 67748 67748 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 36868 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748)
         #(67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 36868 67748 67748 67748 67748
           67748 67748 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 36868 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748)
         #(67748 67748 67748 67748 67748 67748 67748 67748 67748 36868
           67748 67748 67748 67748 67748 67748 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 65684 65684 65684 65684 65684 65684 65684 65684 65684
           65684 36868 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748)
         #(67748 67748 67748 36868 67748 67748 67748 67748 67748 67748
           65684 67748 59392 59392 147720 147720 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 147720 147720)
         #4# #4# #4# #4# #4# #4# #4# #4#
         #(272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 43012 43012
           43012 43012 272390 272390 272390 272390 272390)
         #(272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 43012 43012 43012 43012
           43012 43012 43012 43012 272390 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012)
         #(43012 43012 43012 43012 272390 43012 43012 34820 34820 34820
           34820 34820 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 272390 272390
           272390 272390 272390 59392 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12#
         #(67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           73860 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 67748 67748 67748 67748 67748 67748 67748 67748 67748
           67748 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12# #12# #12#)
       #(#(482617478 482617478 482617478 482617478 482617478 482617478
           482617478 59392 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 482617478 482617478
           482617478 59392 59392 482617478 482617478 482617478
           482617478 482617478 482617478 482617478 59392 482617478
           482617478 59392 482617478 482617478 482617478 482617478
           482617478 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392)
         #12# #12# #12#
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 59392 59392 59392 482617350
           482617350 482617350 482617350 482617350 482617350 482617350
           71814 71814 71814 71814 71814 71814 71814 59392 59392)
         #(147720 147720 147720 147720 147720 147720 147720 147720
           147720 147720 59392 59392 59392 59392 73860 43012 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392)
         #12# #12# #12# #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 482617350 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 482617350 482617350 482617350
           482617350 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 59392 59392 59392 59392 59392 38916)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 73860 73860 73860 73860 73860 73860 73860 59392
           73860 73860 73860 73860 59392 73860 73860 59392 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 59392)
         #1# #1# #1#
         #(73860 73860 73860 73860 73860 59392 59392 20740 20740 20740
           20740 20740 20740 20740 20740 20740 461645830 461645830
           461645830 461645830 461645830 461645830 461645830 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #(65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 65685 65685 65685 65685 65685 65685
           65685 65685 65685 65685 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749 67749 67749 67749 67749 67749 67749
           67749 67749 67749 67749)
         #(67749 67749 67749 67749 482617350 482617350 482617350
           482617478 482617350 482617350 14952454 71814 59392 59392
           59392 59392 147720 147720 147720 147720 147720 147720 147720
           147720 147720 147720 59392 59392 59392 59392 34820 34820
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 43012 20740 20740 20740 38916 20740
           20740 20740 20740 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12#
         #(59392 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 20740 20740 20740 43012 20740 20740 20740
           20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 59392 59392)
         #12# #12# #12#
         #(73860 73860 73860 73860 59392 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 59392 73860 73860 59392 73860 59392 59392 73860
           59392 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 59392 73860 73860 73860 73860 59392 73860 59392 73860
           59392 59392 59392 59392)
         #(59392 59392 73860 59392 59392 59392 59392 73860 59392 73860
           59392 73860 59392 73860 73860 73860 59392 73860 73860 59392
           73860 59392 59392 73860 59392 73860 59392 73860 59392 73860
           59392 73860 59392 73860 73860 59392 73860 59392 59392 73860
           73860 73860 73860 59392 73860 73860 73860 73860 73860 73860
           73860 59392 73860 73860 73860 73860 59392 73860 73860 73860
           73860 59392 73860 59392)
         #(73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           59392 73860 73860 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 59392 59392
           59392 59392 59392 73860 73860 73860 59392 73860 73860 73860
           73860 73860 59392 73860 73860 73860 73860 73860 73860 73860
           73860 73860 73860 73860 73860 73860 73860 73860 73860 73860
           59392 59392 59392 59392)
         #(59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 36868 36868
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392)
         #12# #12# #12# #12#)
       #(#(44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 60416 60416 60416 60416 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036)
         #5#
         #(44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 60416 60416 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036)
         #(60416 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 60416 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416)
         #(20740 20740 20740 20740 20740 20740 20740 20740 20740 20740
           20740 20740 20740 44036 44036 44036 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 44036 108692
           108692 108692 108692 108692 108692 108692 108692 108692
           108692 108692 108692 108692 108692 108692 108692)
         #(108692 108692 108692 108692 108692 108692 108692 108692
           108692 108692 43012 43012 43012 43012 43012 43012 108692
           108692 108692 108692 108692 108692 108692 108692 108692
           108692 108692 108692 108692 108692 108692 108692 108692
           108692 108692 108692 108692 108692 108692 108692 108692
           108692 43012 43012 44036 44036 44036 44036 109716 109716
           108692 108692 108692 108692 108692 108692 108692 108692
           108692 108692 108692 108692 109716 109716)
         #(108692 108692 108692 108692 108692 108692 108692 108692
           108692 108692 43012 43012 43012 43012 44036 43012 43012
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 44036 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416)
         #(60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 1091588
           1091588 1091588 1091588 1091588 1091588 1091588 1091588
           1091588 1091588 1091588 1091588 1091588 1091588 1091588
           1091588 1091588 1091588 1091588 1091588 1091588 1091588
           1091588 1091588 1091588 1091588)
         #(43012 44036 44036 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 44036 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 44036 43012 43012
           44036 44036 44036 44036 44036 44036 44036 44036 44036 43012
           60416 60416 60416 60416)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 60416
           60416 60416 60416 60416 60416 60416 44036 44036 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 44036 44036 44036 44036 44036 44036 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416)
         #15=#(60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
               60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
               60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
               60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
               60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
               60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
               60416 60416 60416 60416)
         #15# #5# #5# #5#
         #(44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 303110
           303110 303110 303110 303110)
         #5# #5# #5# #5#
         #(44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 43012 43012)
         #(43012 43012 43012 43012 43012 43012 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036)
         #5# #5# #5#
         #(44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #5#
         #(44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 60416 60416 60416 60416 60416 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 60416 60416 60416 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 60416 60416 60416)
         #4#
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416)
         #4#
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 44036 44036 44036 44036 60416 60416 60416 60416 60416
           60416 60416 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 60416 60416 60416 60416 44036 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 60416 60416 60416 60416 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 60416 60416
           60416 60416 60416 60416 60416 60416 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 60416 60416 60416 60416
           60416 60416 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 60416 60416
           60416 60416 60416 60416 60416 60416 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 60416 60416 44036 44036
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416)
         #15#
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 43012
           44036 44036 44036 44036)
         #(44036 44036 44036 44036 44036 44036 43012 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036)
         #5# #5# #5#
         #(44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 60416 60416 44036 44036
           44036 44036 44036 60416 60416 60416 44036 44036 44036 44036
           44036 60416 60416 60416)
         #(44036 44036 44036 44036 44036 44036 44036 60416 60416 60416
           60416 60416 60416 60416 60416 60416 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 44036
           44036 44036 44036 44036 44036 60416 60416 60416 44036 44036
           44036 44036 44036 44036 44036 44036 44036 44036 44036 60416
           60416 60416 60416 60416)
         #(44036 44036 44036 44036 44036 44036 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 44036 44036 44036 44036
           44036 44036 44036 44036 44036 44036 60416 60416 60416 60416
           60416 60416 44036 44036 44036 44036 44036 44036 44036 44036
           60416 60416 60416 60416 60416 60416 60416 60416 44036 44036
           44036 44036 44036 44036 44036 60416 60416 60416 60416 60416
           60416 60416 60416 60416)
         #4# #4#
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 59392
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 43012 43012 43012)
         #(43012 43012 43012 43012 43012 43012 43012 43012 43012 43012
           43012 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 147720
           147720 147720 147720 147720 147720 147720 147720 147720
           147720 59392 59392 59392 59392 59392 59392)
         #15# #15# #15# #15# #15# #15# #15# #15# #15# #15# #15# #15#
         #15# #15# #15#
         #(60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 60416 60416 60416 60416 60416 60416 60416 60416
           60416 60416 59392 59392))
       #7# #7# #7# #7# #7# #7# #7# #7# #7# #7#
       #(#6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6#)
       #(#6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 59392 59392
           59392 59392 59392 59392 59392)
         #6# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 59392 59392 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324)
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6#)
       #(#6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324)
         #6# #6# #6# #6# #6#)
       #7#
       #(#6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12#)
       #(#12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8580 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324)
         #6# #6# #6# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324
           8324 8324 8324 8324 8324 8324 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#)
       #7#
       #(#6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
         #(8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 8324 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12#)
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #14# #14# #14#
       #(#(59392 380930 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394
           315394)
         #(315394 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394
           315394 315394 315394 315394 315394 315394 315394 315394)
         #12# #12#
         #16=#(272390 272390 272390 272390 272390 272390 272390 272390
               272390 272390 272390 272390 272390 272390 272390 272390
               272390 272390 272390 272390 272390 272390 272390 272390
               272390 272390 272390 272390 272390 272390 272390 272390
               272390 272390 272390 272390 272390 272390 272390 272390
               272390 272390 272390 272390 272390 272390 272390 272390
               272390 272390 272390 272390 272390 272390 272390 272390
               272390 272390 272390 272390 272390 272390 272390 272390)
         #16# #16#
         #(272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           272390 272390 272390 272390 272390 272390 272390 272390
           59392 59392 59392 59392 59392 59392 59392 59392 59392 59392
           59392 59392 59392 59392 59392 59392)
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12# #12#
         #12# #12# #12# #12# #12# #12# #12# #12#)
       #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14# #14#
       #14# #14# #14# #10# #10# #10# #10# #10# #10# #10# #10# #10#
       #10# #10# #10# #10# #10# #10#
       #17=#(#11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11#
             #(57348 57348 57348 57348 57348 57348 57348 57348 57348 57348
               57348 57348 57348 57348 57348 57348 57348 57348 57348 57348
               57348 57348 57348 57348 57348 57348 57348 57348 57348 57348
               57348 57348 57348 57348 57348 57348 57348 57348 57348 57348
               57348 57348 57348 57348 57348 57348 57348 57348 57348 57348
               57348 57348 57348 57348 57348 57348 57348 57348 57348 57348
               57348 57348 59392 59392))
       #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
       #10# #10# #10# #17#))
  (define unicode-category-names
    '#(Lu Ll Lt Lm Lo Mn Mc Me Nd Nl No Pc Pd Ps Pe Pi Pf Po Sm
       Sc Sk So Zs Zl Zp Cc Cf Cs Co Cn))
  (define table-ref
    (lambda (tbl i)
      (let ([#18=#{g3 nkuz0m2xhb8ttwxglejer90pq-4} (* 64 64)])
        (let ([#19=#{g4 nkuz0m2xhb8ttwxglejer90pq-5} (* 64)])
          (vector-ref
            (vector-ref
              (vector-ref tbl (fxdiv i #18#))
              (fxdiv (fxmod i #18#) #19#))
            (fxmod (fxmod i #18#) #19#))))))
  (define (getprop n) (table-ref unicode-category-table n))
  (define $char-constituent?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 4)))
  (define $char-subsequent?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 8)))
  (define $char-upper-case?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 16)))
  (define $char-lower-case?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 32)))
  (define $char-title-case?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 64)))
  (define $char-alphabetic?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 128)))
  (define $char-numeric?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 256)))
  (define $char-whitespace?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 512)))
  (define $char-extended-pictographic?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 1024)))
  (define $char-cased?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 1)))
  (define $char-case-ignorable?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 2)))
  (define (wb prop)
    (lambda (c)
      (fx= (fxand (fxsrl (getprop (char->integer c)) 16) 31)
           prop)))
  (define $wb-aletter? (wb 1))
  (define $wb-numeric? (wb 2))
  (define $wb-katakana? (wb 3))
  (define $wb-extend? (wb 4))
  (define $wb-format? (wb 5))
  (define $wb-midnum? (wb 6))
  (define $wb-midletter? (wb 7))
  (define $wb-midnumlet? (wb 8))
  (define $wb-extendnumlet? (wb 9))
  (define $wb-hebrew-letter? (wb 15))
  (define $wb-double-quote? (wb 13))
  (define $wb-single-quote? (wb 14))
  (define $wb-regional-indicator? (wb 16))
  (define $wb-zwj? (wb 17))
  (define $wb-wsegspace? (wb 18))
  (define $char-combining-class
    (lambda (c)
      (fxand (fxsrl (getprop (char->integer c)) 21) 255)))
  (define $char-category
    (lambda (c)
      (vector-ref
        unicode-category-names
        (fxand (fxsrl (getprop (char->integer c)) 11) 31))))
  (define $char-dump
    (lambda (c)
      (define (list-true . args) (remq #f args))
      (list-true (and ($char-constituent? c) 'constituent)
       (and ($char-subsequent? c) 'subsequent)
       (and ($char-upper-case? c) 'upper-case)
       (and ($char-lower-case? c) 'lower-case)
       (and ($char-title-case? c) 'title-case)
       (and ($char-alphabetic? c) 'alphabetic)
       (and ($char-numeric? c) 'whitespace)
       (and ($char-whitespace? c) 'whitespace)
       (and ($char-cased? c) 'cased)
       (and ($char-case-ignorable? c) 'case-ignorable)
       (and ($wb-aletter? c) 'aletter)
       (and ($wb-numeric? c) 'numeric)
       (and ($wb-katakana? c) 'katakana)
       (and ($wb-extend? c) 'extend) (and ($wb-format? c) 'format)
       (and ($wb-midnum? c) 'midnum)
       (and ($wb-midletter? c) 'midletter)
       (and ($wb-midnumlet? c) 'midnumlet)
       (and ($wb-extendnumlet? c) 'extendnumlet)
       (and ($wb-hebrew-letter? c) 'hebrew-letter)
       (and ($wb-double-quote? c) 'double-quote)
       (and ($wb-single-quote? c) 'single-quote)
       (and ($wb-regional-indicator? c) 'regional-indicator)
       (and ($wb-zwj? c) 'zwj) (and ($wb-wsegspace? c) 'wsegspace)
       `(combining-class ,($char-combining-class c))
       ($char-category c)))))
