% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_atomic_xml.R
\name{update_atomic_xml}
\alias{update_atomic_xml}
\title{Atomic updates with XML data}
\usage{
update_atomic_xml(conn, body, name, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{body}{(character) XML as a character string}

\item{name}{(character) Name of the core or collection}

\item{wt}{(character) One of json (default) or xml. If json, uses
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} to parse. If xml, uses \code{\link[xml2:read_xml]{xml2::read_xml()}} to parse}

\item{raw}{(logical) If \code{TRUE}, returns raw data in format specified by
\code{wt} param}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Atomic updates to parts of Solr documents
}
\examples{
\dontrun{
# start Solr in Cloud mode: bin/solr start -e cloud -noprompt

# connect
(conn <- SolrClient$new())

# create a collection
if (!conn$collection_exists("books")) {
  conn$collection_delete("books")
  conn$collection_create("books")
}

# Add documents
file <- system.file("examples", "books.xml", package = "solrium")
cat(readLines(file), sep = "\n")
conn$update_xml(file, "books")

# get a document
conn$get(ids = '978-0641723445', "books", wt = "xml")

# atomic update
body <- '
<add>
 <doc>
   <field name="id">978-0641723445</field>
   <field name="genre_s" update="set">mystery</field>
   <field name="pages_i" update="inc">1</field>
 </doc>
</add>'
conn$update_atomic_xml(body, name="books")

# get the document again
conn$get(ids = '978-0641723445', "books", wt = "xml")

# another atomic update
body <- '
<add>
 <doc>
   <field name="id">978-0641723445</field>
   <field name="price" update="remove">12.5</field>
 </doc>
</add>'
conn$update_atomic_xml(body, "books")

# get the document again
conn$get(ids = '978-0641723445', "books", wt = "xml")
}
}
\references{
https://lucene.apache.org/solr/guide/7_0/updating-parts-of-documents.html
}
