% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solr_stats.r
\name{solr_stats}
\alias{solr_stats}
\title{Solr stats}
\usage{
solr_stats(
  conn,
  name = NULL,
  params = list(q = "*:*", stats.field = NULL, stats.facet = NULL),
  body = NULL,
  callopts = list(),
  raw = FALSE,
  parsetype = "df",
  progress = NULL,
  ...
)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{Name of a collection or core. Or leave as \code{NULL} if
not needed.}

\item{params}{(list) a named list of parameters, results in a GET request
as long as no body parameters given}

\item{body}{(list) a named list of parameters, if given a POST request
will be performed}

\item{callopts}{Call options passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{raw}{(logical) If TRUE, returns raw data in format specified by
wt param}

\item{parsetype}{(character) One of 'list' or 'df'}

\item{progress}{a function with logic for printing a progress
bar for an HTTP request, ultimately passed down to \pkg{curl}. only supports
\code{httr::progress} for now. See the README for an example.}

\item{...}{Further args to be combined into query}
}
\value{
XML, JSON, a list, or data.frame
}
\description{
Returns only stat items
}
\section{Stats parameters}{

\itemize{
\item q Query terms, defaults to '\emph{:}', or everything.
\item stats.field The number of similar documents to return for each result.
\item stats.facet You can not facet on multi-valued fields.
\item wt (character) Data type returned, defaults to 'json'. One of json
or xml. If json, uses \code{\link[jsonlite]{fromJSON}} to parse. If xml,
uses \code{\link[XML]{xmlParse}} to parse. csv is only supported in
\code{\link{solr_search}} and \code{\link{solr_all}}.
\item start Record to start at, default to beginning.
\item rows Number of records to return. Defaults to 10.
\item key API key, if needed.
}
}

\examples{
\dontrun{
# connect
(cli <- SolrClient$new(host = "api.plos.org", path = "search", port = NULL))

# get stats
solr_stats(cli, params = list(q='science', stats.field='counter_total_all'),
  raw=TRUE)
solr_stats(cli, params = list(q='title:"ecology" AND body:"cell"',
   stats.field=c('counter_total_all','alm_twitterCount')))
solr_stats(cli, params = list(q='ecology',
  stats.field=c('counter_total_all','alm_twitterCount'),
  stats.facet='journal'))
solr_stats(cli, params = list(q='ecology',
  stats.field=c('counter_total_all','alm_twitterCount'),
  stats.facet=c('journal','volume')))

# Get raw data, then parse later if you feel like it
## json
out <- solr_stats(cli, params = list(q='ecology',
  stats.field=c('counter_total_all','alm_twitterCount'),
  stats.facet=c('journal','volume')), raw=TRUE)
library("jsonlite")
jsonlite::fromJSON(out)
solr_parse(out) # list
solr_parse(out, 'df') # data.frame

## xml
out <- solr_stats(cli, params = list(q='ecology',
  stats.field=c('counter_total_all','alm_twitterCount'),
  stats.facet=c('journal','volume'), wt="xml"), raw=TRUE)
library("xml2")
xml2::read_xml(unclass(out))
solr_parse(out) # list
solr_parse(out, 'df') # data.frame

# Get verbose http call information
solr_stats(cli, params = list(q='ecology', stats.field='alm_twitterCount'),
   callopts=list(verbose=TRUE))
}
}
\references{
See
https://lucene.apache.org/solr/guide/8_2/the-stats-component.html for
more information on Solr stats.
}
\seealso{
\code{\link[=solr_highlight]{solr_highlight()}}, \code{\link[=solr_facet]{solr_facet()}}, \code{\link[=solr_search]{solr_search()}}, \code{\link[=solr_mlt]{solr_mlt()}}
}
