% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{step_rename}
\alias{step_rename}
\title{Rename variables by name using dplyr}
\usage{
step_rename(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  inputs = NULL,
  skip = FALSE,
  id = rand_id("rename")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more unquoted expressions separated by commas. See
\code{\link[dplyr:rename]{dplyr::rename()}} where the convention is \strong{\code{new_name = old_name}}.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{inputs}{Quosure(s) of \code{...}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_rename()} creates a \emph{specification} of a recipe step that will add
variables using \code{\link[dplyr:rename]{dplyr::rename()}}.
}
\details{
When an object in the user's global environment is referenced in
the expression defining the new variable(s), it is a good idea to use
quasiquotation (e.g. \verb{!!}) to embed the value of the object in the
expression (to be portable between sessions).
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{value} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{value}{character, \code{rename} expression}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
recipe(~., data = iris) \%>\%
  step_rename(Sepal_Width = Sepal.Width) \%>\%
  prep() \%>\%
  bake(new_data = NULL) \%>\%
  slice(1:5)

vars <- c(var1 = "cyl", var2 = "am")
car_rec <-
  recipe(~., data = mtcars) \%>\%
  step_rename(!!!vars)

car_rec \%>\%
  prep() \%>\%
  bake(new_data = NULL)

car_rec \%>\%
  tidy(number = 1)
}
\seealso{
Other dplyr steps: 
\code{\link{step_arrange}()},
\code{\link{step_filter}()},
\code{\link{step_mutate}()},
\code{\link{step_mutate_at}()},
\code{\link{step_rename_at}()},
\code{\link{step_sample}()},
\code{\link{step_select}()},
\code{\link{step_slice}()}
}
\concept{dplyr steps}
