\name{chrobakPayneStraightLineDrawing}
\alias{chrobakPayneStraightLineDrawing}

\title{chrobakPayneStraightLineDrawing}

\description{chrobakPayneStraightLineDrawing description }

\usage{
chrobakPayneStraightLineDrawing(g) 
}

\arguments{
  \item{g}{ instance of class graphNEL from Bioconductor graph class}
}

\details{
M. Chrobak, T. Payne,
A Linear-time Algorithm for Drawing a Planar Graph on the Grid,
Information Processing Letters 54: 241-246, 1995.
}

\value{A matrix with rows 'x' and 'y', and columns corresponding
to graph nodes.  
}

\references{
Boost Graph Library ( www.boost.org/libs/graph/doc/index.html )

The Boost Graph Library: User Guide and Reference Manual;
by Jeremy G. Siek, Lie-Quan Lee, and Andrew Lumsdaine;
(Addison-Wesley, Pearson Education Inc., 2002), xxiv+321pp.
ISBN 0-201-72914-8
}

\author{ Li Long <li.long@isb-sib.ch> }

\examples{
V <- LETTERS[1:7]
g <- new("graphNEL", nodes=V, edgemode="undirected")
g <- addEdge(V[1+0], V[1+1], g)
g <- addEdge(V[1+1], V[2+1], g)
g <- addEdge(V[1+2], V[3+1], g)
g <- addEdge(V[1+3], V[0+1], g)
g <- addEdge(V[1+3], V[4+1], g)
g <- addEdge(V[1+4], V[5+1], g)
g <- addEdge(V[1+5], V[6+1], g)
g <- addEdge(V[1+6], V[3+1], g)
g <- addEdge(V[1+0], V[4+1], g)
g <- addEdge(V[1+1], V[3+1], g)
g <- addEdge(V[1+3], V[5+1], g)
g <- addEdge(V[1+2], V[6+1], g)
g <- addEdge(V[1+1], V[4+1], g)
g <- addEdge(V[1+1], V[5+1], g)
g <- addEdge(V[1+1], V[6+1], g)

x3 <- chrobakPayneStraightLineDrawing(g)
x3
plot(t(x3))
el = edgeL(g)
for (i in seq_len(length(nodes(g)))) 
  segments(
   rep(x3["x",i], length(el[[i]]$edges)), 
   rep(x3["y",i], length(el[[i]]$edges)), 
   x3["x", nodes(g)[el[[i]]$edges]],
   x3["y", nodes(g)[el[[i]]$edges]]
  )
}

\keyword{ graphs }

