# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AgeUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible units for a person's age."""

    YEARS = "years"
    MONTHS = "months"
    DAYS = "days"


class ClinicalDocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the clinical document."""

    CONSULTATION = "consultation"
    DISCHARGE_SUMMARY = "dischargeSummary"
    HISTORY_AND_PHYSICAL = "historyAndPhysical"
    PROCEDURE = "procedure"
    PROGRESS = "progress"
    IMAGING = "imaging"
    LABORATORY = "laboratory"
    PATHOLOGY = "pathology"


class ClinicalTrialAcceptedSex(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible values for the Sex eligibility criterion as accepted by clinical trials, which
    indicates the sex of people who may participate in a clinical study.
    """

    ALL = "all"
    FEMALE = "female"
    MALE = "male"


class ClinicalTrialPhase(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible phases of a clinical trial."""

    NOT_APPLICABLE = "notApplicable"
    EARLY_PHASE1 = "earlyPhase1"
    PHASE1 = "phase1"
    PHASE2 = "phase2"
    PHASE3 = "phase3"
    PHASE4 = "phase4"


class ClinicalTrialPurpose(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible purposes of a clinical trial."""

    NOT_APPLICABLE = "notApplicable"
    SCREENING = "screening"
    DIAGNOSTIC = "diagnostic"
    PREVENTION = "prevention"
    HEALTH_SERVICES_RESEARCH = "healthServicesResearch"
    TREATMENT = "treatment"
    DEVICE_FEASIBILITY = "deviceFeasibility"
    SUPPORTIVE_CARE = "supportiveCare"
    BASIC_SCIENCE = "basicScience"
    OTHER = "other"


class ClinicalTrialRecruitmentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible recruitment status of a clinical trial."""

    UNKNOWN_STATUS = "unknownStatus"
    NOT_YET_RECRUITING = "notYetRecruiting"
    RECRUITING = "recruiting"
    ENROLLING_BY_INVITATION = "enrollingByInvitation"


class ClinicalTrialSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible sources of a clinical trial."""

    CUSTOM = "custom"
    CLINICALTRIALS_GOV = "clinicaltrials.gov"


class ClinicalTrialStudyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible study types of a clinical trial."""

    INTERVENTIONAL = "interventional"
    OBSERVATIONAL = "observational"
    EXPANDED_ACCESS = "expandedAccess"
    PATIENT_REGISTRIES = "patientRegistries"


class DocumentContentSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the content's source.
    In case the source type is 'inline', the content is given as a string (for instance, text).
    In case the source type is 'reference', the content is given as a URI.
    """

    INLINE = "inline"
    REFERENCE = "reference"


class DocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the patient document, such as 'note' (text document) or 'fhirBundle' (FHIR JSON
    document).
    """

    NOTE = "note"
    FHIR_BUNDLE = "fhirBundle"
    DICOM = "dicom"
    GENOMIC_SEQUENCING = "genomicSequencing"


class GeoJsonGeometryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """``GeoJSON`` geometry type."""

    POINT = "Point"


class GeoJsonPropertiesSubType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """``GeoJSON`` object sub-type."""

    CIRCLE = "Circle"


class GeoJsonType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """``GeoJSON`` type."""

    FEATURE = "Feature"


class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the processing job."""

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    PARTIALLY_COMPLETED = "partiallyCompleted"


class PatientInfoSex(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The patient's sex."""

    FEMALE = "female"
    MALE = "male"
    UNSPECIFIED = "unspecified"


class RepeatabilityResultType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of RepeatabilityResultType."""

    ACCEPTED = "accepted"
    REJECTED = "rejected"


class TrialMatcherInferenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the Trial Matcher inference."""

    TRIAL_ELIGIBILITY = "trialEligibility"
