# Contribution Guide

Thank you for taking the time to contribute to **Mousam** 🌦️
We truly appreciate your effort to help improve the project. This guide explains how you can contribute and what to expect during the review process.

---

## Reporting Bugs or Suggesting Features

If you’d like to report a bug or suggest a new feature or improvement (code, documentation, UI, or anything else):

1. **Check existing issues first** to avoid duplicates.
2. If the issue hasn’t been reported, feel free to **open a new issue**.
3. When reporting a bug, please:

   * Be as **specific** as possible.
   * Describe the **expected behavior** vs the **actual behavior**.
   * Clearly explain the **steps to reproduce** the issue.
   * Include logs, screenshots, or environment details if applicable.

Well-described issues help maintainers understand and fix problems faster.

---

## Submitting Changes (Pull Requests)

Once you’ve identified an issue or feature to work on, follow these steps:

1. **Fork** the repository.
2. Create a **new branch** for your change (recommended).
3. Make your changes and create **clear, focused commits**.

   * Write meaningful commit messages describing *what* and *why*.
4. **Test your changes thoroughly** to ensure:

   * Existing functionality still works.
   * Your new change integrates smoothly with the project.
5. Push your changes to your fork.
6. Open a **Pull Request (PR)** and include:

   * A clear summary of the problem.
   * The solution you implemented.
   * Any relevant screenshots or test details (if applicable).

After submission, your PR will be reviewed. You may receive feedback or requests for changes before it is approved and merged.

---

## Translation Contributions 🌍

We welcome translation contributions to help Mousam reach more users worldwide.

### How to Contribute Translations

1. Check the existing localization files to see if your language already exists.
2. If adding a new language:

   * Create a new translation file following the existing structure.
3. If improving an existing translation:

   * Ensure accuracy, clarity, and consistency.
4. Test the app to confirm translations display correctly.

### Important Translation Rules

* ❗ **Do NOT translate branding terms**, including:

  * **Mousam**
* Keep technical terms consistent with the rest of the project.
* Avoid machine-only translations without review.

If you’re unsure about wording or context, feel free to open an issue or ask for clarification before submitting.

---

## Code of Conduct

Please be respectful and constructive in all interactions. We aim to maintain a welcoming and inclusive community for everyone contributing to Mousam.

---
