"use strict";

var helpers = require("../../helpers/helpers");

exports["Asia/Irkutsk"] = {

	"guess:by:offset" : helpers.makeTestGuess("Asia/Irkutsk", { offset: true, expect: "Asia/Manila" }),

	"guess:by:abbr" : helpers.makeTestGuess("Asia/Irkutsk", { abbr: true, expect: "Asia/Manila" }),

	"1879" : helpers.makeTestYear("Asia/Irkutsk", [
		["1879-12-31T17:02:55+00:00", "00:00:00", "IMT", -25025 / 60]
	]),

	"1920" : helpers.makeTestYear("Asia/Irkutsk", [
		["1920-01-24T17:02:54+00:00", "23:59:59", "IMT", -25025 / 60],
		["1920-01-24T17:02:55+00:00", "00:02:55", "+07", -420]
	]),

	"1930" : helpers.makeTestYear("Asia/Irkutsk", [
		["1930-06-20T16:59:59+00:00", "23:59:59", "+07", -420],
		["1930-06-20T17:00:00+00:00", "01:00:00", "+08", -480]
	]),

	"1981" : helpers.makeTestYear("Asia/Irkutsk", [
		["1981-03-31T15:59:59+00:00", "23:59:59", "+08", -480],
		["1981-03-31T16:00:00+00:00", "01:00:00", "+09", -540],
		["1981-09-30T14:59:59+00:00", "23:59:59", "+09", -540],
		["1981-09-30T15:00:00+00:00", "23:00:00", "+08", -480]
	]),

	"1982" : helpers.makeTestYear("Asia/Irkutsk", [
		["1982-03-31T15:59:59+00:00", "23:59:59", "+08", -480],
		["1982-03-31T16:00:00+00:00", "01:00:00", "+09", -540],
		["1982-09-30T14:59:59+00:00", "23:59:59", "+09", -540],
		["1982-09-30T15:00:00+00:00", "23:00:00", "+08", -480]
	]),

	"1983" : helpers.makeTestYear("Asia/Irkutsk", [
		["1983-03-31T15:59:59+00:00", "23:59:59", "+08", -480],
		["1983-03-31T16:00:00+00:00", "01:00:00", "+09", -540],
		["1983-09-30T14:59:59+00:00", "23:59:59", "+09", -540],
		["1983-09-30T15:00:00+00:00", "23:00:00", "+08", -480]
	]),

	"1984" : helpers.makeTestYear("Asia/Irkutsk", [
		["1984-03-31T15:59:59+00:00", "23:59:59", "+08", -480],
		["1984-03-31T16:00:00+00:00", "01:00:00", "+09", -540],
		["1984-09-29T17:59:59+00:00", "02:59:59", "+09", -540],
		["1984-09-29T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1985" : helpers.makeTestYear("Asia/Irkutsk", [
		["1985-03-30T17:59:59+00:00", "01:59:59", "+08", -480],
		["1985-03-30T18:00:00+00:00", "03:00:00", "+09", -540],
		["1985-09-28T17:59:59+00:00", "02:59:59", "+09", -540],
		["1985-09-28T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1986" : helpers.makeTestYear("Asia/Irkutsk", [
		["1986-03-29T17:59:59+00:00", "01:59:59", "+08", -480],
		["1986-03-29T18:00:00+00:00", "03:00:00", "+09", -540],
		["1986-09-27T17:59:59+00:00", "02:59:59", "+09", -540],
		["1986-09-27T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1987" : helpers.makeTestYear("Asia/Irkutsk", [
		["1987-03-28T17:59:59+00:00", "01:59:59", "+08", -480],
		["1987-03-28T18:00:00+00:00", "03:00:00", "+09", -540],
		["1987-09-26T17:59:59+00:00", "02:59:59", "+09", -540],
		["1987-09-26T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1988" : helpers.makeTestYear("Asia/Irkutsk", [
		["1988-03-26T17:59:59+00:00", "01:59:59", "+08", -480],
		["1988-03-26T18:00:00+00:00", "03:00:00", "+09", -540],
		["1988-09-24T17:59:59+00:00", "02:59:59", "+09", -540],
		["1988-09-24T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1989" : helpers.makeTestYear("Asia/Irkutsk", [
		["1989-03-25T17:59:59+00:00", "01:59:59", "+08", -480],
		["1989-03-25T18:00:00+00:00", "03:00:00", "+09", -540],
		["1989-09-23T17:59:59+00:00", "02:59:59", "+09", -540],
		["1989-09-23T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1990" : helpers.makeTestYear("Asia/Irkutsk", [
		["1990-03-24T17:59:59+00:00", "01:59:59", "+08", -480],
		["1990-03-24T18:00:00+00:00", "03:00:00", "+09", -540],
		["1990-09-29T17:59:59+00:00", "02:59:59", "+09", -540],
		["1990-09-29T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1991" : helpers.makeTestYear("Asia/Irkutsk", [
		["1991-03-30T17:59:59+00:00", "01:59:59", "+08", -480],
		["1991-03-30T18:00:00+00:00", "02:00:00", "+08", -480],
		["1991-09-28T18:59:59+00:00", "02:59:59", "+08", -480],
		["1991-09-28T19:00:00+00:00", "02:00:00", "+07", -420]
	]),

	"1992" : helpers.makeTestYear("Asia/Irkutsk", [
		["1992-01-18T18:59:59+00:00", "01:59:59", "+07", -420],
		["1992-01-18T19:00:00+00:00", "03:00:00", "+08", -480],
		["1992-03-28T17:59:59+00:00", "01:59:59", "+08", -480],
		["1992-03-28T18:00:00+00:00", "03:00:00", "+09", -540],
		["1992-09-26T17:59:59+00:00", "02:59:59", "+09", -540],
		["1992-09-26T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1993" : helpers.makeTestYear("Asia/Irkutsk", [
		["1993-03-27T17:59:59+00:00", "01:59:59", "+08", -480],
		["1993-03-27T18:00:00+00:00", "03:00:00", "+09", -540],
		["1993-09-25T17:59:59+00:00", "02:59:59", "+09", -540],
		["1993-09-25T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1994" : helpers.makeTestYear("Asia/Irkutsk", [
		["1994-03-26T17:59:59+00:00", "01:59:59", "+08", -480],
		["1994-03-26T18:00:00+00:00", "03:00:00", "+09", -540],
		["1994-09-24T17:59:59+00:00", "02:59:59", "+09", -540],
		["1994-09-24T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1995" : helpers.makeTestYear("Asia/Irkutsk", [
		["1995-03-25T17:59:59+00:00", "01:59:59", "+08", -480],
		["1995-03-25T18:00:00+00:00", "03:00:00", "+09", -540],
		["1995-09-23T17:59:59+00:00", "02:59:59", "+09", -540],
		["1995-09-23T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1996" : helpers.makeTestYear("Asia/Irkutsk", [
		["1996-03-30T17:59:59+00:00", "01:59:59", "+08", -480],
		["1996-03-30T18:00:00+00:00", "03:00:00", "+09", -540],
		["1996-10-26T17:59:59+00:00", "02:59:59", "+09", -540],
		["1996-10-26T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1997" : helpers.makeTestYear("Asia/Irkutsk", [
		["1997-03-29T17:59:59+00:00", "01:59:59", "+08", -480],
		["1997-03-29T18:00:00+00:00", "03:00:00", "+09", -540],
		["1997-10-25T17:59:59+00:00", "02:59:59", "+09", -540],
		["1997-10-25T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1998" : helpers.makeTestYear("Asia/Irkutsk", [
		["1998-03-28T17:59:59+00:00", "01:59:59", "+08", -480],
		["1998-03-28T18:00:00+00:00", "03:00:00", "+09", -540],
		["1998-10-24T17:59:59+00:00", "02:59:59", "+09", -540],
		["1998-10-24T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"1999" : helpers.makeTestYear("Asia/Irkutsk", [
		["1999-03-27T17:59:59+00:00", "01:59:59", "+08", -480],
		["1999-03-27T18:00:00+00:00", "03:00:00", "+09", -540],
		["1999-10-30T17:59:59+00:00", "02:59:59", "+09", -540],
		["1999-10-30T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2000" : helpers.makeTestYear("Asia/Irkutsk", [
		["2000-03-25T17:59:59+00:00", "01:59:59", "+08", -480],
		["2000-03-25T18:00:00+00:00", "03:00:00", "+09", -540],
		["2000-10-28T17:59:59+00:00", "02:59:59", "+09", -540],
		["2000-10-28T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2001" : helpers.makeTestYear("Asia/Irkutsk", [
		["2001-03-24T17:59:59+00:00", "01:59:59", "+08", -480],
		["2001-03-24T18:00:00+00:00", "03:00:00", "+09", -540],
		["2001-10-27T17:59:59+00:00", "02:59:59", "+09", -540],
		["2001-10-27T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2002" : helpers.makeTestYear("Asia/Irkutsk", [
		["2002-03-30T17:59:59+00:00", "01:59:59", "+08", -480],
		["2002-03-30T18:00:00+00:00", "03:00:00", "+09", -540],
		["2002-10-26T17:59:59+00:00", "02:59:59", "+09", -540],
		["2002-10-26T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2003" : helpers.makeTestYear("Asia/Irkutsk", [
		["2003-03-29T17:59:59+00:00", "01:59:59", "+08", -480],
		["2003-03-29T18:00:00+00:00", "03:00:00", "+09", -540],
		["2003-10-25T17:59:59+00:00", "02:59:59", "+09", -540],
		["2003-10-25T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2004" : helpers.makeTestYear("Asia/Irkutsk", [
		["2004-03-27T17:59:59+00:00", "01:59:59", "+08", -480],
		["2004-03-27T18:00:00+00:00", "03:00:00", "+09", -540],
		["2004-10-30T17:59:59+00:00", "02:59:59", "+09", -540],
		["2004-10-30T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2005" : helpers.makeTestYear("Asia/Irkutsk", [
		["2005-03-26T17:59:59+00:00", "01:59:59", "+08", -480],
		["2005-03-26T18:00:00+00:00", "03:00:00", "+09", -540],
		["2005-10-29T17:59:59+00:00", "02:59:59", "+09", -540],
		["2005-10-29T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2006" : helpers.makeTestYear("Asia/Irkutsk", [
		["2006-03-25T17:59:59+00:00", "01:59:59", "+08", -480],
		["2006-03-25T18:00:00+00:00", "03:00:00", "+09", -540],
		["2006-10-28T17:59:59+00:00", "02:59:59", "+09", -540],
		["2006-10-28T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2007" : helpers.makeTestYear("Asia/Irkutsk", [
		["2007-03-24T17:59:59+00:00", "01:59:59", "+08", -480],
		["2007-03-24T18:00:00+00:00", "03:00:00", "+09", -540],
		["2007-10-27T17:59:59+00:00", "02:59:59", "+09", -540],
		["2007-10-27T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2008" : helpers.makeTestYear("Asia/Irkutsk", [
		["2008-03-29T17:59:59+00:00", "01:59:59", "+08", -480],
		["2008-03-29T18:00:00+00:00", "03:00:00", "+09", -540],
		["2008-10-25T17:59:59+00:00", "02:59:59", "+09", -540],
		["2008-10-25T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2009" : helpers.makeTestYear("Asia/Irkutsk", [
		["2009-03-28T17:59:59+00:00", "01:59:59", "+08", -480],
		["2009-03-28T18:00:00+00:00", "03:00:00", "+09", -540],
		["2009-10-24T17:59:59+00:00", "02:59:59", "+09", -540],
		["2009-10-24T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2010" : helpers.makeTestYear("Asia/Irkutsk", [
		["2010-03-27T17:59:59+00:00", "01:59:59", "+08", -480],
		["2010-03-27T18:00:00+00:00", "03:00:00", "+09", -540],
		["2010-10-30T17:59:59+00:00", "02:59:59", "+09", -540],
		["2010-10-30T18:00:00+00:00", "02:00:00", "+08", -480]
	]),

	"2011" : helpers.makeTestYear("Asia/Irkutsk", [
		["2011-03-26T17:59:59+00:00", "01:59:59", "+08", -480],
		["2011-03-26T18:00:00+00:00", "03:00:00", "+09", -540]
	]),

	"2014" : helpers.makeTestYear("Asia/Irkutsk", [
		["2014-10-25T16:59:59+00:00", "01:59:59", "+09", -540]
	])
};