"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Cancun"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Cancun", { offset: true, expect: "America/Lima" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Cancun", { abbr: true, expect: "America/Panama" }),

	"1922" : helpers.makeTestYear("America/Cancun", [
		["1922-01-01T06:00:00+00:00", "00:00:00", "CST", 360]
	]),

	"1981" : helpers.makeTestYear("America/Cancun", [
		["1981-12-23T05:59:59+00:00", "23:59:59", "CST", 360],
		["1981-12-23T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"1996" : helpers.makeTestYear("America/Cancun", [
		["1996-04-07T06:59:59+00:00", "01:59:59", "EST", 300],
		["1996-04-07T07:00:00+00:00", "03:00:00", "EDT", 240],
		["1996-10-27T05:59:59+00:00", "01:59:59", "EDT", 240],
		["1996-10-27T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"1997" : helpers.makeTestYear("America/Cancun", [
		["1997-04-06T06:59:59+00:00", "01:59:59", "EST", 300],
		["1997-04-06T07:00:00+00:00", "03:00:00", "EDT", 240],
		["1997-10-26T05:59:59+00:00", "01:59:59", "EDT", 240],
		["1997-10-26T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"1998" : helpers.makeTestYear("America/Cancun", [
		["1998-04-05T06:59:59+00:00", "01:59:59", "EST", 300],
		["1998-04-05T07:00:00+00:00", "03:00:00", "EDT", 240],
		["1998-08-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["1998-08-02T06:00:00+00:00", "01:00:00", "CDT", 300],
		["1998-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1998-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1999" : helpers.makeTestYear("America/Cancun", [
		["1999-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["1999-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1999-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1999-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2000" : helpers.makeTestYear("America/Cancun", [
		["2000-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2000-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2000-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2000-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2001" : helpers.makeTestYear("America/Cancun", [
		["2001-05-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2001-05-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2001-09-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2001-09-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2002" : helpers.makeTestYear("America/Cancun", [
		["2002-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2002-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2002-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2002-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2003" : helpers.makeTestYear("America/Cancun", [
		["2003-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2003-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2003-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2003-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2004" : helpers.makeTestYear("America/Cancun", [
		["2004-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2004-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2004-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2004-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2005" : helpers.makeTestYear("America/Cancun", [
		["2005-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2005-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2005-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2005-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2006" : helpers.makeTestYear("America/Cancun", [
		["2006-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2006-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2006-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2006-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2007" : helpers.makeTestYear("America/Cancun", [
		["2007-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2007-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2007-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2007-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2008" : helpers.makeTestYear("America/Cancun", [
		["2008-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2008-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2008-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2008-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2009" : helpers.makeTestYear("America/Cancun", [
		["2009-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2009-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2009-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2009-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2010" : helpers.makeTestYear("America/Cancun", [
		["2010-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2010-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2010-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2010-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2011" : helpers.makeTestYear("America/Cancun", [
		["2011-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2011-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2011-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2011-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2012" : helpers.makeTestYear("America/Cancun", [
		["2012-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2012-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2012-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2012-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2013" : helpers.makeTestYear("America/Cancun", [
		["2013-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2013-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2013-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2013-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2014" : helpers.makeTestYear("America/Cancun", [
		["2014-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2014-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2014-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2014-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2015" : helpers.makeTestYear("America/Cancun", [
		["2015-02-01T07:59:59+00:00", "01:59:59", "CST", 360]
	])
};