<?php

/**
 * Device Detector - The Universal Device Detection library for parsing User Agents
 *
 * @link https://matomo.org
 *
 * @license http://www.gnu.org/licenses/lgpl.html LGPL v3 or later
 */

declare(strict_types=1);

namespace DeviceDetector\Tests\Parser\Client;

use DeviceDetector\Parser\Client\MobileApp;
use PHPUnit\Framework\Attributes\DataProvider;
use PHPUnit\Framework\TestCase;
use Spyc;

class MobileAppTest extends TestCase
{
    /**
     * @dataProvider getFixtures
     */
    #[DataProvider('getFixtures')]
    public function testParse(string $useragent, array $client): void
    {
        $mobileAppParser = new MobileApp();
        $mobileAppParser::setVersionTruncation(MobileApp::VERSION_TRUNCATION_NONE);
        $mobileAppParser->setUserAgent($useragent);
        $this->assertEquals($client, $mobileAppParser->parse());
    }

    public static function getFixtures(): array
    {
        $fixtureData = Spyc::YAMLLoad(\realpath(__DIR__) . '/fixtures/mobile_app.yml');

        $fixtureData = \array_map(static function (array $item): array {
            return ['useragent' => $item['user_agent'], 'client' => $item['client']];
        }, $fixtureData);

        return $fixtureData;
    }

    public function testStructureMobileAppYml(): void
    {
        $ymlDataItems = Spyc::YAMLLoad(__DIR__ . '/../../../regexes/client/mobile_apps.yml');

        foreach ($ymlDataItems as $item) {
            $this->assertTrue(\array_key_exists('regex', $item), 'key "regex" not exist');
            $this->assertTrue(\array_key_exists('name', $item), 'key "name" not exist');
            $this->assertTrue(\array_key_exists('version', $item), 'key "version" not exist');
        }
    }
}
