; Test dwarf codegen for DILocalVariable of a byval function argument that
; points to neither an argument nor an alloca. This kind of IR is generated by
; SafeStack for unsafe byval arguments.
; RUN: llc -mtriple=x86_64-unknown-unknown --experimental-debug-variable-locations=false -stop-after finalize-isel %s -o - | FileCheck %s --check-prefixes=CHECK,NORMAL
; RUN: llc -mtriple=x86_64-unknown-unknown --experimental-debug-variable-locations -stop-after finalize-isel %s -o - | FileCheck %s --check-prefixes=CHECK,INSTRREF

; This was built by compiling the following source with SafeStack and
; simplifying the result a little.
; struct S {
;   int a[100];
; };
;
; int f(S zzz, unsigned long len) {
;   return zzz.a[len];
; }

; CHECK:    ![[ZZZ:.*]] = !DILocalVariable(name: "zzz",
; NORMAL:   DBG_VALUE {{.*}} ![[ZZZ]], !DIExpression(DW_OP_deref, DW_OP_constu, 400, DW_OP_minus)
; INSTRREF: DBG_INSTR_REF ![[ZZZ]], !DIExpression(DW_OP_LLVM_arg, 0, DW_OP_deref, DW_OP_constu, 400, DW_OP_minus, DW_OP_deref)

%struct.S = type { [100 x i32] }

@__safestack_unsafe_stack_ptr = external thread_local(initialexec) global ptr

; Function Attrs: norecurse nounwind readonly safestack uwtable
define i32 @_Z1f1Sm(ptr byval(%struct.S) nocapture readonly align 8 %zzz, i64 %len) #0 !dbg !12 {
entry:
  %unsafe_stack_ptr = load ptr, ptr @__safestack_unsafe_stack_ptr, !dbg !22
  %unsafe_stack_static_top = getelementptr i8, ptr %unsafe_stack_ptr, i32 -400, !dbg !22
  store ptr %unsafe_stack_static_top, ptr @__safestack_unsafe_stack_ptr, !dbg !22
; !17 describes "zzz"
  call void @llvm.dbg.declare(metadata ptr %unsafe_stack_ptr, metadata !17, metadata !23), !dbg !22
  %0 = getelementptr i8, ptr %unsafe_stack_ptr, i32 -400, !dbg !22
  call void @llvm.memcpy.p0.p0.i64(ptr align 8 %0, ptr align 8 %zzz, i64 400, i1 false), !dbg !24
  tail call void @llvm.dbg.value(metadata i64 %len, metadata !18, metadata !25), !dbg !24
  %arrayidx = getelementptr inbounds %struct.S, ptr %0, i64 0, i32 0, i64 %len, !dbg !26
  %1 = load i32, ptr %arrayidx, align 4, !dbg !26, !tbaa !27
  store ptr %unsafe_stack_ptr, ptr @__safestack_unsafe_stack_ptr, !dbg !31
  ret i32 %1, !dbg !31
}

; Function Attrs: nounwind readnone
declare void @llvm.dbg.declare(metadata, metadata, metadata) #1

; Function Attrs: nounwind readnone
declare void @llvm.dbg.value(metadata, metadata, metadata) #1

; Function Attrs: argmemonly nounwind
declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture readonly, i64, i1) #2

attributes #0 = { norecurse nounwind readonly safestack uwtable "disable-tail-calls"="false" "less-precise-fpmad"="false" "frame-pointer"="none" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="x86-64" "target-features"="+fxsr,+mmx,+sse,+sse2" "use-soft-float"="false" }
attributes #1 = { nounwind readnone }
attributes #2 = { argmemonly nounwind }

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!19, !20}
!llvm.ident = !{!21}

!0 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: !1, producer: "clang version 3.8.0 (trunk 254107) (llvm/trunk 254109)", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !2, retainedTypes: !3)
!1 = !DIFile(filename: "../llvm/1.cc", directory: "/tmp/build")
!2 = !{}
!3 = !{!4}
!4 = !DICompositeType(tag: DW_TAG_structure_type, name: "S", file: !1, line: 4, size: 3200, align: 32, elements: !5, identifier: "_ZTS1S")
!5 = !{!6}
!6 = !DIDerivedType(tag: DW_TAG_member, name: "a", scope: !4, file: !1, line: 5, baseType: !7, size: 3200, align: 32)
!7 = !DICompositeType(tag: DW_TAG_array_type, baseType: !8, size: 3200, align: 32, elements: !9)
!8 = !DIBasicType(name: "int", size: 32, align: 32, encoding: DW_ATE_signed)
!9 = !{!10}
!10 = !DISubrange(count: 100)
!12 = distinct !DISubprogram(name: "f", linkageName: "_Z1f1Sm", scope: !1, file: !1, line: 8, type: !13, isLocal: false, isDefinition: true, scopeLine: 8, flags: DIFlagPrototyped, isOptimized: true, unit: !0, retainedNodes: !16)
!13 = !DISubroutineType(types: !14)
!14 = !{!8, !4, !15}
!15 = !DIBasicType(name: "long unsigned int", size: 64, align: 64, encoding: DW_ATE_unsigned)
!16 = !{!17, !18}
!17 = !DILocalVariable(name: "zzz", arg: 1, scope: !12, file: !1, line: 8, type: !4)
!18 = !DILocalVariable(name: "len", arg: 2, scope: !12, file: !1, line: 8, type: !15)
!19 = !{i32 2, !"Dwarf Version", i32 4}
!20 = !{i32 2, !"Debug Info Version", i32 3}
!21 = !{!"clang version 3.8.0 (trunk 254107) (llvm/trunk 254109)"}
!22 = !DILocation(line: 8, column: 9, scope: !12)
!23 = !DIExpression(DW_OP_deref, DW_OP_constu, 400, DW_OP_minus)
!24 = !DILocation(line: 8, column: 28, scope: !12)
!25 = !DIExpression()
!26 = !DILocation(line: 9, column: 10, scope: !12)
!27 = !{!28, !28, i64 0}
!28 = !{!"int", !29, i64 0}
!29 = !{!"omnipotent char", !30, i64 0}
!30 = !{!"Simple C/C++ TBAA"}
!31 = !DILocation(line: 9, column: 3, scope: !12)
