---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# AspNet header exposes version information

## Description

The target website returns AspNet headers and version information of this website. By
exposing these values attackers may attempt to identify if the target software is vulnerable to known
vulnerabilities, or catalog known sites running particular versions to exploit in the future when a
vulnerability is identified in the particular version.

## Remediation

To remove the `X-AspNet-Version` header set `<httpRuntime enableVersionHeader="false" />` in the `<system.Web>`
section of the `Web.config` file.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 16.5 | true | 16 | Passive | Low |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [IIS Remove Unwanted Headers](https://techcommunity.microsoft.com/t5/iis-support-blog/remove-unwanted-http-response-headers/ba-p/369710)
