// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Takes a list of configurationId as input and starts an asynchronous deletion
//
// task to remove the configurationItems. Returns a unique deletion task
// identifier.
func (c *Client) StartBatchDeleteConfigurationTask(ctx context.Context, params *StartBatchDeleteConfigurationTaskInput, optFns ...func(*Options)) (*StartBatchDeleteConfigurationTaskOutput, error) {
	if params == nil {
		params = &StartBatchDeleteConfigurationTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartBatchDeleteConfigurationTask", params, optFns, c.addOperationStartBatchDeleteConfigurationTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartBatchDeleteConfigurationTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartBatchDeleteConfigurationTaskInput struct {

	//  The list of configuration IDs that will be deleted by the task.
	//
	// This member is required.
	ConfigurationIds []string

	//  The type of configuration item to delete. Supported types are: SERVER.
	//
	// This member is required.
	ConfigurationType types.DeletionConfigurationItemType

	noSmithyDocumentSerde
}

type StartBatchDeleteConfigurationTaskOutput struct {

	//  The unique identifier associated with the newly started deletion task.
	TaskId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartBatchDeleteConfigurationTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartBatchDeleteConfigurationTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartBatchDeleteConfigurationTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartBatchDeleteConfigurationTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartBatchDeleteConfigurationTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartBatchDeleteConfigurationTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartBatchDeleteConfigurationTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartBatchDeleteConfigurationTask",
	}
}
