//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrate

import "time"

// AssessedDisk - A disk assessed for an assessment.
type AssessedDisk struct {
	// READ-ONLY; User friendly name of the assessed disk.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Gigabytes of storage provided by the recommended Azure disk size.
	GigabytesForRecommendedDiskSize *int32 `json:"gigabytesForRecommendedDiskSize,omitempty" azure:"ro"`

	// READ-ONLY; Gigabytes of storage provisioned for this disk.
	GigabytesProvisioned *float64 `json:"gigabytesProvisioned,omitempty" azure:"ro"`

	// READ-ONLY; Disk throughput in MegaBytes per second.
	MegabytesPerSecondOfRead *float64 `json:"megabytesPerSecondOfRead,omitempty" azure:"ro"`

	// READ-ONLY; Disk throughput in MegaBytes per second.
	MegabytesPerSecondOfWrite *float64 `json:"megabytesPerSecondOfWrite,omitempty" azure:"ro"`

	// READ-ONLY; Estimated aggregate storage cost for a 31-day month for this disk.
	MonthlyStorageCost *float64 `json:"monthlyStorageCost,omitempty" azure:"ro"`

	// READ-ONLY; Name of the assessed disk.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Number of read operations per second for the disk.
	NumberOfReadOperationsPerSecond *float64 `json:"numberOfReadOperationsPerSecond,omitempty" azure:"ro"`

	// READ-ONLY; Number of read and write operations per second for the disk.
	NumberOfWriteOperationsPerSecond *float64 `json:"numberOfWriteOperationsPerSecond,omitempty" azure:"ro"`

	// READ-ONLY; Recommended Azure size for the disk, given utilization data and preferences set on Assessment.
	RecommendedDiskSize *AzureDiskSize `json:"recommendedDiskSize,omitempty" azure:"ro"`

	// READ-ONLY; Storage type selected for this disk.
	RecommendedDiskType *AzureDiskType `json:"recommendedDiskType,omitempty" azure:"ro"`

	// READ-ONLY; Whether this disk is suitable for Azure.
	Suitability *CloudSuitability `json:"suitability,omitempty" azure:"ro"`

	// READ-ONLY; If disk is suitable to be migrate but some conditions/checks were not considered while calculating suitability,
	// this explains the details.
	SuitabilityDetail *AzureDiskSuitabilityDetail `json:"suitabilityDetail,omitempty" azure:"ro"`

	// READ-ONLY; If disk is not suitable to be migrated, this explains the reasons and mitigation steps.
	SuitabilityExplanation *AzureDiskSuitabilityExplanation `json:"suitabilityExplanation,omitempty" azure:"ro"`
}

// AssessedMachine - A machine evaluated as part of an assessment.
type AssessedMachine struct {
	// For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`

	// Properties of an assessed machine.
	Properties *AssessedMachineProperties `json:"properties,omitempty"`

	// READ-ONLY; Path reference to this assessed machine.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessments/{assessmentName}/assessedMachines/{assessedMachineName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the machine.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/groups/assessments/assessedMachines].
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssessedMachineProperties - Properties of an assessed machine.
type AssessedMachineProperties struct {
	// READ-ONLY; Boot type of the machine.
	BootType *MachineBootType `json:"bootType,omitempty" azure:"ro"`

	// READ-ONLY; Confidence rating of assessed machine.
	ConfidenceRatingInPercentage *float64 `json:"confidenceRatingInPercentage,omitempty" azure:"ro"`

	// READ-ONLY; Time when this machine was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; ARM ID of the discovered machine.
	DatacenterMachineArmID *string `json:"datacenterMachineArmId,omitempty" azure:"ro"`

	// READ-ONLY; ARM ID of the discovered datacenter.
	DatacenterManagementServerArmID *string `json:"datacenterManagementServerArmId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the server hosting the datacenter management solution.
	DatacenterManagementServerName *string `json:"datacenterManagementServerName,omitempty" azure:"ro"`

	// READ-ONLY; Description of the machine
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object.
	Disks map[string]*AssessedDisk `json:"disks,omitempty" azure:"ro"`

	// READ-ONLY; User readable name of the machine as defined by the user in their private datacenter.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Memory in Megabytes.
	MegabytesOfMemory *float64 `json:"megabytesOfMemory,omitempty" azure:"ro"`

	// READ-ONLY; Megabytes of memory in the Recommended Azure VM Size.
	MegabytesOfMemoryForRecommendedSize *float64 `json:"megabytesOfMemoryForRecommendedSize,omitempty" azure:"ro"`

	// READ-ONLY; Monthly network cost estimate for the network adapters that are attached to this machine as a group, for a 31-day
	// month.
	MonthlyBandwidthCost *float64 `json:"monthlyBandwidthCost,omitempty" azure:"ro"`

	// READ-ONLY; Compute Cost for a 31-day month, if the machine is migrated to Azure with the Recommended Size.
	MonthlyComputeCostForRecommendedSize *float64 `json:"monthlyComputeCostForRecommendedSize,omitempty" azure:"ro"`

	// READ-ONLY; Monthly premium storage cost estimate for the disks that are attached to this machine as a group, for a 31-day
	// month.
	MonthlyPremiumStorageCost *float64 `json:"monthlyPremiumStorageCost,omitempty" azure:"ro"`

	// READ-ONLY; Monthly standard SSD storage cost estimate for the disks that are attached to this machine as a group, for a
	// 31-day month.
	MonthlyStandardSSDStorageCost *float64 `json:"monthlyStandardSSDStorageCost,omitempty" azure:"ro"`

	// READ-ONLY; Monthly storage cost estimate for the disks that are attached to this machine as a group, for a 31-day month.
	MonthlyStorageCost *float64 `json:"monthlyStorageCost,omitempty" azure:"ro"`

	// READ-ONLY; Dictionary of network adapters attached to the machine. Key is name of the adapter. Value is a network adapter
	// object.
	NetworkAdapters map[string]*AssessedNetworkAdapter `json:"networkAdapters,omitempty" azure:"ro"`

	// READ-ONLY; Processor count.
	NumberOfCores *int32 `json:"numberOfCores,omitempty" azure:"ro"`

	// READ-ONLY; Number of CPU cores in the Recommended Azure VM Size.
	NumberOfCoresForRecommendedSize *int32 `json:"numberOfCoresForRecommendedSize,omitempty" azure:"ro"`

	// READ-ONLY; Operating System name of the machine.
	OperatingSystemName *string `json:"operatingSystemName,omitempty" azure:"ro"`

	// READ-ONLY; Operating System type of the machine.
	OperatingSystemType *string `json:"operatingSystemType,omitempty" azure:"ro"`

	// READ-ONLY; Operating System version of the machine.
	OperatingSystemVersion *string `json:"operatingSystemVersion,omitempty" azure:"ro"`

	// READ-ONLY; Utilization percentage of the processor core as observed in the private data center, in the Time Range selected
	// on Assessment, reported as the Percentile value based on the percentile number selected
	// in assessment.
	PercentageCoresUtilization *float64 `json:"percentageCoresUtilization,omitempty" azure:"ro"`

	// READ-ONLY; Utilization percentage of the memory as observed in the private data center, in the Time Range selected on Assessment,
	// reported as the Percentile value based on the percentile number selected in
	// assessment.
	PercentageMemoryUtilization *float64 `json:"percentageMemoryUtilization,omitempty" azure:"ro"`

	// READ-ONLY; Recommended Azure size for this machine.
	RecommendedSize *AzureVMSize `json:"recommendedSize,omitempty" azure:"ro"`

	// READ-ONLY; Whether machine is suitable for migration to Azure.
	Suitability *CloudSuitability `json:"suitability,omitempty" azure:"ro"`

	// READ-ONLY; If machine is not suitable for cloud, this explains the reasons.
	SuitabilityDetail *AzureVMSuitabilityDetail `json:"suitabilityDetail,omitempty" azure:"ro"`

	// READ-ONLY; If machine is not ready to be migrated, this explains the reasons and mitigation steps.
	SuitabilityExplanation *AzureVMSuitabilityExplanation `json:"suitabilityExplanation,omitempty" azure:"ro"`

	// READ-ONLY; Time when this machine was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time `json:"updatedTimestamp,omitempty" azure:"ro"`
}

// AssessedMachineResultList - List of assessed machines.
type AssessedMachineResultList struct {
	NextLink *string `json:"nextLink,omitempty"`

	// List of assessed machines.
	Value []*AssessedMachine `json:"value,omitempty"`
}

// AssessedMachinesClientGetOptions contains the optional parameters for the AssessedMachinesClient.Get method.
type AssessedMachinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssessedMachinesClientListByAssessmentOptions contains the optional parameters for the AssessedMachinesClient.ListByAssessment
// method.
type AssessedMachinesClientListByAssessmentOptions struct {
	// placeholder for future optional parameters
}

// AssessedNetworkAdapter - A network adapter assessed for an assessment.
type AssessedNetworkAdapter struct {
	// Gigabytes transmitted through this adapter each month.
	NetGigabytesTransmittedPerMonth *float64 `json:"netGigabytesTransmittedPerMonth,omitempty"`

	// READ-ONLY; User friendly name of the assessed network adapter.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; List of IP Addresses on the network adapter.
	IPAddresses []*string `json:"ipAddresses,omitempty" azure:"ro"`

	// READ-ONLY; MAC Address of the network adapter.
	MacAddress *string `json:"macAddress,omitempty" azure:"ro"`

	// READ-ONLY; Adapter throughput for incoming traffic in MegaBytes per second.
	MegabytesPerSecondReceived *float64 `json:"megabytesPerSecondReceived,omitempty" azure:"ro"`

	// READ-ONLY; Adapter throughput for outgoing traffic in MegaBytes per second.
	MegabytesPerSecondTransmitted *float64 `json:"megabytesPerSecondTransmitted,omitempty" azure:"ro"`

	// READ-ONLY; Monthly cost estimate for network bandwidth used by this network adapter.
	MonthlyBandwidthCosts *float64 `json:"monthlyBandwidthCosts,omitempty" azure:"ro"`

	// READ-ONLY; Whether this adapter is suitable for Azure.
	Suitability *CloudSuitability `json:"suitability,omitempty" azure:"ro"`

	// READ-ONLY; If network adapter is not suitable for cloud, this explains the reasons.
	SuitabilityDetail *AzureNetworkAdapterSuitabilityDetail `json:"suitabilityDetail,omitempty" azure:"ro"`

	// READ-ONLY; If network adapter is suitable, this explains the reasons and mitigation steps.
	SuitabilityExplanation *AzureNetworkAdapterSuitabilityExplanation `json:"suitabilityExplanation,omitempty" azure:"ro"`
}

// Assessment - An assessment created for a group in the Migration project.
type Assessment struct {
	// REQUIRED; Properties of the assessment.
	Properties *AssessmentProperties `json:"properties,omitempty"`

	// For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`

	// READ-ONLY; Path reference to this assessment.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessment/{assessmentName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Unique name of an assessment.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/groups/assessments].
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssessmentOptions - Assessment options.
type AssessmentOptions struct {
	// REQUIRED; Properties of the assessment options.
	Properties *AssessmentOptionsProperties `json:"properties,omitempty"`

	// READ-ONLY; Unique identifier of an assessment options.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Unique name of an assessment options.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// AssessmentOptionsProperties - Assessment options properties.
type AssessmentOptionsProperties struct {
	// READ-ONLY; List of supported currencies for reserved instances.
	ReservedInstanceSupportedCurrencies []*string `json:"reservedInstanceSupportedCurrencies,omitempty" azure:"ro"`

	// READ-ONLY; List of supported Azure regions for reserved instances.
	ReservedInstanceSupportedLocations []*string `json:"reservedInstanceSupportedLocations,omitempty" azure:"ro"`

	// READ-ONLY; List of supported Azure offer codes for reserved instances.
	ReservedInstanceSupportedOffers []*string `json:"reservedInstanceSupportedOffers,omitempty" azure:"ro"`

	// READ-ONLY; List of supported VM Families.
	ReservedInstanceVMFamilies []*string `json:"reservedInstanceVmFamilies,omitempty" azure:"ro"`

	// READ-ONLY; Dictionary of VM families grouped by vm family name describing the targeted azure locations of VM family and
	// the category of the family.
	VMFamilies []*VMFamily `json:"vmFamilies,omitempty" azure:"ro"`
}

// AssessmentOptionsResultList - List of API operations.
type AssessmentOptionsResultList struct {
	// List of operations.
	Value []*AssessmentOptions `json:"value,omitempty"`
}

// AssessmentProperties - Properties of an assessment.
type AssessmentProperties struct {
	// REQUIRED; Storage type selected for this disk.
	AzureDiskType *AzureDiskType `json:"azureDiskType,omitempty"`

	// REQUIRED; AHUB discount on windows virtual machines.
	AzureHybridUseBenefit *AzureHybridUseBenefit `json:"azureHybridUseBenefit,omitempty"`

	// REQUIRED; Target Azure location for which the machines should be assessed. These enums are the same as used by Compute
	// API.
	AzureLocation *AzureLocation `json:"azureLocation,omitempty"`

	// REQUIRED; Offer code according to which cost estimation is done.
	AzureOfferCode *AzureOfferCode `json:"azureOfferCode,omitempty"`

	// REQUIRED; Pricing tier for Size evaluation.
	AzurePricingTier *AzurePricingTier `json:"azurePricingTier,omitempty"`

	// REQUIRED; Storage Redundancy type offered by Azure.
	AzureStorageRedundancy *AzureStorageRedundancy `json:"azureStorageRedundancy,omitempty"`

	// REQUIRED; List of azure VM families.
	AzureVMFamilies []*AzureVMFamily `json:"azureVmFamilies,omitempty"`

	// REQUIRED; Currency to report prices in.
	Currency *Currency `json:"currency,omitempty"`

	// REQUIRED; Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
	DiscountPercentage *float64 `json:"discountPercentage,omitempty"`

	// REQUIRED; Percentile of performance data used to recommend Azure size.
	Percentile *Percentile `json:"percentile,omitempty"`

	// REQUIRED; Azure reserved instance.
	ReservedInstance *ReservedInstance `json:"reservedInstance,omitempty"`

	// REQUIRED; Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure.
	// Min Value = 1.0, Max value = 1.9, Default = 1.3.
	ScalingFactor *float64 `json:"scalingFactor,omitempty"`

	// REQUIRED; Assessment sizing criterion.
	SizingCriterion *AssessmentSizingCriterion `json:"sizingCriterion,omitempty"`

	// REQUIRED; User configurable setting that describes the status of the assessment.
	Stage *AssessmentStage `json:"stage,omitempty"`

	// REQUIRED; Time range of performance data used to recommend a size.
	TimeRange *TimeRange `json:"timeRange,omitempty"`

	// REQUIRED; Specify the duration for which the VMs are up in the on-premises environment.
	VMUptime *VMUptime `json:"vmUptime,omitempty"`

	// READ-ONLY; Confidence rating percentage for assessment. Can be in the range [0, 100].
	ConfidenceRatingInPercentage *float64 `json:"confidenceRatingInPercentage,omitempty" azure:"ro"`

	// READ-ONLY; Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Enterprise agreement subscription arm id.
	EaSubscriptionID *string `json:"eaSubscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; Monthly network cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyBandwidthCost *float64 `json:"monthlyBandwidthCost,omitempty" azure:"ro"`

	// READ-ONLY; Monthly compute cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyComputeCost *float64 `json:"monthlyComputeCost,omitempty" azure:"ro"`

	// READ-ONLY; Monthly premium storage cost estimate for the machines that are part of this assessment as a group, for a 31-day
	// month.
	MonthlyPremiumStorageCost *float64 `json:"monthlyPremiumStorageCost,omitempty" azure:"ro"`

	// READ-ONLY; Monthly standard SSD storage cost estimate for the machines that are part of this assessment as a group, for
	// a 31-day month.
	MonthlyStandardSSDStorageCost *float64 `json:"monthlyStandardSSDStorageCost,omitempty" azure:"ro"`

	// READ-ONLY; Monthly storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyStorageCost *float64 `json:"monthlyStorageCost,omitempty" azure:"ro"`

	// READ-ONLY; Number of assessed machines part of this assessment.
	NumberOfMachines *int32 `json:"numberOfMachines,omitempty" azure:"ro"`

	// READ-ONLY; End time to consider performance data for assessment
	PerfDataEndTime *time.Time `json:"perfDataEndTime,omitempty" azure:"ro"`

	// READ-ONLY; Start time to consider performance data for assessment
	PerfDataStartTime *time.Time `json:"perfDataStartTime,omitempty" azure:"ro"`

	// READ-ONLY; Time when the Azure Prices were queried. Date-Time represented in ISO-8601 format.
	PricesTimestamp *time.Time `json:"pricesTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Whether the assessment has been created and is valid.
	Status *AssessmentStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time `json:"updatedTimestamp,omitempty" azure:"ro"`
}

// AssessmentResultList - List of assessments.
type AssessmentResultList struct {
	// List of assessments.
	Value []*Assessment `json:"value,omitempty"`
}

// AssessmentsClientCreateOptions contains the optional parameters for the AssessmentsClient.Create method.
type AssessmentsClientCreateOptions struct {
	// New or Updated Assessment object.
	Assessment *Assessment
}

// AssessmentsClientDeleteOptions contains the optional parameters for the AssessmentsClient.Delete method.
type AssessmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsClientGetOptions contains the optional parameters for the AssessmentsClient.Get method.
type AssessmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsClientGetReportDownloadURLOptions contains the optional parameters for the AssessmentsClient.GetReportDownloadURL
// method.
type AssessmentsClientGetReportDownloadURLOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsClientListByGroupOptions contains the optional parameters for the AssessmentsClient.ListByGroup method.
type AssessmentsClientListByGroupOptions struct {
	// placeholder for future optional parameters
}

// AssessmentsClientListByProjectOptions contains the optional parameters for the AssessmentsClient.ListByProject method.
type AssessmentsClientListByProjectOptions struct {
	// placeholder for future optional parameters
}

// CloudError - An error response from the Azure Migrate service.
type CloudError struct {
	// An error response from the Azure Migrate service.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the Azure Migrate service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

type CollectorAgentProperties struct {
	SpnDetails *CollectorBodyAgentSpnProperties `json:"spnDetails,omitempty"`

	// READ-ONLY
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY
	LastHeartbeatUTC *time.Time `json:"lastHeartbeatUtc,omitempty" azure:"ro"`

	// READ-ONLY
	Version *string `json:"version,omitempty" azure:"ro"`
}

type CollectorBodyAgentSpnProperties struct {
	// Application/client Id for the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	ApplicationID *string `json:"applicationId,omitempty"`

	// Intended audience for the service principal.
	Audience *string `json:"audience,omitempty"`

	// AAD Authority URL which was used to request the token for the service principal.
	Authority *string `json:"authority,omitempty"`

	// Object Id of the service principal with which the on-premise management/data plane components would communicate with our
	// Azure services.
	ObjectID *string `json:"objectId,omitempty"`

	// Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our
	// Azure services.
	TenantID *string `json:"tenantId,omitempty"`
}

type CollectorProperties struct {
	AgentProperties *CollectorAgentProperties `json:"agentProperties,omitempty"`

	// The ARM id of the discovery service site.
	DiscoverySiteID *string `json:"discoverySiteId,omitempty"`

	// READ-ONLY; Time when this collector was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *string `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Time when this collector was updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *string `json:"updatedTimestamp,omitempty" azure:"ro"`
}

// Disk - A disk discovered on a machine.
type Disk struct {
	// READ-ONLY; User friendly name of the disk.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Gigabytes of storage provisioned for this disk.
	GigabytesAllocated *float64 `json:"gigabytesAllocated,omitempty" azure:"ro"`
}

// DownloadURL - Download URL for assessment report.
type DownloadURL struct {
	// READ-ONLY; Hyperlink to download report.
	AssessmentReportURL *string `json:"assessmentReportUrl,omitempty" azure:"ro"`

	// READ-ONLY; Expiry date of download url.
	ExpirationTime *time.Time `json:"expirationTime,omitempty" azure:"ro"`
}

// Group - A group created in a Migration project.
type Group struct {
	// REQUIRED; Properties of the group.
	Properties *GroupProperties `json:"properties,omitempty"`

	// For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`

	// READ-ONLY; Path reference to this group. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the group.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/groups].
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GroupBodyProperties - Body properties of group update.
type GroupBodyProperties struct {
	// List of machine names that are part of this group.
	Machines []*string `json:"machines,omitempty"`

	// Whether to add or remove the machines.
	OperationType *GroupUpdateOperation `json:"operationType,omitempty"`
}

// GroupProperties - Properties of group resource.
type GroupProperties struct {
	// The type of group.
	GroupType *string `json:"groupType,omitempty"`

	// READ-ONLY; If the assessments are in running state.
	AreAssessmentsRunning *bool `json:"areAssessmentsRunning,omitempty" azure:"ro"`

	// READ-ONLY; List of References to Assessments created on this group.
	Assessments []*string `json:"assessments,omitempty" azure:"ro"`

	// READ-ONLY; Time when this group was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Whether the group has been created and is valid.
	GroupStatus *GroupStatus `json:"groupStatus,omitempty" azure:"ro"`

	// READ-ONLY; Number of machines part of this group.
	MachineCount *int32 `json:"machineCount,omitempty" azure:"ro"`

	// READ-ONLY; Time when this group was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time `json:"updatedTimestamp,omitempty" azure:"ro"`
}

// GroupResultList - List of groups.
type GroupResultList struct {
	// List of groups.
	Value []*Group `json:"value,omitempty"`
}

// GroupsClientCreateOptions contains the optional parameters for the GroupsClient.Create method.
type GroupsClientCreateOptions struct {
	// New or Updated Group object.
	Group *Group
}

// GroupsClientDeleteOptions contains the optional parameters for the GroupsClient.Delete method.
type GroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GroupsClientGetOptions contains the optional parameters for the GroupsClient.Get method.
type GroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GroupsClientListByProjectOptions contains the optional parameters for the GroupsClient.ListByProject method.
type GroupsClientListByProjectOptions struct {
	// placeholder for future optional parameters
}

// GroupsClientUpdateMachinesOptions contains the optional parameters for the GroupsClient.UpdateMachines method.
type GroupsClientUpdateMachinesOptions struct {
	// Machines list to be added or removed from group.
	GroupUpdateProperties *UpdateGroupBody
}

type HyperVCollector struct {
	ETag       *string              `json:"eTag,omitempty"`
	Properties *CollectorProperties `json:"properties,omitempty"`

	// READ-ONLY
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HyperVCollectorList - List of Hyper-V collectors.
type HyperVCollectorList struct {
	// List of Hyper-V collectors.
	Value []*HyperVCollector `json:"value,omitempty"`
}

// HyperVCollectorsClientCreateOptions contains the optional parameters for the HyperVCollectorsClient.Create method.
type HyperVCollectorsClientCreateOptions struct {
	// New or Updated Hyper-V collector.
	CollectorBody *HyperVCollector
}

// HyperVCollectorsClientDeleteOptions contains the optional parameters for the HyperVCollectorsClient.Delete method.
type HyperVCollectorsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// HyperVCollectorsClientGetOptions contains the optional parameters for the HyperVCollectorsClient.Get method.
type HyperVCollectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HyperVCollectorsClientListByProjectOptions contains the optional parameters for the HyperVCollectorsClient.ListByProject
// method.
type HyperVCollectorsClientListByProjectOptions struct {
	// placeholder for future optional parameters
}

type ImportCollector struct {
	ETag       *string                    `json:"eTag,omitempty"`
	Properties *ImportCollectorProperties `json:"properties,omitempty"`

	// READ-ONLY
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImportCollectorList - List of Import collectors.
type ImportCollectorList struct {
	// List of Import collectors.
	Value []*ImportCollector `json:"value,omitempty"`
}

type ImportCollectorProperties struct {
	DiscoverySiteID *string `json:"discoverySiteId,omitempty"`

	// READ-ONLY
	CreatedTimestamp *string `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY
	UpdatedTimestamp *string `json:"updatedTimestamp,omitempty" azure:"ro"`
}

// ImportCollectorsClientCreateOptions contains the optional parameters for the ImportCollectorsClient.Create method.
type ImportCollectorsClientCreateOptions struct {
	// New or Updated Import collector.
	CollectorBody *ImportCollector
}

// ImportCollectorsClientDeleteOptions contains the optional parameters for the ImportCollectorsClient.Delete method.
type ImportCollectorsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ImportCollectorsClientGetOptions contains the optional parameters for the ImportCollectorsClient.Get method.
type ImportCollectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ImportCollectorsClientListByProjectOptions contains the optional parameters for the ImportCollectorsClient.ListByProject
// method.
type ImportCollectorsClientListByProjectOptions struct {
	// placeholder for future optional parameters
}

// Machine - A machine in a migration project.
type Machine struct {
	// For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`

	// Properties of the machine.
	Properties *MachineProperties `json:"properties,omitempty"`

	// READ-ONLY; Path reference to this machine. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/machines/{machineName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the machine. It is a GUID which is unique identifier of machine in private data center. For user-readable
	// name, we have a displayName property on this machine.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/machines].
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MachineProperties - Properties of a machine.
type MachineProperties struct {
	// READ-ONLY; Boot type of the machine.
	BootType *MachineBootType `json:"bootType,omitempty" azure:"ro"`

	// READ-ONLY; Time when this machine was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; ARM ID of the data center as tracked by the Microsoft.OffAzure.
	DatacenterManagementServerArmID *string `json:"datacenterManagementServerArmId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the server hosting the datacenter management solution.
	DatacenterManagementServerName *string `json:"datacenterManagementServerName,omitempty" azure:"ro"`

	// READ-ONLY; Description of the machine
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; ARM ID of the machine as tracked by the Microsoft.OffAzure.
	DiscoveryMachineArmID *string `json:"discoveryMachineArmId,omitempty" azure:"ro"`

	// READ-ONLY; Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object
	Disks map[string]*Disk `json:"disks,omitempty" azure:"ro"`

	// READ-ONLY; User readable name of the machine as defined by the user in their private datacenter.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; List of references to the groups that the machine is member of.
	Groups []*string `json:"groups,omitempty" azure:"ro"`

	// READ-ONLY; Memory in Megabytes.
	MegabytesOfMemory *float32 `json:"megabytesOfMemory,omitempty" azure:"ro"`

	// READ-ONLY; Dictionary of network adapters attached to the machine. Key is ID of network adapter. Value is a network adapter
	// object
	NetworkAdapters map[string]*NetworkAdapter `json:"networkAdapters,omitempty" azure:"ro"`

	// READ-ONLY; Processor count.
	NumberOfCores *int32 `json:"numberOfCores,omitempty" azure:"ro"`

	// READ-ONLY; Operating System name of the machine.
	OperatingSystemName *string `json:"operatingSystemName,omitempty" azure:"ro"`

	// READ-ONLY; Operating System type of the machine.
	OperatingSystemType *string `json:"operatingSystemType,omitempty" azure:"ro"`

	// READ-ONLY; Operating System version of the machine.
	OperatingSystemVersion *string `json:"operatingSystemVersion,omitempty" azure:"ro"`

	// READ-ONLY; Time when this machine was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time `json:"updatedTimestamp,omitempty" azure:"ro"`
}

// MachineResultList - List of machines.
type MachineResultList struct {
	NextLink *string `json:"nextLink,omitempty"`

	// List of machines.
	Value []*Machine `json:"value,omitempty"`
}

// MachinesClientGetOptions contains the optional parameters for the MachinesClient.Get method.
type MachinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// MachinesClientListByProjectOptions contains the optional parameters for the MachinesClient.ListByProject method.
type MachinesClientListByProjectOptions struct {
	// placeholder for future optional parameters
}

// NetworkAdapter - A network adapter discovered on a machine.
type NetworkAdapter struct {
	// READ-ONLY; User friendly name of the network adapter.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; List of IP Addresses on the network adapter.
	IPAddresses []*string `json:"ipAddresses,omitempty" azure:"ro"`

	// READ-ONLY; MAC Address of the network adapter.
	MacAddress *string `json:"macAddress,omitempty" azure:"ro"`
}

// Operation - A REST API operation supported by the provider.
type Operation struct {
	// READ-ONLY; Displayable properties of the operation.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; Name of the operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Origin of the operation.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Displayable properties of the operation.
type OperationDisplay struct {
	// READ-ONLY; Description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Operation Type.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Provider of the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource operated on by the operation.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationResultList - List of API operations.
type OperationResultList struct {
	// List of operations.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnection - A private endpoint connection for a project.
type PrivateEndpointConnection struct {
	// REQUIRED; Properties of the private endpoint endpoint connection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`

	// READ-ONLY; Path reference to this private endpoint endpoint connection.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateEndpointConnections/{privateEndpointConnectionName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the private endpoint endpoint connection.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/privateEndpointConnections].
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionClientDeleteOptions contains the optional parameters for the PrivateEndpointConnectionClient.Delete
// method.
type PrivateEndpointConnectionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientGetOptions contains the optional parameters for the PrivateEndpointConnectionClient.Get
// method.
type PrivateEndpointConnectionClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientListByProjectOptions contains the optional parameters for the PrivateEndpointConnectionClient.ListByProject
// method.
type PrivateEndpointConnectionClientListByProjectOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientUpdateOptions contains the optional parameters for the PrivateEndpointConnectionClient.Update
// method.
type PrivateEndpointConnectionClientUpdateOptions struct {
	// New or Updated Private Endpoint Connection object.
	PrivateEndpointConnectionBody *PrivateEndpointConnection
}

// PrivateEndpointConnectionCollection - A collection of private endpoint connections for a project.
type PrivateEndpointConnectionCollection struct {
	// READ-ONLY
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of private endpoint connections for a project.
	Value []*PrivateEndpointConnection `json:"value,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - Private endpoint connection properties.
type PrivateEndpointConnectionProperties struct {
	// State of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; ARM id for the private endpoint resource corresponding to the connection.
	PrivateEndpoint *ResourceID `json:"privateEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether there is an ongoing operation on the private endpoint.
	ProvisioningState *PrivateEndpointConnectionPropertiesProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateLinkResource - A private link resource for a project for which a private endpoint can be created.
type PrivateLinkResource struct {
	// READ-ONLY; Path reference to this private link resource.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateLinkResources/{privateLinkResourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the private link resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Properties of the private link resource.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/privateLinkResources].
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceClientGetOptions contains the optional parameters for the PrivateLinkResourceClient.Get method.
type PrivateLinkResourceClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourceClientListByProjectOptions contains the optional parameters for the PrivateLinkResourceClient.ListByProject
// method.
type PrivateLinkResourceClientListByProjectOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourceCollection - A list of private link resources
type PrivateLinkResourceCollection struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource `json:"value,omitempty" azure:"ro"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`

	// READ-ONLY; Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty" azure:"ro"`
}

// PrivateLinkServiceConnectionState - State of a private endpoint connection.
type PrivateLinkServiceConnectionState struct {
	// Actions required on the private endpoint connection.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// Description of the private endpoint connection.
	Description *string `json:"description,omitempty"`

	// Connection status of the private endpoint connection.
	Status *PrivateLinkServiceConnectionStateStatus `json:"status,omitempty"`
}

// Project - Azure Migrate Project.
type Project struct {
	// For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`

	// Azure location in which project is created.
	Location *string `json:"location,omitempty"`

	// Properties of the project.
	Properties *ProjectProperties `json:"properties,omitempty"`

	// Tags provided by Azure Tagging service.
	Tags interface{} `json:"tags,omitempty"`

	// READ-ONLY; Path reference to this project /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the project.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects].
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProjectProperties - Properties of a project.
type ProjectProperties struct {
	// Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
	AssessmentSolutionID *string `json:"assessmentSolutionId,omitempty"`

	// The ARM id of the storage account used for interactions when public access is disabled.
	CustomerStorageAccountArmID *string `json:"customerStorageAccountArmId,omitempty"`

	// The ARM id of service map workspace created by customer.
	CustomerWorkspaceID *string `json:"customerWorkspaceId,omitempty"`

	// Location of service map workspace created by customer.
	CustomerWorkspaceLocation *string `json:"customerWorkspaceLocation,omitempty"`

	// Assessment project status.
	ProjectStatus *ProjectStatus `json:"projectStatus,omitempty"`

	// This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled',
	// traffic over public interface is not allowed, and private endpoint
	// connections would be the exclusive access method.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Time when last assessment was created. Date-Time represented in ISO-8601 format. This value will be null until
	// assessment is created.
	LastAssessmentTimestamp *time.Time `json:"lastAssessmentTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Number of assessments created in the project.
	NumberOfAssessments *int32 `json:"numberOfAssessments,omitempty" azure:"ro"`

	// READ-ONLY; Number of groups created in the project.
	NumberOfGroups *int32 `json:"numberOfGroups,omitempty" azure:"ro"`

	// READ-ONLY; Number of machines in the project.
	NumberOfMachines *int32 `json:"numberOfMachines,omitempty" azure:"ro"`

	// READ-ONLY; The list of private endpoint connections to the project.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the project.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Endpoint at which the collector agent can call agent REST API.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time `json:"updatedTimestamp,omitempty" azure:"ro"`
}

// ProjectResultList - List of projects.
type ProjectResultList struct {
	NextLink *string `json:"nextLink,omitempty"`

	// List of projects.
	Value []*Project `json:"value,omitempty"`
}

// ProjectsClientAssessmentOptionsListOptions contains the optional parameters for the ProjectsClient.AssessmentOptionsList
// method.
type ProjectsClientAssessmentOptionsListOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientAssessmentOptionsOptions contains the optional parameters for the ProjectsClient.AssessmentOptions method.
type ProjectsClientAssessmentOptionsOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientCreateOptions contains the optional parameters for the ProjectsClient.Create method.
type ProjectsClientCreateOptions struct {
	// New or Updated project object.
	Project *Project
}

// ProjectsClientDeleteOptions contains the optional parameters for the ProjectsClient.Delete method.
type ProjectsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientGetOptions contains the optional parameters for the ProjectsClient.Get method.
type ProjectsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientListBySubscriptionOptions contains the optional parameters for the ProjectsClient.ListBySubscription method.
type ProjectsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientListOptions contains the optional parameters for the ProjectsClient.List method.
type ProjectsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProjectsClientUpdateOptions contains the optional parameters for the ProjectsClient.Update method.
type ProjectsClientUpdateOptions struct {
	// Updated project object.
	Project *Project
}

// ResourceID - ARM id for a resource.
type ResourceID struct {
	// READ-ONLY
	ID *string `json:"id,omitempty" azure:"ro"`
}

type ServerCollector struct {
	ETag       *string              `json:"eTag,omitempty"`
	Properties *CollectorProperties `json:"properties,omitempty"`

	// READ-ONLY
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerCollectorList - List of Server collectors.
type ServerCollectorList struct {
	// List of Server collectors.
	Value []*ServerCollector `json:"value,omitempty"`
}

// ServerCollectorsClientCreateOptions contains the optional parameters for the ServerCollectorsClient.Create method.
type ServerCollectorsClientCreateOptions struct {
	// New or Updated Server collector.
	CollectorBody *ServerCollector
}

// ServerCollectorsClientDeleteOptions contains the optional parameters for the ServerCollectorsClient.Delete method.
type ServerCollectorsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServerCollectorsClientGetOptions contains the optional parameters for the ServerCollectorsClient.Get method.
type ServerCollectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerCollectorsClientListByProjectOptions contains the optional parameters for the ServerCollectorsClient.ListByProject
// method.
type ServerCollectorsClientListByProjectOptions struct {
	// placeholder for future optional parameters
}

// UpdateGroupBody - Properties of group update.
type UpdateGroupBody struct {
	// For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`

	// Properties of the group.
	Properties *GroupBodyProperties `json:"properties,omitempty"`
}

// VMFamily - VM family name, the list of targeted azure locations and the category of the family.
type VMFamily struct {
	// READ-ONLY; Category of the VM family.
	Category []*string `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; Name of the VM family.
	FamilyName *string `json:"familyName,omitempty" azure:"ro"`

	// READ-ONLY; List of Azure regions.
	TargetLocations []*string `json:"targetLocations,omitempty" azure:"ro"`
}

type VMUptime struct {
	// Number of days in a month for VM uptime.
	DaysPerMonth *int32 `json:"daysPerMonth,omitempty"`

	// Number of hours per day for VM uptime.
	HoursPerDay *int32 `json:"hoursPerDay,omitempty"`
}

type VMwareCollector struct {
	ETag       *string              `json:"eTag,omitempty"`
	Properties *CollectorProperties `json:"properties,omitempty"`

	// READ-ONLY
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VMwareCollectorList - List of VMware collectors.
type VMwareCollectorList struct {
	// List of VMware collectors.
	Value []*VMwareCollector `json:"value,omitempty"`
}

// VMwareCollectorsClientCreateOptions contains the optional parameters for the VMwareCollectorsClient.Create method.
type VMwareCollectorsClientCreateOptions struct {
	// New or Updated VMware collector.
	CollectorBody *VMwareCollector
}

// VMwareCollectorsClientDeleteOptions contains the optional parameters for the VMwareCollectorsClient.Delete method.
type VMwareCollectorsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// VMwareCollectorsClientGetOptions contains the optional parameters for the VMwareCollectorsClient.Get method.
type VMwareCollectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VMwareCollectorsClientListByProjectOptions contains the optional parameters for the VMwareCollectorsClient.ListByProject
// method.
type VMwareCollectorsClientListByProjectOptions struct {
	// placeholder for future optional parameters
}
