////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// Implementation file
//
// Copyright (c) 2002-2011 IOhannes m zmölnig. forum::für::umläute. IEM. zmoelnig@iem.at
//      zmoelnig@iem.at
//  For information on usage and redistribution, and for a DISCLAIMER
//  *  OF ALL WARRANTIES, see the file, "GEM.LICENSE.TERMS"
//
//  this file has been generated...
////////////////////////////////////////////////////////

#include "GEMglFogi.h"

CPPEXTERN_NEW_WITH_TWO_ARGS ( GEMglFogi, t_floatarg, A_DEFFLOAT,
                              t_floatarg, A_DEFFLOAT);

/////////////////////////////////////////////////////////
//
// GEMglViewport
//
/////////////////////////////////////////////////////////
// Constructor
//
GEMglFogi :: GEMglFogi  (t_floatarg arg0, t_floatarg arg1) :
  pname(static_cast<GLenum>(arg0)),
  param(static_cast<GLint>(arg1))
{
  m_inlet[0] = inlet_new(this->x_obj, &this->x_obj->ob_pd, &s_float,
                         gensym("pname"));
  m_inlet[1] = inlet_new(this->x_obj, &this->x_obj->ob_pd, &s_float,
                         gensym("param"));
}
/////////////////////////////////////////////////////////
// Destructor
//
GEMglFogi :: ~GEMglFogi ()
{
  inlet_free(m_inlet[0]);
  inlet_free(m_inlet[1]);
}

//////////////////
// extension check
bool GEMglFogi :: isRunnable(void)
{
  if(GLEW_VERSION_1_1) {
    return true;
  }
  error("your system does not support OpenGL-1.1");
  return false;
}

/////////////////////////////////////////////////////////
// Render
//
void GEMglFogi :: render(GemState *state)
{
  glFogi (pname, param);
}

/////////////////////////////////////////////////////////
// Variables
//
void GEMglFogi :: pnameMess (t_float arg1)      // FUN
{
  pname = static_cast<GLenum>(arg1);
  setModified();
}

void GEMglFogi :: paramMess (t_float arg1)      // FUN
{
  param = static_cast<GLint>(arg1);
  setModified();
}


/////////////////////////////////////////////////////////
// static member functions
//

void GEMglFogi :: obj_setupCallback(t_class *classPtr)
{
  class_addmethod(classPtr,
                  reinterpret_cast<t_method>(&GEMglFogi::pnameMessCallback),
                  gensym("pname"), A_DEFFLOAT, A_NULL);
  class_addmethod(classPtr,
                  reinterpret_cast<t_method>(&GEMglFogi::paramMessCallback),
                  gensym("param"), A_DEFFLOAT, A_NULL);
}

void GEMglFogi :: pnameMessCallback (void* data, t_float arg0)
{
  GetMyClass(data)->pnameMess ( static_cast<t_float>(arg0));
}
void GEMglFogi :: paramMessCallback (void* data, t_float arg0)
{
  GetMyClass(data)->paramMess ( static_cast<t_float>(arg0));
}
