import { VerdaConfig } from "../config";
import Director from "../core/director";
import { Dependency, ExportBuildRecipe, ExtBuildContext, GoalFunction, GoalMatcher, PreBuildContext, PreBuildResult, Rule } from "../core/interface";
import { DirContents, ParsedPath } from "../match/interface";
import ParsedPathImpl from "../match/parse-path";
import { FileStatInfo } from "./interface";
import { FileExecArgs } from "./matchers";
import { RuleBase } from "./rule-base";
declare class FileStatInfoImpl extends ParsedPathImpl implements FileStatInfo {
    readonly present: boolean;
    readonly updated: string;
    readonly hash: string;
    constructor(s: string, updated?: Date, hash?: string);
    notChanged(that: null | undefined | FileStatInfo): boolean;
    optionalFileNotChanged(that: null | undefined | FileStatInfo): boolean;
}
export declare function pathParseAndUpdate(s: string): Promise<FileStatInfoImpl>;
export declare class FileUpdatedRule extends RuleBase<FileExecArgs> implements Rule<FileStatInfo, FileExecArgs> {
    readonly kindTag = "Builtin::FileUpdateRule";
    constructor(matcher: GoalMatcher<FileExecArgs>);
    build(target: ExtBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<FileStatInfoImpl>;
    preBuild(target: PreBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<PreBuildResult.TIME | PreBuildResult.YES>;
}
export declare class OptionalFileUpdatedRule extends RuleBase<FileExecArgs> implements Rule<FileStatInfo, FileExecArgs> {
    readonly kindTag = "Builtin::OptionalFileUpdateRule";
    constructor(matcher: GoalMatcher<FileExecArgs>);
    build(target: ExtBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<FileStatInfoImpl>;
    preBuild(target: PreBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<PreBuildResult.TIME | PreBuildResult.YES>;
}
export declare class SourceFileUpdatedRule extends RuleBase<FileExecArgs> implements Rule<FileStatInfo, FileExecArgs> {
    readonly kindTag = "Builtin::SourceFileUpdatedRule";
    constructor(matcher: GoalMatcher<FileExecArgs>);
    build(target: ExtBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<FileStatInfoImpl>;
    preBuild(target: PreBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<PreBuildResult.TIME | PreBuildResult.YES>;
}
export declare class FileExistsRule extends RuleBase<FileExecArgs> implements Rule<FileStatInfo, FileExecArgs> {
    readonly kindTag = "Builtin::FileExistsRule";
    constructor(matcher: GoalMatcher<FileExecArgs>);
    matchString(id: string): null;
    build(target: ExtBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<FileStatInfoImpl>;
    preBuild(target: PreBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<PreBuildResult.NO | PreBuildResult.YES>;
}
export declare class DirExistsRule extends RuleBase<FileExecArgs> implements Rule<FileStatInfo, FileExecArgs> {
    readonly kindTag = "Builtin::DirExistsRule";
    constructor(matcher: GoalMatcher<FileExecArgs>);
    matchString(id: string): null;
    build(target: ExtBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<FileStatInfoImpl>;
    preBuild(target: PreBuildContext<FileStatInfo>, $1: ParsedPathImpl): Promise<PreBuildResult.NO | PreBuildResult.YES>;
}
export declare function File(cfg: VerdaConfig, dir: Director): {
    file: ((pattern: string, FRecipe: ExportBuildRecipe<void, FileExecArgs>) => import("../core/interface").Goal<FileStatInfo, [ParsedPath, ...string[]]>) & {
        glob: (pattern: string, FRecipe: ExportBuildRecipe<void, FileExecArgs>) => (literals: string | TemplateStringsArray, ...placeholders: unknown[]) => import("../core/interface").Goal<FileStatInfo, [ParsedPath, ...string[]]>;
        make: <K extends string[]>(mk: (...args: K) => string, FRecipe: ExportBuildRecipe<void, FileExecArgs>) => (...args: K) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
        getPathOf(goal: Dependency): ParsedPath;
    };
};
export declare function ImplicitFileRules(cfg: VerdaConfig, dir: Director): {
    F: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    S: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    D: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    fu: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    fileUpdated: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    sfu: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    sourceFileUpdated: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    ofu: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    optionalFileUpdated: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    fe: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    fileExists: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    de: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    dirExists: (literals: string | TemplateStringsArray, ...placeholders: string[]) => import("../core/interface").Goal<FileStatInfo, FileExecArgs>;
    dc: GoalFunction<DirContents, string[]>;
    dirContent: GoalFunction<DirContents, string[]>;
    ds: GoalFunction<DirContents, string[]>;
    dirStructure: GoalFunction<DirContents, string[]>;
};
export {};
