# Security Policies and Procedures

This document outlines security procedures and general policies for the Cylc
project.

  * [Reporting a Bug](#reporting-a-bug)
  * [Disclosure Policy](#disclosure-policy)
  * [Comments on this Policy](#comments-on-this-policy)

## Reporting a Bug

The Cylc maintainers take security bugs seriously. Thank you for improving the
security of Cylc. We appreciate your efforts and responsible disclosure and
will make every effort to acknowledge your contributions.

Please report security bugs by sending an email to the lead Cylc maintainers,
[Hilary Oliver](mailto:hilary.oliver@niwa.co.nz) and [Oliver
Sanders](mailto:oliver.sanders@metoffice.gov.uk). If a fix is needed, progress will be
recorded on Cylc repository Issue page on GitHub, and resulting new releases
will be announced on the Cylc [Discourse forum](https://cylc.discourse.group/).

Report security bugs in third-party modules to the person or team maintaining
the module.

## Disclosure Policy

When the Cylc maintainers receive a security bug report, they will assign it to
a primary handler. This person will coordinate the fix and release process as
follows:

  * Confirm the problem and determine the affected versions.
  * Audit code to find any potential similar problems.
  * Prepare fixes for all releases still under maintenance. These fixes will be
    released as fast as possible.

## Comments on this Policy

If you have suggestions on how this process could be improved please submit a
pull request.
