    #      4              L  O  M  	                     o  a                    _   5  O         u        j	     <
  F       X          
       U   !  g   w         a     n  :   *  7   e            o                  ]    /      X  r       (         '     f   ,       *                 z     L   v   `   $     2  !    /#     $    i%     o&     '  o   U(  w   (     =)  L  )    3+  Q   8,  h   ,  (   ,     -     .     .     /    0   A shape is always created as a **child of a page**, usually with an instruction like `shape = page.new_shape()`. The class defines numerous methods that perform drawing operations on the page's area. For example, `last_point = shape.draw_rect(rect)` draws a rectangle along the borders of a suitably defined `rect = pymupdf.Rect(...)`. As can be seen, there is a high congruence level with the :ref:`Shape` class. With one exception: For technical reasons `lineCap` is a tuple of 3 numbers here, whereas it is an integer in :ref:`Shape` (and in PDF). So we simply take the maximum value of that tuple. Drawing and Graphics Drawing commands (**vector graphics**) issued by a page can be extracted as a list of dictionaries. Interestingly, this is possible for :ref:`all supported document types<Supported_File_Types>` -- not just PDF: so you can use it for XPS, EPUB and others as well. Drawing graphics is as simple as calling the type of :meth:`Drawing Method <Page.draw_line>` you may want. You can draw graphics directly on pages or within shape objects. For example, to draw a circle:: Here is a comparison between input and output of an example page, created by the previous script: How to Delete Drawings How to Draw Graphics How to Extract Drawings If you import this script, you can also directly use its graphics as in the following example:: In fact, :meth:`Shape.finish` *defines* a group of preceding draw operations to form one -- potentially rather complex -- graphics object. |PyMuPDF| provides several predefined graphics in `shapes_and_symbols.py <https://github.com/pymupdf/PyMuPDF-Utilities/blob/master/shapes/shapes_and_symbols.py>`_ which demonstrate how this works. New in v1.18.0 PDF Text Extraction, PDF Image Extraction, PDF Conversion, PDF Tables, PDF Splitting, PDF Creation, Pyodide, PyScript PDF files support elementary drawing operations as part of their syntax. These are **vector graphics** and include basic geometrical objects like lines, curves, circles, rectangles including specifying colors. Page definitions can be complex and include instructions for not showing / hiding certain areas to keep them invisible. Things like this are ignored by :meth:`Page.get_drawings` - it will always return all paths. Page method, :meth:`Page.get_drawings()` accesses draw commands and converts them into a list of Python dictionaries. Each dictionary -- called a "path" -- represents a separate drawing -- it may be simple like a single line, or a complex combination of lines and curves representing one of the shapes of the previous section. PyMuPDF is a high-performance Python library for data extraction, analysis, conversion & manipulation of PDF (and other) documents. See :meth:`Page.apply_redactions` for the parameter options which can be sent - you are able to apply deletion options to image, drawing and text objects which are bound by the annotation area. The *path* dictionary has been designed such that it can easily be used by the :ref:`Shape` class and its methods. Here is an example for a page with one path, that draws a red-bordered yellow circle inside rectangle `Rect(100, 100, 200, 200)`:: The :ref:`Shape` object can be used to combine multiple drawings that should receive common properties as specified by :meth:`Shape.finish`. The following code shows an example of deleting the first drawing found on the page:: The following is a code snippet which extracts the drawings of a page and re-draws them on a new page:: The reconstruction of graphics, like shown here, is not perfect. The following aspects will not be reproduced as of this version: The returned *last_point* **always** is the :ref:`Point` where drawing operation ended ("last point"). Every such elementary drawing requires a subsequent :meth:`Shape.finish` to "close" it, but there may be multiple drawings which have one common ``finish()`` method. The syntax for such operations is defined in "A Operator Summary" on page 643 of the :ref:`AdobeManual`. Specifying these operators for a PDF page happens in its :data:`contents` objects. Therefore please consider these terms as being synonymous! This documentation covers all versions up to |version|. This is the script's outcome: To delete drawings/vector graphics we must use a :ref:`Redaction Annotation <The_Basics_Redacting>` with the bounding box of the drawing and then **add and apply** a redaction to it to delete it. When the terms "Drawings" or "Graphics" are mentioned here we are referring to "Vector Graphics" or "Line Art". You can use the path list to make your own lists of e.g. all lines or all rectangles on the page and subselect them by criteria, like color or position on the page etc. You need (at least) 4 Bézier curves (of 3rd order) to draw a circle with acceptable precision. See this `Wikipedia article <https://en.wikipedia.org/wiki/B%C3%A9zier_curve>`_ for some background. |PyMuPDF| implements a large part of the available features via its :ref:`Shape` class, which is comparable to notions like "canvas" in other packages (e.g. `reportlab <https://pypi.org/project/reportlab/>`_). Project-Id-Version: PyMuPDF 1.23.0rc1
Report-Msgid-Bugs-To: 
POT-Creation-Date: 2024-05-01 16:48+0100
PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE
Last-Translator: Suzan Sanver <suzan.sanver@dijipiji.com>
Language: ja
Language-Team: ja <suzan.sanver@dijipiji.com>
Plural-Forms: nplurals=1; plural=0;
MIME-Version: 1.0
Content-Type: text/plain; charset=utf-8
Content-Transfer-Encoding: 8bit
Generated-By: Babel 2.10.3
 シェイプは常にページの子として作成され、通常は `shape = page.new_shape()` のような命令で行います。このクラスは、ページの領域に描画操作を実行するための多数のメソッドを定義しています。たとえば、 `last_point = shape.draw_rect(rect)` は、適切に定義された `rect = pymupdf.Rect(…)` の境界に沿って四角形を描画します。 ご覧の通り、 :ref:`Shape` クラスとの高い一致度があります。ただし1つ例外があります。技術的な理由から、ここでは `lineCap` は3つの数字のタプルですが、 :ref:`Shape` クラス（およびPDF内）では整数です。そのため、そのタプルの最大値を単純に取得します。 描画とグラフィックス ページから発行された描画コマンドを抽出できます。興味深いことに、これはすべての :ref:`サポートされている <Supported_File_Types>` ドキュメントタイプに対して可能です – PDFだけでなく、XPS、EPUBなどにも使用できます。 グラフィックスを描画することは、必要な :meth:`描画方法 <Page.draw_line>` の種類を呼び出すだけです。グラフィックスは、ページ上または形状オブジェクト内に直接描画できます。 例えば、円を描画するには： 以下は、前のスクリプトで作成された例のページの入力と出力の比較です。 描画の削除方法 グラフィックスを描画する方法 描画の抽出方法 このスクリプトをインポートすると、次の例のようにそのグラフィックスを直接使用することもできます:: 実際には、 :meth:`Shape.finish` は、1つの（潜在的に非常に複雑な）グラフィックオブジェクトを形成するための前の描画操作のグループを定義します。PyMuPDFは、これがどのように機能するかを示す `shapes_and_symbols.py <https://github.com/pymupdf/PyMuPDF-Utilities/blob/master/shapes/shapes_and_symbols.py>`_ 内のいくつかの事前定義されたグラフィックスを提供しています。 v1.18.0で新登場 PDFテキスト抽出、PDFイメージ抽出、PDF変換、PDFテーブル、PDF分割、PDF作成, Pyodide, PyScript PDFファイルは、その構文の一部として基本的な描画操作をサポートしています。これらは**ベクトルグラフィックス**であり、線、曲線、円、長方形などの基本的な幾何学的オブジェクトを含み、色の指定も可能です。 ページの定義は複雑になる可能性があり、特定の領域を表示しない/非表示にするための指示を含むことがあります。こうしたことは、 :meth:`Page.get_drawings` によって無視されます – このメソッドは常にすべてのパスを返します。 :ref:`Page` メソッド、:meth:`Page.get_drawings()` は描画コマンドにアクセスし、それらをPythonの辞書のリストに変換します。各辞書 – 「パス」と呼ばれる – は個別の描画を表します – それは単純な単一の線であるか、前のセクションの形状の1つを表す線と曲線の複雑な組み合わせであるかもしれません。 PyMuPDF は、PDF （およびその他の）ドキュメントのデータ抽出、分析、変換、操作のための高性能な Python ライブラリです。 :meth:`Page.apply_redactions` には送信できるパラメータオプションがあります。アノテーション領域によって境界付けられたイメージ、描画、テキストオブジェクトに削除オプションを適用できます。 パスの辞書は、 :ref:`Shape` クラスとそのメソッドで簡単に使用できるように設計されています。以下は、1つのパスを持つページの例で、そのパスは `Rect(100, 100, 200, 200)` の内側に赤い境界線の黄色い円を描画します:: :ref:`Shape` オブジェクトは、:meth:`Shape.finish` で指定された共通のプロパティを受け取る必要がある複数の描画を組み合わせるために使用できます。 以下のコードは、ページ上で最初に見つかった描画を削除する例を示しています： 以下は、ページの描画を抽出し、それらを新しいページに再描画するコードの断片です:: ここに示されているようなグラフィックスの再構築は完璧ではありません。次の点は、このバージョンでは再現されません： 返されるlast_pointは常に描画操作が終了する :ref:`Point` （「最後のポイント」）です。このような基本的な描画ごとに、それを「閉じる」ために :meth:`Shape.finish` が必要ですが、1つの共通の``finish()``メソッドを持つ複数の描画があるかもしれません。 このような操作の構文は、:ref:`AdobeManual` の「A Operator Summary」のページ643で定義されています。PDFページのためのこれらのオペレータは、その内容 (:data:`contents`)オブジェクト内で指定されます。 したがって、これらの用語を同義語として考えてください。 このドキュメントは |version| までのすべてのバージョンを対象としています。 これがスクリプトの結果です: 描画やベクトルグラフィックスを削除するには、その描画の境界ボックスを持つ :ref:`赤字アノテーション<The_Basics_Redacting>` を使用し、それに赤字を **追加して適用する** 必要があります。 ここで「Drawings」や「Graphics」という用語が言及されている場合、それは「ベクトルグラフィックス」や「線画」を指しています。 パスのリストを使用して、ページ上のすべての線またはすべての四角形などのリストを作成し、色やページ上の位置などの基準でサブセレクトすることができます。 適切な精度で円を描画するには、（少なくとも）4つの3次ベジエ曲線が必要です。背景については、この `Wikipediaの記事 <https://en.wikipedia.org/wiki/B%C3%A9zier_curve>`_ を参照してください。 PyMuPDFは、 :ref:`Shape` クラスを介して利用可能な多くの機能を実装しており、これは他のパッケージ（例： `reportlab <https://pypi.org/project/reportlab/>`_ など）の「キャンバス」のような概念と類似しています。 